/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.prefuse.examples.radialgraphview;

import org.eclipse.modisco.prefuse.examples.radialgraphview.NodeColorAction;
import org.eclipse.modisco.prefuse.examples.radialgraphview.TextColorAction;
import org.eclipse.modisco.prefuse.examples.radialgraphview.TreeRootAction;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.animate.ColorAnimator;
import prefuse.action.animate.PolarLocationAnimator;
import prefuse.action.animate.QualityControlAnimator;
import prefuse.action.animate.VisibilityAnimator;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.FontAction;
import prefuse.action.layout.CollapsedSubtreeLayout;
import prefuse.action.layout.graph.RadialTreeLayout;
import prefuse.activity.SlowInSlowOutPacer;
import prefuse.controls.DragControl;
import prefuse.controls.FocusControl;
import prefuse.controls.HoverActionControl;
import prefuse.controls.PanControl;
import prefuse.controls.ZoomControl;
import prefuse.controls.ZoomToFitControl;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.search.PrefixSearchTupleSet;
import prefuse.data.tuple.DefaultTupleSet;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.EdgeRenderer;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.util.ColorLib;
import prefuse.util.FontLib;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.InGroupPredicate;
import prefuse.visual.sort.TreeDepthItemSorter;

public class RadialGraphView
extends Display {
    private LabelRenderer m_nodeRenderer;
    private EdgeRenderer m_edgeRenderer;
    private String m_label = "label";

    public RadialGraphView(Graph g, String label) {
        super(new Visualization());
        this.m_label = label;
        this.m_vis.add("tree", g);
        this.m_vis.setInteractive("tree.edges", null, false);
        this.m_nodeRenderer = new LabelRenderer(this.m_label);
        this.m_nodeRenderer.setRenderType(2);
        this.m_nodeRenderer.setHorizontalAlignment(2);
        this.m_nodeRenderer.setRoundedCorner(8, 8);
        this.m_edgeRenderer = new EdgeRenderer();
        DefaultRendererFactory rf = new DefaultRendererFactory(this.m_nodeRenderer);
        rf.add(new InGroupPredicate("tree.edges"), (Renderer)this.m_edgeRenderer);
        this.m_vis.setRendererFactory(rf);
        NodeColorAction nodeColor = new NodeColorAction("tree.nodes");
        TextColorAction textColor = new TextColorAction("tree.nodes");
        this.m_vis.putAction("textColor", textColor);
        ColorAction edgeColor = new ColorAction("tree.edges", VisualItem.STROKECOLOR, ColorLib.rgb(200, 200, 200));
        FontAction fonts = new FontAction("tree.nodes", FontLib.getFont("Tahoma", 10.0));
        fonts.add("ingroup('_focus_')", FontLib.getFont("Tahoma", 11.0));
        ActionList recolor = new ActionList();
        recolor.add(nodeColor);
        recolor.add(textColor);
        this.m_vis.putAction("recolor", recolor);
        ActionList repaint = new ActionList();
        repaint.add(recolor);
        repaint.add(new RepaintAction());
        this.m_vis.putAction("repaint", repaint);
        ActionList animatePaint = new ActionList(400L);
        animatePaint.add(new ColorAnimator("tree.nodes"));
        animatePaint.add(new RepaintAction());
        this.m_vis.putAction("animatePaint", animatePaint);
        RadialTreeLayout treeLayout = new RadialTreeLayout("tree");
        this.m_vis.putAction("treeLayout", treeLayout);
        CollapsedSubtreeLayout subLayout = new CollapsedSubtreeLayout("tree");
        this.m_vis.putAction("subLayout", subLayout);
        ActionList filter = new ActionList();
        filter.add(new TreeRootAction("tree"));
        filter.add(fonts);
        filter.add(treeLayout);
        filter.add(subLayout);
        filter.add(textColor);
        filter.add(nodeColor);
        filter.add(edgeColor);
        this.m_vis.putAction("filter", filter);
        ActionList animate = new ActionList(1250L);
        animate.setPacingFunction(new SlowInSlowOutPacer());
        animate.add(new QualityControlAnimator());
        animate.add(new VisibilityAnimator("tree"));
        animate.add(new PolarLocationAnimator("tree.nodes", "linear"));
        animate.add(new ColorAnimator("tree.nodes"));
        animate.add(new RepaintAction());
        this.m_vis.putAction("animate", animate);
        this.m_vis.alwaysRunAfter("filter", "animate");
        this.setSize(700, 600);
        this.setItemSorter(new TreeDepthItemSorter());
        this.addControlListener(new DragControl());
        this.addControlListener(new ZoomToFitControl());
        this.addControlListener(new ZoomControl());
        this.addControlListener(new PanControl());
        this.addControlListener(new FocusControl(1, "filter"));
        this.addControlListener(new HoverActionControl("repaint"));
        this.m_vis.run("filter");
        this.m_vis.addFocusGroup("linear", new DefaultTupleSet());
        this.m_vis.getGroup(Visualization.FOCUS_ITEMS).addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet t, Tuple[] add, Tuple[] rem) {
                TupleSet linearInterp = RadialGraphView.this.m_vis.getGroup("linear");
                if (add.length < 1) {
                    return;
                }
                linearInterp.clear();
                Node n = (Node)add[0];
                while (n != null) {
                    linearInterp.addTuple(n);
                    n = n.getParent();
                }
            }
        });
        PrefixSearchTupleSet search = new PrefixSearchTupleSet();
        this.m_vis.addFocusGroup(Visualization.SEARCH_ITEMS, search);
        search.addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet t, Tuple[] add, Tuple[] rem) {
                RadialGraphView.this.m_vis.cancel("animatePaint");
                RadialGraphView.this.m_vis.run("recolor");
                RadialGraphView.this.m_vis.run("animatePaint");
            }
        });
    }
}

