/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.prefuse.examples.treeview;

import java.awt.geom.Point2D;
import org.eclipse.modisco.prefuse.examples.treeview.TreeView;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.data.tuple.TupleSet;
import prefuse.visual.VisualItem;

public class AutoPanAction
extends Action {
    private Point2D m_start = new Point2D.Double();
    private Point2D m_end = new Point2D.Double();
    private Point2D m_cur = new Point2D.Double();
    private int m_bias = 150;
    private final TreeView treeView;

    public AutoPanAction(TreeView treeViewParameter) {
        this.treeView = treeViewParameter;
    }

    public void run(double frac) {
        TupleSet ts = this.m_vis.getFocusGroup(Visualization.FOCUS_ITEMS);
        if (ts.getTupleCount() == 0) {
            return;
        }
        if (frac == 0.0) {
            int xbias = 0;
            int ybias = 0;
            switch (this.treeView.getOrientation()) {
                case 0: {
                    xbias = this.m_bias;
                    break;
                }
                case 1: {
                    xbias = -this.m_bias;
                    break;
                }
                case 2: {
                    ybias = this.m_bias;
                    break;
                }
                case 3: {
                    ybias = -this.m_bias;
                }
            }
            VisualItem vi = (VisualItem)ts.tuples().next();
            this.m_cur.setLocation(this.treeView.getWidth() / 2, this.treeView.getHeight() / 2);
            this.treeView.getAbsoluteCoordinate(this.m_cur, this.m_start);
            this.m_end.setLocation(vi.getX() + (double)xbias, vi.getY() + (double)ybias);
        } else {
            this.m_cur.setLocation(this.m_start.getX() + frac * (this.m_end.getX() - this.m_start.getX()), this.m_start.getY() + frac * (this.m_end.getY() - this.m_start.getY()));
            this.treeView.panToAbs(this.m_cur);
        }
    }
}

