/*
 * Decompiled with CFR 0.152.
 */
package prefuse;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import prefuse.Visualization;
import prefuse.activity.Activity;
import prefuse.activity.SlowInSlowOutPacer;
import prefuse.controls.Control;
import prefuse.data.expression.AndPredicate;
import prefuse.data.expression.BooleanLiteral;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.render.Renderer;
import prefuse.util.ColorLib;
import prefuse.util.StringLib;
import prefuse.util.UpdateListener;
import prefuse.util.display.BackgroundPainter;
import prefuse.util.display.Clip;
import prefuse.util.display.DebugStatsPainter;
import prefuse.util.display.ExportDisplayAction;
import prefuse.util.display.ItemBoundsListener;
import prefuse.util.display.PaintListener;
import prefuse.util.display.RenderingQueue;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.VisiblePredicate;
import prefuse.visual.sort.ItemSorter;

public class Display
extends JComponent {
    private static final Logger s_logger = Logger.getLogger(Display.class.getName());
    protected Visualization m_vis;
    protected AndPredicate m_predicate = new AndPredicate();
    protected CopyOnWriteArrayList<Control> m_controls = new CopyOnWriteArrayList();
    protected CopyOnWriteArrayList<PaintListener> m_painters;
    protected CopyOnWriteArrayList<ItemBoundsListener> m_bounders;
    protected BufferedImage m_offscreen;
    protected Clip m_clip = new Clip();
    protected Clip m_screen = new Clip();
    protected Clip m_bounds = new Clip();
    protected Rectangle2D m_rclip = new Rectangle2D.Double();
    protected boolean m_damageRedraw = true;
    protected boolean m_highQuality = false;
    protected BackgroundPainter m_bgpainter = null;
    protected RenderingQueue m_queue = new RenderingQueue();
    protected int m_visibleCount = 0;
    protected AffineTransform m_transform = new AffineTransform();
    protected AffineTransform m_itransform = new AffineTransform();
    protected TransformActivity m_transact = new TransformActivity();
    protected Point2D m_tmpPoint = new Point2D.Double();
    protected double frameRate;
    protected int nframes = 0;
    private int sampleInterval = 10;
    private long mark = -1L;
    protected JToolTip m_customToolTip = null;
    private JTextComponent m_editor;
    private boolean m_editing;
    private VisualItem m_editItem;
    private String m_editAttribute;

    public Display() {
        this(null);
    }

    public Display(Visualization visualization) {
        this(visualization, (Predicate)null);
    }

    public Display(Visualization visualization, String predicate) {
        this(visualization, (Predicate)ExpressionParser.parse(predicate, true));
    }

    public Display(Visualization visualization, Predicate predicate) {
        this.setDoubleBuffered(false);
        this.setBackground(Color.WHITE);
        this.m_editing = false;
        this.m_editor = new JTextField();
        this.m_editor.setBorder(null);
        this.m_editor.setVisible(false);
        this.add(this.m_editor);
        InputEventCapturer iec = new InputEventCapturer();
        this.addMouseListener(iec);
        this.addMouseMotionListener(iec);
        this.addMouseWheelListener(iec);
        this.addKeyListener(iec);
        this.registerDefaultCommands();
        this.m_predicate.addExpressionListener(new UpdateListener(){

            public void update(Object src) {
                Display.this.damageReport();
            }
        });
        this.setVisualization(visualization);
        this.setPredicate(predicate);
        this.setSize(400, 400);
    }

    public void reset() {
        this.m_offscreen = null;
        this.m_queue.clean();
    }

    protected void registerDefaultCommands() {
        this.registerKeyboardAction(new ActionListener(){
            private PaintListener m_debug = null;

            public void actionPerformed(ActionEvent e) {
                if (this.m_debug == null) {
                    this.m_debug = new DebugStatsPainter();
                    Display.this.addPaintListener(this.m_debug);
                } else {
                    Display.this.removePaintListener(this.m_debug);
                    this.m_debug = null;
                }
                Display.this.repaint();
            }
        }, "debug info", KeyStroke.getKeyStroke("ctrl D"), 0);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Display.this.setHighQuality(!Display.this.isHighQuality());
                Display.this.repaint();
            }
        }, "toggle high-quality drawing", KeyStroke.getKeyStroke("ctrl H"), 0);
        try {
            this.registerKeyboardAction(new ExportDisplayAction(this), "export display", KeyStroke.getKeyStroke("ctrl E"), 0);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void setSize(int width, int height) {
        this.m_offscreen = null;
        this.setPreferredSize(new Dimension(width, height));
        super.setSize(width, height);
    }

    public void setSize(Dimension d) {
        this.m_offscreen = null;
        this.setPreferredSize(d);
        super.setSize(d);
    }

    public void invalidate() {
        this.damageReport();
        super.invalidate();
    }

    public void setBounds(int x, int y, int w, int h) {
        this.m_offscreen = null;
        super.setBounds(x, y, w, h);
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.m_editor.setFont(f);
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public void setHighQuality(boolean on) {
        if (this.m_highQuality != on) {
            this.damageReport();
        }
        this.m_highQuality = on;
    }

    public boolean isHighQuality() {
        return this.m_highQuality;
    }

    public Visualization getVisualization() {
        return this.m_vis;
    }

    public void setVisualization(Visualization vis) {
        if (this.m_vis == vis) {
            return;
        }
        if (this.m_vis != null) {
            this.m_vis.removeDisplay(this);
        }
        this.m_vis = vis;
        if (this.m_vis != null) {
            this.m_vis.addDisplay(this);
        }
    }

    public Predicate getPredicate() {
        if (this.m_predicate.size() == 1) {
            return BooleanLiteral.TRUE;
        }
        return this.m_predicate.get(0);
    }

    public void setPredicate(String expr) {
        Predicate p = (Predicate)ExpressionParser.parse(expr, true);
        this.setPredicate(p);
    }

    public synchronized void setPredicate(Predicate p) {
        if (p == null) {
            this.m_predicate.set(VisiblePredicate.TRUE);
        } else {
            this.m_predicate.set(new Predicate[]{p, VisiblePredicate.TRUE});
        }
    }

    public int getVisibleItemCount() {
        return this.m_visibleCount;
    }

    public ItemSorter getItemSorter() {
        return this.m_queue.sort;
    }

    public synchronized void setItemSorter(ItemSorter cmp) {
        this.damageReport();
        this.m_queue.sort = cmp;
    }

    public synchronized void setBackgroundImage(Image image, boolean fixed, boolean tileImage) {
        BackgroundPainter bg = null;
        if (image != null) {
            bg = new BackgroundPainter(image, fixed, tileImage);
        }
        this.setBackgroundPainter(bg);
    }

    public synchronized void setBackgroundImage(String location, boolean fixed, boolean tileImage) {
        BackgroundPainter bg = null;
        if (location != null) {
            bg = new BackgroundPainter(location, fixed, tileImage);
        }
        this.setBackgroundPainter(bg);
    }

    private void setBackgroundPainter(BackgroundPainter bg) {
        if (this.m_bgpainter != null) {
            this.removePaintListener(this.m_bgpainter);
        }
        this.m_bgpainter = bg;
        if (bg != null) {
            this.addPaintListener(bg);
        }
    }

    public JToolTip createToolTip() {
        if (this.m_customToolTip == null) {
            return super.createToolTip();
        }
        return this.m_customToolTip;
    }

    public void setCustomToolTip(JToolTip tooltip) {
        this.m_customToolTip = tooltip;
    }

    public JToolTip getCustomToolTip() {
        return this.m_customToolTip;
    }

    public synchronized boolean isDamageRedraw() {
        return this.m_damageRedraw;
    }

    public synchronized void setDamageRedraw(boolean b) {
        this.m_damageRedraw = b;
        this.m_clip.invalidate();
    }

    public synchronized void damageReport(Rectangle2D region) {
        if (this.m_damageRedraw) {
            this.m_clip.union(region);
        }
    }

    public synchronized void damageReport() {
        this.m_clip.invalidate();
    }

    public synchronized void clearDamage() {
        if (this.m_damageRedraw) {
            this.m_clip.reset();
        }
    }

    public synchronized Rectangle2D getItemBounds() {
        return this.getItemBounds(new Rectangle2D.Double());
    }

    public synchronized Rectangle2D getItemBounds(Rectangle2D b) {
        b.setFrameFromDiagonal(this.m_bounds.getMinX(), this.m_bounds.getMinY(), this.m_bounds.getMaxX(), this.m_bounds.getMaxY());
        return b;
    }

    public BufferedImage getOffscreenBuffer() {
        return this.m_offscreen;
    }

    protected BufferedImage getNewOffscreenBuffer(int width, int height) {
        BufferedImage img = null;
        if (!GraphicsEnvironment.isHeadless()) {
            try {
                img = (BufferedImage)this.createImage(width, height);
            }
            catch (Exception e) {
                img = null;
            }
        }
        if (img == null) {
            return new BufferedImage(width, height, 1);
        }
        return img;
    }

    public boolean saveImage(OutputStream output, String format, double scale) {
        try {
            Dimension d = new Dimension((int)(scale * (double)this.getWidth()), (int)(scale * (double)this.getHeight()));
            BufferedImage img = this.getNewOffscreenBuffer(d.width, d.height);
            Graphics2D g = (Graphics2D)img.getGraphics();
            Point2D.Double p = new Point2D.Double(0.0, 0.0);
            this.zoom(p, scale);
            boolean q = this.isHighQuality();
            this.setHighQuality(true);
            this.paintDisplay(g, d);
            this.setHighQuality(q);
            this.zoom(p, 1.0 / scale);
            ImageIO.write((RenderedImage)img, format, output);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintBufferToScreen(Graphics g) {
        Display display = this;
        synchronized (display) {
            g.drawImage(this.m_offscreen, 0, 0, null);
        }
    }

    public void repaintImmediate() {
        Graphics g = this.getGraphics();
        if (g != null && this.m_offscreen != null) {
            this.paintBufferToScreen(g);
        }
    }

    protected void prepareGraphics(Graphics2D g) {
        if (this.m_transform != null) {
            g.transform(this.m_transform);
        }
        this.setRenderingHints(g);
    }

    protected void setRenderingHints(Graphics2D g) {
        if (this.m_highQuality) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    }

    public void paintComponent(Graphics g) {
        if (this.m_offscreen == null) {
            this.m_offscreen = this.getNewOffscreenBuffer(this.getWidth(), this.getHeight());
            this.damageReport();
        }
        Graphics2D g2D = (Graphics2D)g;
        Graphics2D buf_g2D = (Graphics2D)this.m_offscreen.getGraphics();
        this.paintDisplay(buf_g2D, this.getSize());
        this.paintBufferToScreen(g2D);
        this.firePostPaint(g2D);
        buf_g2D.dispose();
        ++this.nframes;
        if (this.mark < 0L) {
            this.mark = System.currentTimeMillis();
            this.nframes = 0;
        } else if (this.nframes == this.sampleInterval) {
            long t = System.currentTimeMillis();
            this.frameRate = 1000.0 * (double)this.nframes / (double)(t - this.mark);
            this.mark = t;
            this.nframes = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintDisplay(Graphics2D g2D, Dimension d) {
        Visualization visualization = this.m_vis;
        synchronized (visualization) {
            Display display = this;
            synchronized (display) {
                if (this.m_clip.isEmpty()) {
                    return;
                }
                this.m_screen.setClip(0.0, 0.0, d.width + 1, d.height + 1);
                this.m_screen.transform(this.m_itransform);
                double pixel = 1.0 + 1.0 / this.getScale();
                if (this.m_damageRedraw) {
                    if (this.m_clip.isInvalid()) {
                        this.m_clip.setClip(this.m_screen);
                    } else {
                        this.m_clip.intersection(this.m_screen);
                    }
                    this.m_clip.expand(pixel);
                    this.prepareGraphics(g2D);
                    this.m_rclip.setFrameFromDiagonal(this.m_clip.getMinX(), this.m_clip.getMinY(), this.m_clip.getMaxX(), this.m_clip.getMaxY());
                    g2D.setClip(this.m_rclip);
                    this.m_rclip.setFrameFromDiagonal(this.m_clip.getMinX() - pixel, this.m_clip.getMinY() - pixel, this.m_clip.getMaxX() + pixel, this.m_clip.getMaxY() + pixel);
                } else {
                    this.m_rclip.setFrame(this.m_screen.getMinX(), this.m_screen.getMinY(), this.m_screen.getWidth(), this.m_screen.getHeight());
                    this.m_clip.setClip(this.m_screen);
                    this.prepareGraphics(g2D);
                }
                this.clearRegion(g2D, this.m_rclip);
                this.getItemBounds(this.m_rclip);
                this.m_bounds.reset();
                this.m_queue.clear();
                Iterator<VisualItem> items = this.m_vis.items(this.m_predicate);
                while (items.hasNext()) {
                    VisualItem item = items.next();
                    Rectangle2D bounds = item.getBounds();
                    this.m_bounds.union(bounds);
                    if (this.m_clip.intersects(bounds, pixel)) {
                        this.m_queue.addToRenderQueue(item);
                    }
                    if (!item.isInteractive()) continue;
                    this.m_queue.addToPickingQueue(item);
                }
                this.m_queue.sortRenderQueue();
                int i = 0;
                while (i < this.m_queue.rsize) {
                    this.m_queue.ritems[i].render(g2D);
                    ++i;
                }
                if (this.m_damageRedraw) {
                    this.m_clip.reset();
                }
                this.checkItemBoundsChanged(this.m_rclip);
            }
        }
    }

    public void renderImmediate(VisualItem item) {
        Graphics2D g2D = (Graphics2D)this.getGraphics();
        this.prepareGraphics(g2D);
        item.render(g2D);
    }

    protected void printComponent(Graphics g) {
        boolean wasHighQuality = this.m_highQuality;
        try {
            this.m_highQuality = true;
            this.paintDisplay((Graphics2D)g, this.getSize());
        }
        finally {
            this.m_highQuality = wasHighQuality;
        }
    }

    protected void clearRegion(Graphics2D g, Rectangle2D r) {
        g.setColor(this.getBackground());
        g.fill(r);
        this.firePrePaint(g);
    }

    public synchronized void setTransform(AffineTransform transform) throws NoninvertibleTransformException {
        this.damageReport();
        this.m_transform = transform;
        this.m_itransform = this.m_transform.createInverse();
    }

    public AffineTransform getTransform() {
        return this.m_transform;
    }

    public AffineTransform getInverseTransform() {
        return this.m_itransform;
    }

    public Point2D getAbsoluteCoordinate(Point2D screen, Point2D abs) {
        return this.m_itransform.transform(screen, abs);
    }

    public double getScale() {
        return this.m_transform.getScaleX();
    }

    public double getDisplayX() {
        return -this.m_transform.getTranslateX();
    }

    public double getDisplayY() {
        return -this.m_transform.getTranslateY();
    }

    public synchronized void pan(double dx, double dy) {
        this.m_tmpPoint.setLocation(dx, dy);
        this.m_itransform.transform(this.m_tmpPoint, this.m_tmpPoint);
        double panx = this.m_tmpPoint.getX();
        double pany = this.m_tmpPoint.getY();
        this.m_tmpPoint.setLocation(0.0, 0.0);
        this.m_itransform.transform(this.m_tmpPoint, this.m_tmpPoint);
        this.panAbs(panx -= this.m_tmpPoint.getX(), pany -= this.m_tmpPoint.getY());
    }

    public synchronized void panAbs(double dx, double dy) {
        this.damageReport();
        this.m_transform.translate(dx, dy);
        try {
            this.m_itransform = this.m_transform.createInverse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void panTo(Point2D p) {
        this.m_itransform.transform(p, this.m_tmpPoint);
        this.panToAbs(this.m_tmpPoint);
    }

    public synchronized void panToAbs(Point2D p) {
        double sx = this.m_transform.getScaleX();
        double sy = this.m_transform.getScaleY();
        double x = p.getX();
        x = Double.isNaN(x) ? 0.0 : x;
        double y = p.getY();
        y = Double.isNaN(y) ? 0.0 : y;
        x = (double)this.getWidth() / (2.0 * sx) - x;
        y = (double)this.getHeight() / (2.0 * sy) - y;
        double dx = x - this.m_transform.getTranslateX() / sx;
        double dy = y - this.m_transform.getTranslateY() / sy;
        this.damageReport();
        this.m_transform.translate(dx, dy);
        try {
            this.m_itransform = this.m_transform.createInverse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void zoom(Point2D p, double scale) {
        this.m_itransform.transform(p, this.m_tmpPoint);
        this.zoomAbs(this.m_tmpPoint, scale);
    }

    public synchronized void zoomAbs(Point2D p, double scale) {
        double zx = p.getX();
        double zy = p.getY();
        this.damageReport();
        this.m_transform.translate(zx, zy);
        this.m_transform.scale(scale, scale);
        this.m_transform.translate(-zx, -zy);
        try {
            this.m_itransform = this.m_transform.createInverse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void rotate(Point2D p, double theta) {
        this.m_itransform.transform(p, this.m_tmpPoint);
        this.rotateAbs(this.m_tmpPoint, theta);
    }

    public synchronized void rotateAbs(Point2D p, double theta) {
        double zx = p.getX();
        double zy = p.getY();
        this.damageReport();
        this.m_transform.translate(zx, zy);
        this.m_transform.rotate(theta);
        this.m_transform.translate(-zx, -zy);
        try {
            this.m_itransform = this.m_transform.createInverse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void animatePan(double dx, double dy, long duration) {
        double panx = dx / this.m_transform.getScaleX();
        double pany = dy / this.m_transform.getScaleY();
        this.animatePanAbs(panx, pany, duration);
    }

    public synchronized void animatePanAbs(double dx, double dy, long duration) {
        this.m_transact.pan(dx, dy, duration);
    }

    public synchronized void animatePanTo(Point2D p, long duration) {
        Point2D.Double pp = new Point2D.Double();
        this.m_itransform.transform(p, pp);
        this.animatePanToAbs(pp, duration);
    }

    public synchronized void animatePanToAbs(Point2D p, long duration) {
        this.m_tmpPoint.setLocation(0.0, 0.0);
        this.m_itransform.transform(this.m_tmpPoint, this.m_tmpPoint);
        double x = p.getX();
        x = Double.isNaN(x) ? 0.0 : x;
        double y = p.getY();
        y = Double.isNaN(y) ? 0.0 : y;
        double w = (double)this.getWidth() / (2.0 * this.m_transform.getScaleX());
        double h = (double)this.getHeight() / (2.0 * this.m_transform.getScaleY());
        double dx = w - x + this.m_tmpPoint.getX();
        double dy = h - y + this.m_tmpPoint.getY();
        this.animatePanAbs(dx, dy, duration);
    }

    public synchronized void animateZoom(Point2D p, double scale, long duration) {
        Point2D.Double pp = new Point2D.Double();
        this.m_itransform.transform(p, pp);
        this.animateZoomAbs(pp, scale, duration);
    }

    public synchronized void animateZoomAbs(Point2D p, double scale, long duration) {
        this.m_transact.zoom(p, scale, duration);
    }

    public synchronized void animatePanAndZoomTo(Point2D p, double scale, long duration) {
        Point2D.Double pp = new Point2D.Double();
        this.m_itransform.transform(p, pp);
        this.animatePanAndZoomToAbs(pp, scale, duration);
    }

    public synchronized void animatePanAndZoomToAbs(Point2D p, double scale, long duration) {
        this.m_transact.panAndZoom(p, scale, duration);
    }

    public boolean isTranformInProgress() {
        return this.m_transact.isRunning();
    }

    public void addPaintListener(PaintListener pl) {
        if (this.m_painters == null) {
            this.m_painters = new CopyOnWriteArrayList();
        }
        this.m_painters.add(pl);
    }

    public void removePaintListener(PaintListener pl) {
        this.m_painters.remove(pl);
    }

    protected void firePrePaint(Graphics2D g) {
        if (this.m_painters != null && this.m_painters.size() > 0) {
            for (PaintListener listener : this.m_painters) {
                try {
                    listener.prePaint(this, g);
                }
                catch (Exception e) {
                    s_logger.warning("Exception thrown by PaintListener: " + e + "\n" + StringLib.getStackTrace(e));
                }
            }
        }
    }

    protected void firePostPaint(Graphics2D g) {
        if (this.m_painters != null && this.m_painters.size() > 0) {
            for (PaintListener listener : this.m_painters) {
                try {
                    listener.postPaint(this, g);
                }
                catch (Exception e) {
                    s_logger.warning("Exception thrown by PaintListener: " + e + "\n" + StringLib.getStackTrace(e));
                }
            }
        }
    }

    public void addItemBoundsListener(ItemBoundsListener ibl) {
        if (this.m_bounders == null) {
            this.m_bounders = new CopyOnWriteArrayList();
        }
        this.m_bounders.add(ibl);
    }

    public void removeItemBoundsListener(ItemBoundsListener ibl) {
        this.m_bounders.remove(ibl);
    }

    protected void checkItemBoundsChanged(Rectangle2D prev) {
        if (this.m_bounds.equals(prev)) {
            return;
        }
        if (this.m_bounders != null && this.m_bounders.size() > 0) {
            for (ItemBoundsListener listener : this.m_bounders) {
                try {
                    listener.itemBoundsChanged(this);
                }
                catch (Exception e) {
                    s_logger.warning("Exception thrown by ItemBoundsListener: " + e + "\n" + StringLib.getStackTrace(e));
                }
            }
        }
    }

    public void addControlListener(Control cl) {
        this.m_controls.add(cl);
    }

    public void removeControlListener(Control cl) {
        this.m_controls.remove(cl);
    }

    public synchronized VisualItem findItem(Point p) {
        Point p2;
        Point2D point2D = p2 = this.m_itransform == null ? p : this.m_itransform.transform(p, this.m_tmpPoint);
        if (!this.m_queue.psorted) {
            this.m_queue.sortPickingQueue();
        }
        int i = this.m_queue.psize;
        while (--i >= 0) {
            Renderer r;
            VisualItem vi = this.m_queue.pitems[i];
            if (!vi.isValid() || (r = vi.getRenderer()) == null || !vi.isInteractive() || !r.locatePoint(p2, vi)) continue;
            return vi;
        }
        return null;
    }

    public JTextComponent getTextEditor() {
        return this.m_editor;
    }

    public void setTextEditor(JTextComponent tc) {
        this.remove(this.m_editor);
        this.m_editor = tc;
        this.add((Component)this.m_editor, 1);
    }

    public void editText(VisualItem item, String attribute) {
        if (this.m_editing) {
            this.stopEditing();
        }
        Rectangle2D b = item.getBounds();
        Rectangle r = this.m_transform.createTransformedShape(b).getBounds();
        if (this.m_editor instanceof JTextArea) {
            r.y -= 2;
            r.width += 22;
            r.height += 2;
        } else {
            r.x += 3;
            ++r.y;
            r.width -= 5;
            r.height -= 2;
        }
        Font f = this.getFont();
        int size = (int)Math.round((double)f.getSize() * this.m_transform.getScaleX());
        Font nf = new Font(f.getFontName(), f.getStyle(), size);
        this.m_editor.setFont(nf);
        this.editText(item, attribute, r);
    }

    public void editText(VisualItem item, String attribute, Rectangle r) {
        if (this.m_editing) {
            this.stopEditing();
        }
        String txt = item.getString(attribute);
        this.m_editItem = item;
        this.m_editAttribute = attribute;
        Color tc = ColorLib.getColor(item.getTextColor());
        Color fc = ColorLib.getColor(item.getFillColor());
        this.m_editor.setForeground(tc);
        this.m_editor.setBackground(fc);
        this.editText(txt, r);
    }

    public void editText(String txt, Rectangle r) {
        if (this.m_editing) {
            this.stopEditing();
        }
        this.m_editing = true;
        this.m_editor.setBounds(r.x, r.y, r.width, r.height);
        this.m_editor.setText(txt);
        this.m_editor.setVisible(true);
        this.m_editor.setCaretPosition(txt.length());
        this.m_editor.requestFocus();
    }

    public void stopEditing() {
        this.m_editor.setVisible(false);
        if (this.m_editItem != null) {
            String txt = this.m_editor.getText();
            this.m_editItem.set(this.m_editAttribute, (Object)txt);
            this.m_editItem = null;
            this.m_editAttribute = null;
            this.m_editor.setBackground(null);
            this.m_editor.setForeground(null);
        }
        this.m_editing = false;
    }

    public class InputEventCapturer
    implements MouseMotionListener,
    MouseWheelListener,
    MouseListener,
    KeyListener {
        private VisualItem activeItem = null;
        private boolean mouseDown = false;

        private boolean validityCheck() {
            if (this.activeItem.isValid()) {
                return true;
            }
            this.activeItem = null;
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseDragged(MouseEvent e) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemDragged(this.activeItem, e);
                    }
                } else {
                    this.fireMouseDragged(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseMoved(MouseEvent e) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                boolean earlyReturn = false;
                VisualItem vi = Display.this.findItem(e.getPoint());
                if (this.activeItem != null && this.activeItem != vi) {
                    if (this.validityCheck()) {
                        this.fireItemExited(this.activeItem, e);
                    }
                    earlyReturn = true;
                }
                if (vi != null && vi != this.activeItem) {
                    this.fireItemEntered(vi, e);
                    earlyReturn = true;
                }
                this.activeItem = vi;
                if (earlyReturn) {
                    return;
                }
                if (vi != null && vi == this.activeItem) {
                    this.fireItemMoved(vi, e);
                }
                if (vi == null) {
                    this.fireMouseMoved(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseWheelMoved(MouseWheelEvent e) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemWheelMoved(this.activeItem, e);
                    }
                } else {
                    this.fireMouseWheelMoved(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseClicked(MouseEvent e) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemClicked(this.activeItem, e);
                    }
                } else {
                    this.fireMouseClicked(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mousePressed(MouseEvent e) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                this.mouseDown = true;
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemPressed(this.activeItem, e);
                    }
                } else {
                    this.fireMousePressed(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseReleased(MouseEvent e) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemReleased(this.activeItem, e);
                    }
                } else {
                    this.fireMouseReleased(e);
                }
                if (this.activeItem != null && this.mouseDown && this.isOffComponent(e)) {
                    this.fireItemExited(this.activeItem, e);
                    this.activeItem = null;
                }
                this.mouseDown = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseEntered(MouseEvent e) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                this.fireMouseEntered(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseExited(MouseEvent e) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                if (!this.mouseDown && this.activeItem != null) {
                    this.fireItemExited(this.activeItem, e);
                    this.activeItem = null;
                }
                this.fireMouseExited(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyPressed(KeyEvent e) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemKeyPressed(this.activeItem, e);
                    }
                } else {
                    this.fireKeyPressed(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyReleased(KeyEvent e) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemKeyReleased(this.activeItem, e);
                    }
                } else {
                    this.fireKeyReleased(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyTyped(KeyEvent e) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemKeyTyped(this.activeItem, e);
                    }
                } else {
                    this.fireKeyTyped(e);
                }
            }
        }

        private boolean isOffComponent(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            return x < 0 || x > Display.this.getWidth() || y < 0 || y > Display.this.getHeight();
        }

        private void fireItemDragged(VisualItem item, MouseEvent e) {
            for (Control ctrl : Display.this.m_controls) {
                if (!ctrl.isEnabled()) continue;
                try {
                    ctrl.itemDragged(item, e);
                }
                catch (Exception ex) {
                    s_logger.warning("Exception thrown by Control: " + ex + "\n" + StringLib.getStackTrace(ex));
                }
            }
        }

        private void fireItemMoved(VisualItem item, MouseEvent e) {
            for (Control ctrl : Display.this.m_controls) {
                if (!ctrl.isEnabled()) continue;
                try {
                    ctrl.itemMoved(item, e);
                }
                catch (Exception ex) {
                    s_logger.warning("Exception thrown by Control: " + ex + "\n" + StringLib.getStackTrace(ex));
                }
            }
        }

        private void fireItemWheelMoved(VisualItem item, MouseWheelEvent e) {
            for (Control ctrl : Display.this.m_controls) {
                if (!ctrl.isEnabled()) continue;
                try {
                    ctrl.itemWheelMoved(item, e);
                }
                catch (Exception ex) {
                    s_logger.warning("Exception thrown by Control: " + ex + "\n" + StringLib.getStackTrace(ex));
                }
            }
        }

        private void fireItemClicked(VisualItem item, MouseEvent e) {
            for (Control ctrl : Display.this.m_controls) {
                if (!ctrl.isEnabled()) continue;
                try {
                    ctrl.itemClicked(item, e);
                }
                catch (Exception ex) {
                    s_logger.warning("Exception thrown by Control: " + ex + "\n" + StringLib.getStackTrace(ex));
                }
            }
        }

        private void fireItemPressed(VisualItem item, MouseEvent e) {
            for (Control ctrl : Display.this.m_controls) {
                if (!ctrl.isEnabled()) continue;
                try {
                    ctrl.itemPressed(item, e);
                }
                catch (Exception ex) {
                    s_logger.warning("Exception thrown by Control: " + ex + "\n" + StringLib.getStackTrace(ex));
                }
            }
        }

        private void fireItemReleased(VisualItem item, MouseEvent e) {
            for (Control ctrl : Display.this.m_controls) {
                if (!ctrl.isEnabled()) continue;
                try {
                    ctrl.itemReleased(item, e);
                }
                catch (Exception ex) {
                    s_logger.warning("Exception thrown by Control: " + ex + "\n" + StringLib.getStackTrace(ex));
                }
            }
        }

        private void fireItemEntered(VisualItem item, MouseEvent e) {
            item.setHover(true);
            for (Control ctrl : Display.this.m_controls) {
                if (!ctrl.isEnabled()) continue;
                try {
                    ctrl.itemEntered(item, e);
                }
                catch (Exception ex) {
                    s_logger.warning("Exception thrown by Control: " + ex + "\n" + StringLib.getStackTrace(ex));
                }
            }
        }

        private void fireItemExited(VisualItem item, MouseEvent e) {
            if (item.isValid()) {
                item.setHover(false);
            }
            for (Control ctrl : Display.this.m_controls) {
                if (!ctrl.isEnabled()) continue;
                try {
                    ctrl.itemExited(item, e);
                }
                catch (Exception ex) {
                    s_logger.warning("Exception thrown by Control: " + ex + "\n" + StringLib.getStackTrace(ex));
                }
            }
        }

        private void fireItemKeyPressed(VisualItem item, KeyEvent e) {
            for (Control ctrl : Display.this.m_controls) {
                if (!ctrl.isEnabled()) continue;
                try {
                    ctrl.itemKeyPressed(item, e);
                }
                catch (Exception ex) {
                    s_logger.warning("Exception thrown by Control: " + ex + "\n" + StringLib.getStackTrace(ex));
                }
            }
        }

        private void fireItemKeyReleased(VisualItem item, KeyEvent e) {
            for (Control ctrl : Display.this.m_controls) {
                if (!ctrl.isEnabled()) continue;
                try {
                    ctrl.itemKeyReleased(item, e);
                }
                catch (Exception ex) {
                    s_logger.warning("Exception thrown by Control: " + ex + "\n" + StringLib.getStackTrace(ex));
                }
            }
        }

        private void fireItemKeyTyped(VisualItem item, KeyEvent e) {
            for (Control ctrl : Display.this.m_controls) {
                if (!ctrl.isEnabled()) continue;
                try {
                    ctrl.itemKeyTyped(item, e);
                }
                catch (Exception ex) {
                    s_logger.warning("Exception thrown by Control: " + ex + "\n" + StringLib.getStackTrace(ex));
                }
            }
        }

        private void fireMouseEntered(MouseEvent e) {
            for (Control ctrl : Display.this.m_controls) {
                if (!ctrl.isEnabled()) continue;
                try {
                    ctrl.mouseEntered(e);
                }
                catch (Exception ex) {
                    s_logger.warning("Exception thrown by Control: " + ex + "\n" + StringLib.getStackTrace(ex));
                }
            }
        }

        private void fireMouseExited(MouseEvent e) {
            for (Control ctrl : Display.this.m_controls) {
                if (!ctrl.isEnabled()) continue;
                try {
                    ctrl.mouseExited(e);
                }
                catch (Exception ex) {
                    s_logger.warning("Exception thrown by Control: " + ex + "\n" + StringLib.getStackTrace(ex));
                }
            }
        }

        private void fireMousePressed(MouseEvent e) {
            for (Control ctrl : Display.this.m_controls) {
                if (!ctrl.isEnabled()) continue;
                try {
                    ctrl.mousePressed(e);
                }
                catch (Exception ex) {
                    s_logger.warning("Exception thrown by Control: " + ex + "\n" + StringLib.getStackTrace(ex));
                }
            }
        }

        private void fireMouseReleased(MouseEvent e) {
            for (Control ctrl : Display.this.m_controls) {
                if (!ctrl.isEnabled()) continue;
                try {
                    ctrl.mouseReleased(e);
                }
                catch (Exception ex) {
                    s_logger.warning("Exception thrown by Control: " + ex + "\n" + StringLib.getStackTrace(ex));
                }
            }
        }

        private void fireMouseClicked(MouseEvent e) {
            for (Control ctrl : Display.this.m_controls) {
                if (!ctrl.isEnabled()) continue;
                try {
                    ctrl.mouseClicked(e);
                }
                catch (Exception ex) {
                    s_logger.warning("Exception thrown by Control: " + ex + "\n" + StringLib.getStackTrace(ex));
                }
            }
        }

        private void fireMouseDragged(MouseEvent e) {
            for (Control ctrl : Display.this.m_controls) {
                if (!ctrl.isEnabled()) continue;
                try {
                    ctrl.mouseDragged(e);
                }
                catch (Exception ex) {
                    s_logger.warning("Exception thrown by Control: " + ex + "\n" + StringLib.getStackTrace(ex));
                }
            }
        }

        private void fireMouseMoved(MouseEvent e) {
            for (Control ctrl : Display.this.m_controls) {
                if (!ctrl.isEnabled()) continue;
                try {
                    ctrl.mouseMoved(e);
                }
                catch (Exception ex) {
                    s_logger.warning("Exception thrown by Control: " + ex + "\n" + StringLib.getStackTrace(ex));
                }
            }
        }

        private void fireMouseWheelMoved(MouseWheelEvent e) {
            for (Control ctrl : Display.this.m_controls) {
                if (!ctrl.isEnabled()) continue;
                try {
                    ctrl.mouseWheelMoved(e);
                }
                catch (Exception ex) {
                    s_logger.warning("Exception thrown by Control: " + ex + "\n" + StringLib.getStackTrace(ex));
                }
            }
        }

        private void fireKeyPressed(KeyEvent e) {
            for (Control ctrl : Display.this.m_controls) {
                if (!ctrl.isEnabled()) continue;
                try {
                    ctrl.keyPressed(e);
                }
                catch (Exception ex) {
                    s_logger.warning("Exception thrown by Control: " + ex + "\n" + StringLib.getStackTrace(ex));
                }
            }
        }

        private void fireKeyReleased(KeyEvent e) {
            for (Control ctrl : Display.this.m_controls) {
                if (!ctrl.isEnabled()) continue;
                try {
                    ctrl.keyReleased(e);
                }
                catch (Exception ex) {
                    s_logger.warning("Exception thrown by Control: " + ex + "\n" + StringLib.getStackTrace(ex));
                }
            }
        }

        private void fireKeyTyped(KeyEvent e) {
            for (Control ctrl : Display.this.m_controls) {
                if (!ctrl.isEnabled()) continue;
                try {
                    ctrl.keyTyped(e);
                }
                catch (Exception ex) {
                    s_logger.warning("Exception thrown by Control: " + ex + "\n" + StringLib.getStackTrace(ex));
                }
            }
        }
    }

    private class TransformActivity
    extends Activity {
        private double[] src;
        private double[] dst;
        private AffineTransform m_at;

        public TransformActivity() {
            super(2000L, 20L, 0L);
            this.src = new double[6];
            this.dst = new double[6];
            this.m_at = new AffineTransform();
            this.setPacingFunction(new SlowInSlowOutPacer());
        }

        private AffineTransform getTransform() {
            if (this.isScheduled()) {
                this.m_at.setTransform(this.dst[0], this.dst[1], this.dst[2], this.dst[3], this.dst[4], this.dst[5]);
            } else {
                this.m_at.setTransform(Display.this.m_transform);
            }
            return this.m_at;
        }

        public void panAndZoom(Point2D p, double scale, long duration) {
            AffineTransform at = this.getTransform();
            this.cancel();
            this.setDuration(duration);
            Display.this.m_tmpPoint.setLocation(0.0, 0.0);
            Display.this.m_itransform.transform(Display.this.m_tmpPoint, Display.this.m_tmpPoint);
            double x = p.getX();
            x = Double.isNaN(x) ? 0.0 : x;
            double y = p.getY();
            y = Double.isNaN(y) ? 0.0 : y;
            double w = (double)Display.this.getWidth() / (2.0 * Display.this.m_transform.getScaleX());
            double h = (double)Display.this.getHeight() / (2.0 * Display.this.m_transform.getScaleY());
            double dx = w - x + Display.this.m_tmpPoint.getX();
            double dy = h - y + Display.this.m_tmpPoint.getY();
            at.translate(dx, dy);
            at.translate(p.getX(), p.getY());
            at.scale(scale, scale);
            at.translate(-p.getX(), -p.getY());
            at.getMatrix(this.dst);
            Display.this.m_transform.getMatrix(this.src);
            this.run();
        }

        public void pan(double dx, double dy, long duration) {
            AffineTransform at = this.getTransform();
            this.cancel();
            this.setDuration(duration);
            at.translate(dx, dy);
            at.getMatrix(this.dst);
            Display.this.m_transform.getMatrix(this.src);
            this.run();
        }

        public void zoom(Point2D p, double scale, long duration) {
            AffineTransform at = this.getTransform();
            this.cancel();
            this.setDuration(duration);
            double zx = p.getX();
            double zy = p.getY();
            at.translate(zx, zy);
            at.scale(scale, scale);
            at.translate(-zx, -zy);
            at.getMatrix(this.dst);
            Display.this.m_transform.getMatrix(this.src);
            this.run();
        }

        protected void run(long elapsedTime) {
            double f = this.getPace(elapsedTime);
            Display.this.damageReport();
            Display.this.m_transform.setTransform(this.src[0] + f * (this.dst[0] - this.src[0]), this.src[1] + f * (this.dst[1] - this.src[1]), this.src[2] + f * (this.dst[2] - this.src[2]), this.src[3] + f * (this.dst[3] - this.src[3]), this.src[4] + f * (this.dst[4] - this.src[4]), this.src[5] + f * (this.dst[5] - this.src[5]));
            try {
                Display.this.m_itransform = Display.this.m_transform.createInverse();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Display.this.repaint();
        }
    }
}

