/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.animate;

import java.util.Iterator;
import prefuse.action.ItemAction;
import prefuse.data.tuple.TupleSet;
import prefuse.util.ColorLib;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.StartVisiblePredicate;

public class AxisLabelAnimator
extends ItemAction {
    protected AxisLabelAnimator() {
    }

    public AxisLabelAnimator(String group) {
        super(group);
    }

    public void run(double frac) {
        if (frac == 0.0) {
            this.setup();
        } else if (frac == 1.0) {
            this.finish();
        } else {
            super.run(frac);
        }
        TupleSet ts = this.m_vis.getGroup(this.m_group);
        ts.putClientProperty("frac", new Double(frac));
    }

    private void setup() {
        VisualItem item;
        Iterator<VisualItem> items = this.m_vis.visibleItems(this.m_group);
        while (items.hasNext()) {
            item = items.next();
            if (!item.isStartVisible()) {
                int efc = item.getEndFillColor();
                int esc = item.getEndStrokeColor();
                int etc = item.getEndTextColor();
                item.setStartFillColor(ColorLib.setAlpha(efc, 0));
                item.setStartStrokeColor(ColorLib.setAlpha(esc, 0));
                item.setStartTextColor(ColorLib.setAlpha(etc, 0));
                item.setStartVisible(true);
            }
            this.process(item, 0.0);
        }
        items = this.m_vis.items(this.m_group, StartVisiblePredicate.TRUE);
        while (items.hasNext()) {
            item = items.next();
            if (item.isEndVisible()) continue;
            int sfc = item.getStartFillColor();
            int ssc = item.getStartStrokeColor();
            int stc = item.getStartTextColor();
            item.setEndFillColor(ColorLib.setAlpha(sfc, 0));
            item.setEndStrokeColor(ColorLib.setAlpha(ssc, 0));
            item.setEndTextColor(ColorLib.setAlpha(stc, 0));
            item.setVisible(true);
            this.process(item, 0.0);
        }
    }

    private void finish() {
        VisualItem item;
        Iterator<VisualItem> items = this.m_vis.items(this.m_group, StartVisiblePredicate.TRUE);
        while (items.hasNext()) {
            item = items.next();
            if (item.isEndVisible()) continue;
            item.setVisible(false);
            item.setStartVisible(false);
        }
        items = this.m_vis.visibleItems(this.m_group);
        while (items.hasNext()) {
            item = items.next();
            this.process(item, 1.0);
            item.setStartFillColor(item.getEndFillColor());
            item.setStartTextColor(item.getEndTextColor());
            item.setStartStrokeColor(item.getEndStrokeColor());
        }
    }

    public void process(VisualItem item, double frac) {
        double v = item.getStartX();
        item.setX(v + frac * (item.getEndX() - v));
        v = item.getStartY();
        item.setY(v + frac * (item.getEndY() - v));
        v = item.getDouble(VisualItem.STARTX2);
        v += frac * (item.getDouble(VisualItem.ENDX2) - v);
        item.setDouble(VisualItem.X2, v);
        v = item.getDouble(VisualItem.STARTY2);
        v += frac * (item.getDouble(VisualItem.ENDY2) - v);
        item.setDouble(VisualItem.Y2, v);
        int c = ColorLib.interp(item.getStartStrokeColor(), item.getEndStrokeColor(), frac);
        item.setStrokeColor(c);
        int tc = ColorLib.interp(item.getStartTextColor(), item.getEndTextColor(), frac);
        item.setTextColor(tc);
        int fc = ColorLib.interp(item.getStartFillColor(), item.getEndFillColor(), frac);
        item.setFillColor(fc);
    }
}

