/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout;

import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.visual.VisualItem;

public class CollapsedStackLayout
extends Layout {
    private String m_polyField;
    private int m_orientation = 3;
    private boolean m_horiz = false;
    private boolean m_top = false;

    public CollapsedStackLayout(String group) {
        this(group, "_polygon");
    }

    public CollapsedStackLayout(String group, String field) {
        super(group);
        this.m_polyField = field;
    }

    public int getOrientation() {
        return this.m_orientation;
    }

    public void setOrientation(int orient) {
        if (orient != 2 && orient != 3 && orient != 0 && orient != 1) {
            throw new IllegalArgumentException("Invalid orientation value: " + orient);
        }
        this.m_orientation = orient;
        this.m_horiz = this.m_orientation == 0 || this.m_orientation == 1;
        this.m_top = this.m_orientation == 2 || this.m_orientation == 0;
    }

    public void run(double frac) {
        VisualItem lastItem = null;
        Rectangle2D bounds = this.getLayoutBounds();
        float floor = (float)(this.m_horiz ? (this.m_top ? bounds.getMaxX() : bounds.getMinX()) : (this.m_top ? bounds.getMinY() : bounds.getMaxY()));
        int bias = this.m_horiz ? 0 : 1;
        Iterator<Tuple> iter = ((Table)this.m_vis.getGroup(this.m_group)).tuplesReversed();
        while (iter.hasNext()) {
            VisualItem item = (VisualItem)iter.next();
            boolean prev = item.isStartVisible();
            boolean cur = item.isVisible();
            if (!prev && cur) {
                float[] f = (float[])item.get(this.m_polyField);
                if (f == null) continue;
                if (lastItem == null) {
                    int i = 0;
                    while (i < f.length) {
                        f[i + bias] = floor;
                        i += 2;
                    }
                    continue;
                }
                float[] l = (float[])lastItem.get(this.m_polyField);
                int i = 0;
                while (i < f.length / 2) {
                    float f2 = l[i + bias];
                    f[f.length - 2 - i + bias] = f2;
                    f[i + bias] = f2;
                    i += 2;
                }
                continue;
            }
            if (!prev || !cur) continue;
            lastItem = item;
        }
    }
}

