/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.tuple.TupleSet;
import prefuse.util.PrefuseLib;
import prefuse.util.force.DragForce;
import prefuse.util.force.ForceItem;
import prefuse.util.force.ForceSimulator;
import prefuse.util.force.NBodyForce;
import prefuse.util.force.SpringForce;
import prefuse.visual.EdgeItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class ForceDirectedLayout
extends Layout {
    private ForceSimulator m_fsim;
    private long m_lasttime = -1L;
    private long m_maxstep = 50L;
    private boolean m_runonce;
    private int m_iterations = 100;
    private boolean m_enforceBounds;
    protected transient VisualItem referrer;
    protected String m_nodeGroup;
    protected String m_edgeGroup;
    public static final String FORCEITEM = "_forceItem";
    public static final Schema FORCEITEM_SCHEMA = new Schema();

    static {
        FORCEITEM_SCHEMA.addColumn(FORCEITEM, ForceItem.class, new ForceItem());
    }

    public ForceDirectedLayout(String graph) {
        this(graph, false, false);
    }

    public ForceDirectedLayout(String group, boolean enforceBounds) {
        this(group, enforceBounds, false);
    }

    public ForceDirectedLayout(String group, boolean enforceBounds, boolean runonce) {
        super(group);
        this.m_nodeGroup = PrefuseLib.getGroupName(group, Graph.NODES);
        this.m_edgeGroup = PrefuseLib.getGroupName(group, Graph.EDGES);
        this.m_enforceBounds = enforceBounds;
        this.m_runonce = runonce;
        this.m_fsim = new ForceSimulator();
        this.m_fsim.addForce(new NBodyForce());
        this.m_fsim.addForce(new SpringForce());
        this.m_fsim.addForce(new DragForce());
    }

    public ForceDirectedLayout(String group, ForceSimulator fsim, boolean enforceBounds) {
        this(group, fsim, enforceBounds, false);
    }

    public ForceDirectedLayout(String group, ForceSimulator fsim, boolean enforceBounds, boolean runonce) {
        super(group);
        this.m_nodeGroup = PrefuseLib.getGroupName(group, Graph.NODES);
        this.m_edgeGroup = PrefuseLib.getGroupName(group, Graph.EDGES);
        this.m_enforceBounds = enforceBounds;
        this.m_runonce = runonce;
        this.m_fsim = fsim;
    }

    public long getMaxTimeStep() {
        return this.m_maxstep;
    }

    public void setMaxTimeStep(long maxstep) {
        this.m_maxstep = maxstep;
    }

    public ForceSimulator getForceSimulator() {
        return this.m_fsim;
    }

    public void setForceSimulator(ForceSimulator fsim) {
        this.m_fsim = fsim;
    }

    public int getIterations() {
        return this.m_iterations;
    }

    public void setIterations(int iter) {
        if (iter < 1) {
            throw new IllegalArgumentException("Iterations must be a positive number!");
        }
        this.m_iterations = iter;
    }

    public void setDataGroups(String nodeGroup, String edgeGroup) {
        this.m_nodeGroup = nodeGroup;
        this.m_edgeGroup = edgeGroup;
    }

    public void run(double frac) {
        if (this.m_runonce) {
            Point2D anchor = this.getLayoutAnchor();
            Iterator<VisualItem> iter = this.m_vis.visibleItems(this.m_nodeGroup);
            while (iter.hasNext()) {
                NodeItem item = (NodeItem)iter.next();
                item.setX(anchor.getX());
                item.setY(anchor.getY());
            }
            this.m_fsim.clear();
            long timestep = 1000L;
            this.initSimulator(this.m_fsim);
            int i = 0;
            while (i < this.m_iterations) {
                timestep = (long)((double)timestep * (1.0 - (double)i / (double)this.m_iterations));
                long step = timestep + 50L;
                this.m_fsim.runSimulator(step);
                ++i;
            }
            this.updateNodePositions();
        } else {
            if (this.m_lasttime == -1L) {
                this.m_lasttime = System.currentTimeMillis() - 20L;
            }
            long time = System.currentTimeMillis();
            long timestep = Math.min(this.m_maxstep, time - this.m_lasttime);
            this.m_lasttime = time;
            this.m_fsim.clear();
            this.initSimulator(this.m_fsim);
            this.m_fsim.runSimulator(timestep);
            this.updateNodePositions();
        }
        if (frac == 1.0) {
            this.reset();
        }
    }

    private void updateNodePositions() {
        Rectangle2D bounds = this.getLayoutBounds();
        double x1 = 0.0;
        double x2 = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        if (bounds != null) {
            x1 = bounds.getMinX();
            y1 = bounds.getMinY();
            x2 = bounds.getMaxX();
            y2 = bounds.getMaxY();
        }
        Iterator<VisualItem> iter = this.m_vis.visibleItems(this.m_nodeGroup);
        while (iter.hasNext()) {
            VisualItem item = iter.next();
            ForceItem fitem = (ForceItem)item.get(FORCEITEM);
            if (item.isFixed()) {
                fitem.force[0] = 0.0f;
                fitem.force[1] = 0.0f;
                fitem.velocity[0] = 0.0f;
                fitem.velocity[1] = 0.0f;
                if (!Double.isNaN(item.getX())) continue;
                this.setX(item, this.referrer, 0.0);
                this.setY(item, this.referrer, 0.0);
                continue;
            }
            double x = fitem.location[0];
            double y = fitem.location[1];
            if (this.m_enforceBounds && bounds != null) {
                Rectangle2D b = item.getBounds();
                double hw = b.getWidth() / 2.0;
                double hh = b.getHeight() / 2.0;
                if (x + hw > x2) {
                    x = x2 - hw;
                }
                if (x - hw < x1) {
                    x = x1 + hw;
                }
                if (y + hh > y2) {
                    y = y2 - hh;
                }
                if (y - hh < y1) {
                    y = y1 + hh;
                }
            }
            this.setX(item, this.referrer, x);
            this.setY(item, this.referrer, y);
        }
    }

    public void reset() {
        Iterator<VisualItem> iter = this.m_vis.visibleItems(this.m_nodeGroup);
        while (iter.hasNext()) {
            VisualItem item = iter.next();
            ForceItem fitem = (ForceItem)item.get(FORCEITEM);
            if (fitem == null) continue;
            fitem.location[0] = (float)item.getEndX();
            fitem.location[1] = (float)item.getEndY();
            fitem.force[1] = 0.0f;
            fitem.force[0] = 0.0f;
            fitem.velocity[1] = 0.0f;
            fitem.velocity[0] = 0.0f;
        }
        this.m_lasttime = -1L;
    }

    protected void initSimulator(ForceSimulator fsim) {
        TupleSet ts = this.m_vis.getGroup(this.m_nodeGroup);
        if (ts == null) {
            return;
        }
        try {
            ts.addColumns(FORCEITEM_SCHEMA);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        float startX = this.referrer == null ? 0.0f : (float)this.referrer.getX();
        float startY = this.referrer == null ? 0.0f : (float)this.referrer.getY();
        startX = Float.isNaN(startX) ? 0.0f : startX;
        startY = Float.isNaN(startY) ? 0.0f : startY;
        Iterator<VisualItem> iter = this.m_vis.visibleItems(this.m_nodeGroup);
        while (iter.hasNext()) {
            VisualItem item = iter.next();
            ForceItem fitem = (ForceItem)item.get(FORCEITEM);
            fitem.mass = this.getMassValue(item);
            double x = item.getEndX();
            double y = item.getEndY();
            fitem.location[0] = Double.isNaN(x) ? startX : (float)x;
            fitem.location[1] = Double.isNaN(y) ? startY : (float)y;
            fsim.addItem(fitem);
        }
        if (this.m_edgeGroup != null) {
            iter = this.m_vis.visibleItems(this.m_edgeGroup);
            while (iter.hasNext()) {
                EdgeItem e = (EdgeItem)iter.next();
                NodeItem n1 = e.getSourceItem();
                ForceItem f1 = (ForceItem)n1.get(FORCEITEM);
                NodeItem n2 = e.getTargetItem();
                ForceItem f2 = (ForceItem)n2.get(FORCEITEM);
                float coeff = this.getSpringCoefficient(e);
                float slen = this.getSpringLength(e);
                fsim.addSpring(f1, f2, coeff >= 0.0f ? coeff : -1.0f, slen >= 0.0f ? slen : -1.0f);
            }
        }
    }

    protected float getMassValue(VisualItem n) {
        return 1.0f;
    }

    protected float getSpringLength(EdgeItem e) {
        return -1.0f;
    }

    protected float getSpringCoefficient(EdgeItem e) {
        return -1.0f;
    }

    public VisualItem getReferrer() {
        return this.referrer;
    }

    public void setReferrer(VisualItem referrer) {
        this.referrer = referrer;
    }
}

