/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout.graph;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import prefuse.action.layout.graph.TreeLayout;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.tuple.TupleSet;
import prefuse.data.util.TreeNodeIterator;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class SquarifiedTreeMapLayout
extends TreeLayout {
    public static final String AREA = "_area";
    public static final Schema AREA_SCHEMA = new Schema();
    private static Comparator s_cmp;
    private ArrayList m_kids = new ArrayList();
    private ArrayList m_row = new ArrayList();
    private Rectangle2D m_r = new Rectangle2D.Double();
    private double m_frame;

    static {
        AREA_SCHEMA.addColumn(AREA, Double.TYPE);
        s_cmp = new Comparator(){

            public int compare(Object o1, Object o2) {
                double s2;
                double s1 = ((VisualItem)o1).getDouble(SquarifiedTreeMapLayout.AREA);
                return s1 > (s2 = ((VisualItem)o2).getDouble(SquarifiedTreeMapLayout.AREA)) ? 1 : (s1 < s2 ? -1 : 0);
            }
        };
    }

    public SquarifiedTreeMapLayout(String group) {
        this(group, 0.0);
    }

    public SquarifiedTreeMapLayout(String group, double frame) {
        super(group);
        this.setFrameWidth(frame);
    }

    public void setFrameWidth(double frame) {
        if (frame < 0.0) {
            throw new IllegalArgumentException("Frame value must be greater than or equal to 0.");
        }
        this.m_frame = frame;
    }

    public double getFrameWidth() {
        return this.m_frame;
    }

    public void run(double frac) {
        NodeItem root = this.getLayoutRoot();
        Rectangle2D b = this.getLayoutBounds();
        this.m_r.setRect(b.getX(), b.getY(), b.getWidth() - 1.0, b.getHeight() - 1.0);
        this.computeAreas(root);
        this.setX(root, null, 0.0);
        this.setY(root, null, 0.0);
        root.setBounds(0.0, 0.0, this.m_r.getWidth(), this.m_r.getHeight());
        this.updateArea(root, this.m_r);
        this.layout(root, this.m_r);
    }

    private void computeAreas(NodeItem root) {
        double area;
        NodeItem n;
        int leafCount = 0;
        Graph g = (Graph)this.m_vis.getGroup(this.m_group);
        TupleSet nodes = g.getNodes();
        nodes.addColumns(AREA_SCHEMA);
        TreeNodeIterator iter = new TreeNodeIterator(root);
        while (iter.hasNext()) {
            n = (NodeItem)iter.next();
            n.setDouble(AREA, 0.0);
        }
        iter = new TreeNodeIterator(root, false);
        while (iter.hasNext()) {
            n = (NodeItem)iter.next();
            area = 0.0;
            if (n.getChildCount() == 0) {
                area = n.getSize();
                ++leafCount;
            } else if (n.isExpanded()) {
                NodeItem c = (NodeItem)n.getFirstChild();
                while (c != null) {
                    area += c.getDouble(AREA);
                    ++leafCount;
                    c = (NodeItem)c.getNextSibling();
                }
            }
            n.setDouble(AREA, area);
        }
        Rectangle2D b = this.getLayoutBounds();
        area = (b.getWidth() - 1.0) * (b.getHeight() - 1.0);
        double scale = area / root.getDouble(AREA);
        iter = new TreeNodeIterator(root);
        while (iter.hasNext()) {
            NodeItem n2 = (NodeItem)iter.next();
            n2.setDouble(AREA, n2.getDouble(AREA) * scale);
        }
    }

    private void layout(NodeItem p, Rectangle2D r) {
        Iterator<? extends Node> childIter = p.children();
        while (childIter.hasNext()) {
            this.m_kids.add(childIter.next());
        }
        Collections.sort(this.m_kids, s_cmp);
        double w = Math.min(r.getWidth(), r.getHeight());
        this.squarify(this.m_kids, this.m_row, w, r);
        this.m_kids.clear();
        childIter = p.children();
        while (childIter.hasNext()) {
            NodeItem c = (NodeItem)childIter.next();
            if (c.getChildCount() <= 0 || !(c.getDouble(AREA) > 0.0)) continue;
            this.updateArea(c, r);
            this.layout(c, r);
        }
    }

    private void updateArea(NodeItem n, Rectangle2D r) {
        Rectangle2D b = n.getBounds();
        if (this.m_frame == 0.0) {
            r.setRect(b);
            return;
        }
        double dA = 2.0 * this.m_frame * (b.getWidth() + b.getHeight() - 2.0 * this.m_frame);
        double A = n.getDouble(AREA) - dA;
        double s = 0.0;
        Iterator<? extends Node> childIter = n.children();
        while (childIter.hasNext()) {
            s += ((NodeItem)childIter.next()).getDouble(AREA);
        }
        double t = A / s;
        childIter = n.children();
        while (childIter.hasNext()) {
            NodeItem c = (NodeItem)childIter.next();
            c.setDouble(AREA, c.getDouble(AREA) * t);
        }
        r.setRect(b.getX() + this.m_frame, b.getY() + this.m_frame, b.getWidth() - 2.0 * this.m_frame, b.getHeight() - 2.0 * this.m_frame);
    }

    private void squarify(List c, List row, double w, Rectangle2D r) {
        int len;
        double worst = Double.MAX_VALUE;
        while ((len = c.size()) > 0) {
            VisualItem item = (VisualItem)c.get(len - 1);
            double a = item.getDouble(AREA);
            if (a <= 0.0) {
                c.remove(len - 1);
                continue;
            }
            row.add(item);
            double nworst = this.worst(row, w);
            if (nworst <= worst) {
                c.remove(len - 1);
                worst = nworst;
                continue;
            }
            row.remove(row.size() - 1);
            r = this.layoutRow(row, w, r);
            w = Math.min(r.getWidth(), r.getHeight());
            row.clear();
            worst = Double.MAX_VALUE;
        }
        if (row.size() > 0) {
            r = this.layoutRow(row, w, r);
            row.clear();
        }
    }

    private double worst(List rlist, double w) {
        double rmax = Double.MIN_VALUE;
        double rmin = Double.MAX_VALUE;
        double s = 0.0;
        Iterator iter = rlist.iterator();
        while (iter.hasNext()) {
            double r = ((VisualItem)iter.next()).getDouble(AREA);
            rmin = Math.min(rmin, r);
            rmax = Math.max(rmax, r);
            s += r;
        }
        s *= s;
        w *= w;
        return Math.max(w * rmax / s, s / (w * rmin));
    }

    private Rectangle2D layoutRow(List row, double w, Rectangle2D r) {
        double s = 0.0;
        Iterator rowIter = row.iterator();
        while (rowIter.hasNext()) {
            s += ((VisualItem)rowIter.next()).getDouble(AREA);
        }
        double x = r.getX();
        double y = r.getY();
        double d = 0.0;
        double h = w == 0.0 ? 0.0 : s / w;
        boolean horiz = w == r.getWidth();
        for (NodeItem n : row) {
            NodeItem p = (NodeItem)n.getParent();
            if (horiz) {
                this.setX(n, p, x + d);
                this.setY(n, p, y);
            } else {
                this.setX(n, p, x);
                this.setY(n, p, y + d);
            }
            double nw = n.getDouble(AREA) / h;
            if (horiz) {
                this.setNodeDimensions(n, nw, h);
                d += nw;
                continue;
            }
            this.setNodeDimensions(n, h, nw);
            d += nw;
        }
        if (horiz) {
            r.setRect(x, y + h, r.getWidth(), r.getHeight() - h);
        } else {
            r.setRect(x + h, y, r.getWidth() - h, r.getHeight());
        }
        return r;
    }

    private void setNodeDimensions(NodeItem n, double w, double h) {
        n.setBounds(n.getX(), n.getY(), w, h);
    }
}

