/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data;

import java.util.ArrayList;
import java.util.Iterator;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.column.Column;
import prefuse.data.column.ColumnMetadata;
import prefuse.data.event.ExpressionListener;
import prefuse.data.event.ProjectionListener;
import prefuse.data.event.TableListener;
import prefuse.data.expression.BooleanLiteral;
import prefuse.data.expression.Expression;
import prefuse.data.expression.Predicate;
import prefuse.data.tuple.TableTuple;
import prefuse.data.util.AcceptAllColumnProjection;
import prefuse.data.util.CascadedRowManager;
import prefuse.data.util.ColumnProjection;
import prefuse.util.collections.CompositeIterator;
import prefuse.util.collections.IntIterator;

public class CascadedTable
extends Table {
    protected Table m_parent;
    protected ArrayList m_pnames;
    protected ColumnProjection m_colFilter;
    protected Predicate m_rowFilter;
    protected Listener m_listener;

    public CascadedTable(Table parent) {
        this(parent, null, null);
    }

    public CascadedTable(Table parent, Predicate rowFilter) {
        this(parent, rowFilter, null);
    }

    public CascadedTable(Table parent, ColumnProjection colFilter) {
        this(parent, null, colFilter);
    }

    public CascadedTable(Table parent, Predicate rowFilter, ColumnProjection colFilter) {
        this(parent, rowFilter, colFilter, TableTuple.class);
    }

    protected CascadedTable(Table parent, Predicate rowFilter, ColumnProjection colFilter, Class tupleType) {
        super(0, 0, tupleType);
        this.m_parent = parent;
        this.m_pnames = new ArrayList();
        this.m_rows = new CascadedRowManager(this);
        this.m_listener = new Listener();
        this.setColumnProjection(colFilter);
        this.setRowFilter(rowFilter);
        this.m_parent.addTableListener(this.m_listener);
    }

    protected CascadedTable() {
        this(TableTuple.class);
    }

    protected CascadedTable(Class tupleType) {
        super(0, 0, tupleType);
        this.m_pnames = new ArrayList();
    }

    protected void filterColumns() {
        if (this.m_parent == null) {
            return;
        }
        int i = 0;
        while (i < this.m_pnames.size()) {
            String name = (String)this.m_pnames.get(i);
            Column col = this.m_parent.getColumn(i);
            boolean contained = this.m_names.contains(name);
            if (!this.m_colFilter.include(col, name) || contained) {
                this.m_pnames.remove(i--);
                if (!contained) {
                    ((Table.ColumnEntry)this.m_entries.get(name)).dispose();
                    this.m_entries.remove(name);
                }
                this.fireTableEvent(this.m_rows.getMinimumRow(), this.m_rows.getMaximumRow(), i, -1);
            }
            ++i;
        }
        this.m_pnames.clear();
        Iterator<String> pcols = this.m_parent.getColumnNames();
        int i2 = 0;
        int j = this.m_columns.size();
        while (pcols.hasNext()) {
            String name = pcols.next();
            Column col = this.m_parent.getColumn(i2);
            if (this.m_colFilter.include(col, name) && !this.m_names.contains(name)) {
                this.m_pnames.add(name);
                Table.ColumnEntry entry = (Table.ColumnEntry)this.m_entries.get(name);
                if (entry == null) {
                    entry = new Table.ColumnEntry(j++, col, new ColumnMetadata(this, name));
                    this.m_entries.put(name, entry);
                    this.fireTableEvent(this.m_rows.getMinimumRow(), this.m_rows.getMaximumRow(), i2, 1);
                } else {
                    entry.colnum = j++;
                }
                this.m_lastCol = this.m_columns.size() - 1;
            }
            ++i2;
        }
    }

    public void filterRows() {
        if (this.m_parent == null) {
            return;
        }
        CascadedRowManager rowman = (CascadedRowManager)this.m_rows;
        IntIterator crows = this.m_rows.rows();
        while (crows.hasNext()) {
            int crow = crows.nextInt();
            if (this.m_rowFilter.getBoolean(this.m_parent.getTuple(rowman.getParentRow(crow)))) continue;
            this.removeCascadedRow(crow);
        }
        Iterator<? extends Tuple> ptuples = this.m_parent.tuples(this.m_rowFilter);
        while (ptuples.hasNext()) {
            Tuple pt = ptuples.next();
            int prow = pt.getRow();
            if (rowman.getChildRow(prow) != -1) continue;
            this.addCascadedRow(prow);
        }
    }

    public ColumnProjection getColumnProjection() {
        return this.m_colFilter;
    }

    public void setColumnProjection(ColumnProjection colFilter) {
        if (this.m_colFilter != null) {
            this.m_colFilter.removeProjectionListener(this.m_listener);
        }
        this.m_colFilter = colFilter == null ? new AcceptAllColumnProjection() : colFilter;
        this.m_colFilter.addProjectionListener(this.m_listener);
        this.filterColumns();
    }

    public Predicate getRowFilter() {
        return this.m_rowFilter;
    }

    public void setRowFilter(Predicate rowFilter) {
        if (this.m_rowFilter != null) {
            this.m_rowFilter.removeExpressionListener(this.m_listener);
        }
        Predicate predicate = this.m_rowFilter = rowFilter == null ? BooleanLiteral.TRUE : rowFilter;
        if (this.m_rowFilter != BooleanLiteral.TRUE) {
            this.m_rowFilter.addExpressionListener(this.m_listener);
        }
        this.filterRows();
    }

    public int getColumnCount() {
        return this.m_columns.size() + this.m_pnames.size();
    }

    public int getLocalColumnCount() {
        return this.m_columns.size();
    }

    public Table getParentTable() {
        return this.m_parent;
    }

    public int getParentRow(int row) {
        return ((CascadedRowManager)this.m_rows).getParentRow(row);
    }

    public int getChildRow(int prow) {
        return ((CascadedRowManager)this.m_rows).getChildRow(prow);
    }

    public int addRow() {
        if (this.m_parent != null) {
            throw new IllegalStateException("Add row not supported for CascadedTable.");
        }
        return super.addRow();
    }

    public void addRows(int nrows) {
        if (this.m_parent != null) {
            throw new IllegalStateException("Add rows not supported for CascadedTable.");
        }
        super.addRows(nrows);
    }

    public boolean removeRow(int row) {
        if (this.m_parent != null) {
            throw new IllegalStateException("Remove row not supported for CascadedTable.");
        }
        return super.removeRow(row);
    }

    protected int addCascadedRow(int prow) {
        int r = this.m_rows.addRow();
        ((CascadedRowManager)this.m_rows).put(r, prow);
        this.updateRowCount();
        this.fireTableEvent(r, r, -1, 1);
        return r;
    }

    protected boolean removeCascadedRow(int row) {
        boolean rv = super.removeRow(row);
        if (rv) {
            ((CascadedRowManager)this.m_rows).remove(row);
        }
        return rv;
    }

    public String getColumnName(int col) {
        int local = this.m_names.size();
        if (col >= local) {
            return (String)this.m_pnames.get(col - local);
        }
        return (String)this.m_names.get(col);
    }

    public int getColumnNumber(Column col) {
        int idx = this.m_columns.indexOf(col);
        if (idx == -1 && this.m_parent != null) {
            idx = this.m_parent.getColumnNumber(col);
            if (idx == -1) {
                return idx;
            }
            String name = this.m_parent.getColumnName(idx);
            if ((idx = this.m_pnames.indexOf(name)) != -1) {
                idx += this.m_columns.size();
            }
        }
        return idx;
    }

    public Column getColumn(int col) {
        this.m_lastCol = col;
        int local = this.m_names.size();
        if (col >= local && this.m_parent != null) {
            return this.m_parent.getColumn((String)this.m_pnames.get(col - local));
        }
        return (Column)this.m_columns.get(col);
    }

    protected boolean hasColumn(String name) {
        int idx = this.getColumnNumber(name);
        return idx >= 0 && idx < this.getLocalColumnCount();
    }

    protected Iterator getColumnNames() {
        if (this.m_parent == null) {
            return this.m_names.iterator();
        }
        return new CompositeIterator(this.m_names.iterator(), this.m_pnames.iterator());
    }

    protected void invalidateSchema() {
        super.invalidateSchema();
        this.filterColumns();
    }

    private class Listener
    implements TableListener,
    ProjectionListener,
    ExpressionListener {
        private Listener() {
        }

        public void tableChanged(Table t, int start, int end, int col, int type) {
            if (t != CascadedTable.this.m_parent) {
                return;
            }
            CascadedRowManager rowman = (CascadedRowManager)CascadedTable.this.m_rows;
            switch (type) {
                case 0: {
                    if (col == -1) break;
                    int r = start;
                    int cr = -1;
                    while (r <= end) {
                        cr = rowman.getChildRow(r);
                        if (cr != -1) {
                            if (CascadedTable.this.m_rowFilter.getBoolean(CascadedTable.this.m_parent.getTuple(r))) {
                                int idx = CascadedTable.this.getColumnNumber(CascadedTable.this.m_parent.getColumnName(col));
                                if (idx >= CascadedTable.this.getLocalColumnCount()) {
                                    CascadedTable.this.fireTableEvent(cr, cr, idx, 0);
                                }
                            } else {
                                CascadedTable.this.removeCascadedRow(cr);
                            }
                        } else if (CascadedTable.this.m_rowFilter.getBoolean(CascadedTable.this.m_parent.getTuple(r)) && (cr = rowman.getChildRow(r)) < 0) {
                            CascadedTable.this.addCascadedRow(r);
                        }
                        ++r;
                    }
                    break;
                }
                case -1: {
                    if (col == -1) {
                        int r = start;
                        int cr = -1;
                        while (r <= end) {
                            cr = rowman.getChildRow(r);
                            if (cr != -1) {
                                CascadedTable.this.removeCascadedRow(cr);
                            }
                            ++r;
                        }
                        break;
                    }
                    CascadedTable.this.filterColumns();
                    break;
                }
                case 1: {
                    if (col == -1) {
                        int r = start;
                        while (r <= end) {
                            if (CascadedTable.this.m_rowFilter.getBoolean(CascadedTable.this.m_parent.getTuple(r)) && rowman.getChildRow(r) < 0) {
                                CascadedTable.this.addCascadedRow(r);
                            }
                            ++r;
                        }
                        break;
                    }
                    CascadedTable.this.filterColumns();
                }
            }
        }

        public void projectionChanged(ColumnProjection projection) {
            if (projection == CascadedTable.this.m_colFilter) {
                CascadedTable.this.filterColumns();
            }
        }

        public void expressionChanged(Expression expr) {
            if (expr == CascadedTable.this.m_rowFilter) {
                CascadedTable.this.filterRows();
            }
        }
    }
}

