/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import java.util.concurrent.CopyOnWriteArrayList;
import prefuse.data.Tuple;
import prefuse.data.event.ExpressionListener;
import prefuse.data.expression.Expression;
import prefuse.data.expression.ExpressionVisitor;

public abstract class AbstractExpression
implements Expression,
ExpressionListener {
    private CopyOnWriteArrayList<ExpressionListener> m_listeners = new CopyOnWriteArrayList();

    public void visit(ExpressionVisitor v) {
        v.visitExpression(this);
    }

    public final void addExpressionListener(ExpressionListener lstnr) {
        if (!this.m_listeners.contains(lstnr)) {
            this.m_listeners.add(lstnr);
            this.addChildListeners();
        }
    }

    public final void removeExpressionListener(ExpressionListener lstnr) {
        this.m_listeners.remove(lstnr);
        if (this.m_listeners.size() == 0) {
            this.removeChildListeners();
        }
    }

    protected final boolean hasListeners() {
        return this.m_listeners != null && this.m_listeners.size() > 0;
    }

    protected final void fireExpressionChange() {
        Object[] lstnrs = this.m_listeners.toArray();
        int i = 0;
        while (i < lstnrs.length) {
            ((ExpressionListener)lstnrs[i]).expressionChanged(this);
            ++i;
        }
    }

    protected void addChildListeners() {
    }

    protected void removeChildListeners() {
    }

    public void expressionChanged(Expression expr) {
        this.fireExpressionChange();
    }

    public Object get(Tuple t) {
        throw new UnsupportedOperationException();
    }

    public int getInt(Tuple t) {
        throw new UnsupportedOperationException();
    }

    public long getLong(Tuple t) {
        throw new UnsupportedOperationException();
    }

    public float getFloat(Tuple t) {
        throw new UnsupportedOperationException();
    }

    public double getDouble(Tuple t) {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(Tuple t) {
        throw new UnsupportedOperationException();
    }
}

