/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import prefuse.data.Tuple;
import prefuse.data.expression.AbstractExpression;
import prefuse.data.expression.BooleanLiteral;
import prefuse.data.expression.NumericLiteral;
import prefuse.data.expression.ObjectLiteral;
import prefuse.util.TypeLib;

public abstract class Literal
extends AbstractExpression {
    public static Literal getLiteral(Tuple t, String field) {
        Class<?> type = t.getColumnType(field);
        if (type == Integer.TYPE) {
            return new NumericLiteral(t.getInt(field));
        }
        if (type == Long.TYPE) {
            return new NumericLiteral(t.getLong(field));
        }
        if (type == Float.TYPE) {
            return new NumericLiteral(t.getFloat(field));
        }
        if (type == Double.TYPE) {
            return new NumericLiteral(t.getDouble(field));
        }
        if (type == Boolean.TYPE) {
            return new BooleanLiteral(t.getBoolean(field));
        }
        return new ObjectLiteral(t.get(field));
    }

    public static Literal getLiteral(Object val) {
        return Literal.getLiteral(val, val.getClass());
    }

    public static Literal getLiteral(Object val, Class type) {
        if (TypeLib.isNumericType(type)) {
            return new NumericLiteral(val);
        }
        if (type == Boolean.TYPE) {
            return new BooleanLiteral((Boolean)val);
        }
        if (type.isInstance(val)) {
            return new ObjectLiteral(val);
        }
        throw new IllegalArgumentException("Object does not match the provided Class type.");
    }
}

