/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import java.util.logging.Logger;
import prefuse.data.expression.AndPredicate;
import prefuse.data.expression.ArithmeticExpression;
import prefuse.data.expression.BooleanLiteral;
import prefuse.data.expression.ColumnExpression;
import prefuse.data.expression.ComparisonPredicate;
import prefuse.data.expression.Expression;
import prefuse.data.expression.Function;
import prefuse.data.expression.FunctionTable;
import prefuse.data.expression.IfExpression;
import prefuse.data.expression.NotPredicate;
import prefuse.data.expression.NumericLiteral;
import prefuse.data.expression.ObjectLiteral;
import prefuse.data.expression.OrPredicate;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.XorPredicate;
import prefuse.data.expression.parser.ExpressionParserConstants;
import prefuse.data.expression.parser.ExpressionParserTokenManager;
import prefuse.data.expression.parser.JavaCharStream;
import prefuse.data.expression.parser.ParseException;
import prefuse.data.expression.parser.Token;
import prefuse.util.StringLib;

public class ExpressionParser
implements ExpressionParserConstants {
    private static final Logger s_logger = Logger.getLogger(ExpressionParser.class.getName());
    private static boolean s_init = false;
    private static Throwable s_error;
    private static boolean jj_initialized_once;
    public static ExpressionParserTokenManager token_source;
    static JavaCharStream jj_input_stream;
    public static Token token;
    public static Token jj_nt;
    private static int jj_ntk;
    private static int jj_gen;
    private static final int[] jj_la1;
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static Vector<int[]> jj_expentries;
    private static int[] jj_expentry;
    private static int jj_kind;

    static {
        jj_initialized_once = false;
        jj_la1 = new int[20];
        ExpressionParser.jj_la1_0();
        ExpressionParser.jj_la1_1();
        jj_expentries = new Vector();
        jj_kind = -1;
    }

    public static synchronized Expression parse(String expr, boolean throwsException) {
        if (!s_init) {
            new ExpressionParser(new StringReader(expr));
            s_init = true;
        } else {
            ExpressionParser.ReInit(new StringReader(expr));
        }
        try {
            Expression e = ExpressionParser.Parse();
            s_error = null;
            s_logger.info("Parsed Expression: " + e);
            return e;
        }
        catch (ParseException t) {
            s_error = t;
            if (throwsException) {
                throw t;
            }
            s_logger.warning("Expression Parse Error: " + t.getMessage() + "\n" + StringLib.getStackTrace(t));
            return null;
        }
    }

    public static synchronized Expression parse(String expr) {
        return ExpressionParser.parse(expr, false);
    }

    public static synchronized Predicate predicate(String expr) {
        Expression ex = ExpressionParser.parse(expr, false);
        if (ex == null) {
            return null;
        }
        if (ex instanceof Predicate) {
            return (Predicate)ex;
        }
        s_error = new ClassCastException("Expression is not a predicate");
        return null;
    }

    public static synchronized Throwable getError() {
        return s_error;
    }

    private static String unescape(String s) {
        int idx;
        int len = s.length();
        int base = 0;
        String escapes = "tnrbf\\\"'";
        String chars = "\t\n\r\b\f\\\"'";
        StringBuffer sbuf = null;
        while ((idx = s.indexOf(92, base)) != -1) {
            if (sbuf != null) {
                sbuf.append(s.substring(base, idx));
            }
            if (idx + 1 == len) break;
            char c = s.charAt(idx + 1);
            int cidx = escapes.indexOf(c);
            if (cidx == -1) {
                sbuf.append('\\');
                sbuf.append(c);
            } else {
                if (sbuf == null) {
                    sbuf = new StringBuffer(s.substring(base, idx));
                }
                sbuf.append(chars.charAt(cidx));
            }
            base = idx + 2;
        }
        if (sbuf != null && base < len) {
            sbuf.append(s.substring(base));
        }
        return sbuf == null ? s : sbuf.toString();
    }

    public static final String Name() throws ParseException {
        Token t = ExpressionParser.jj_consume_token(26);
        return t.image;
    }

    public static final String Quoted() throws ParseException {
        Token t = ExpressionParser.jj_consume_token(25);
        return t.image.substring(1, t.image.length() - 1);
    }

    public static final Expression Parse() throws ParseException {
        switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 37: 
            case 38: {
                Expression e = ExpressionParser.Expression();
                ExpressionParser.jj_consume_token(0);
                return e;
            }
            case 0: {
                ExpressionParser.jj_consume_token(0);
                throw new ParseException("No expression provided");
            }
        }
        ExpressionParser.jj_la1[0] = jj_gen;
        ExpressionParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final Expression Expression() throws ParseException {
        Expression e = ExpressionParser.OrExpression();
        return e;
    }

    public static final Expression OrExpression() throws ParseException {
        Expression l = ExpressionParser.XorExpression();
        block3: while (true) {
            switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                case 13: {
                    break;
                }
                default: {
                    ExpressionParser.jj_la1[1] = jj_gen;
                    break block3;
                }
            }
            ExpressionParser.jj_consume_token(13);
            Expression r = ExpressionParser.XorExpression();
            if (l instanceof OrPredicate) {
                ((OrPredicate)l).add((Predicate)r);
                continue;
            }
            l = new OrPredicate((Predicate)l, (Predicate)r);
        }
        return l;
    }

    public static final Expression XorExpression() throws ParseException {
        Expression l = ExpressionParser.AndExpression();
        block3: while (true) {
            switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                case 15: {
                    break;
                }
                default: {
                    ExpressionParser.jj_la1[2] = jj_gen;
                    break block3;
                }
            }
            ExpressionParser.jj_consume_token(15);
            Expression r = ExpressionParser.AndExpression();
            if (l instanceof XorPredicate) {
                ((XorPredicate)l).add((Predicate)r);
                continue;
            }
            l = new XorPredicate((Predicate)l, (Predicate)r);
        }
        return l;
    }

    public static final Expression AndExpression() throws ParseException {
        Expression l = ExpressionParser.EqualityExpression();
        block3: while (true) {
            switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    ExpressionParser.jj_la1[3] = jj_gen;
                    break block3;
                }
            }
            ExpressionParser.jj_consume_token(12);
            Expression r = ExpressionParser.EqualityExpression();
            if (l instanceof AndPredicate) {
                ((AndPredicate)l).add((Predicate)r);
                continue;
            }
            l = new AndPredicate((Predicate)l, (Predicate)r);
        }
        return l;
    }

    public static final Expression EqualityExpression() throws ParseException {
        Expression l = ExpressionParser.RelationalExpression();
        block7: while (true) {
            Token t;
            switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                case 31: 
                case 36: {
                    break;
                }
                default: {
                    ExpressionParser.jj_la1[4] = jj_gen;
                    break block7;
                }
            }
            switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                case 31: {
                    t = ExpressionParser.jj_consume_token(31);
                    break;
                }
                case 36: {
                    t = ExpressionParser.jj_consume_token(36);
                    break;
                }
                default: {
                    ExpressionParser.jj_la1[5] = jj_gen;
                    ExpressionParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression r = ExpressionParser.RelationalExpression();
            int op = t.kind == 31 ? 2 : 3;
            l = new ComparisonPredicate(op, l, r);
        }
        return l;
    }

    public static final Expression RelationalExpression() throws ParseException {
        int op = -1;
        Expression l = ExpressionParser.AdditiveExpression();
        block15: while (true) {
            Token t;
            switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                case 32: 
                case 33: 
                case 34: 
                case 35: {
                    break;
                }
                default: {
                    ExpressionParser.jj_la1[6] = jj_gen;
                    break block15;
                }
            }
            switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                case 33: {
                    t = ExpressionParser.jj_consume_token(33);
                    break;
                }
                case 32: {
                    t = ExpressionParser.jj_consume_token(32);
                    break;
                }
                case 34: {
                    t = ExpressionParser.jj_consume_token(34);
                    break;
                }
                case 35: {
                    t = ExpressionParser.jj_consume_token(35);
                    break;
                }
                default: {
                    ExpressionParser.jj_la1[7] = jj_gen;
                    ExpressionParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression r = ExpressionParser.AdditiveExpression();
            switch (t.kind) {
                case 33: {
                    op = 0;
                    break;
                }
                case 32: {
                    op = 1;
                    break;
                }
                case 34: {
                    op = 4;
                    break;
                }
                case 35: {
                    op = 5;
                }
            }
            l = new ComparisonPredicate(op, l, r);
        }
        return l;
    }

    public static final Expression AdditiveExpression() throws ParseException {
        int op = -1;
        Expression l = ExpressionParser.MultiplicativeExpression();
        block13: while (true) {
            Token t;
            switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                case 37: 
                case 38: 
                case 42: {
                    break;
                }
                default: {
                    ExpressionParser.jj_la1[8] = jj_gen;
                    break block13;
                }
            }
            switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                case 37: {
                    t = ExpressionParser.jj_consume_token(37);
                    break;
                }
                case 38: {
                    t = ExpressionParser.jj_consume_token(38);
                    break;
                }
                case 42: {
                    t = ExpressionParser.jj_consume_token(42);
                    break;
                }
                default: {
                    ExpressionParser.jj_la1[9] = jj_gen;
                    ExpressionParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression r = ExpressionParser.MultiplicativeExpression();
            switch (t.kind) {
                case 37: {
                    op = 0;
                    break;
                }
                case 38: {
                    op = 1;
                    break;
                }
                case 42: {
                    op = 5;
                }
            }
            l = new ArithmeticExpression(op, l, r);
        }
        return l;
    }

    public static final Expression MultiplicativeExpression() throws ParseException {
        int op = -1;
        Expression l = ExpressionParser.UnaryExpression();
        block13: while (true) {
            Token t;
            switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                case 39: 
                case 40: 
                case 41: {
                    break;
                }
                default: {
                    ExpressionParser.jj_la1[10] = jj_gen;
                    break block13;
                }
            }
            switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                case 39: {
                    t = ExpressionParser.jj_consume_token(39);
                    break;
                }
                case 40: {
                    t = ExpressionParser.jj_consume_token(40);
                    break;
                }
                case 41: {
                    t = ExpressionParser.jj_consume_token(41);
                    break;
                }
                default: {
                    ExpressionParser.jj_la1[11] = jj_gen;
                    ExpressionParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression r = ExpressionParser.UnaryExpression();
            switch (t.kind) {
                case 39: {
                    op = 2;
                    break;
                }
                case 40: {
                    op = 3;
                    break;
                }
                case 41: {
                    op = 4;
                }
            }
            l = new ArithmeticExpression(op, l, r);
        }
        return l;
    }

    public static final Expression UnaryExpression() throws ParseException {
        switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
            case 37: 
            case 38: {
                Token t;
                switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                    case 37: {
                        t = ExpressionParser.jj_consume_token(37);
                        break;
                    }
                    case 38: {
                        t = ExpressionParser.jj_consume_token(38);
                        break;
                    }
                    default: {
                        ExpressionParser.jj_la1[12] = jj_gen;
                        ExpressionParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                Expression e = ExpressionParser.UnaryExpression();
                if (t.kind == 38 && e instanceof NumericLiteral) {
                    Number n = (Number)e.get(null);
                    if (n instanceof Integer) {
                        return new NumericLiteral(-1 * n.intValue());
                    }
                    if (n instanceof Double) {
                        return new NumericLiteral(-1.0 * n.doubleValue());
                    }
                    if (n instanceof Long) {
                        return new NumericLiteral(-1L * n.longValue());
                    }
                    if (n instanceof Float) {
                        return new NumericLiteral(-1.0f * n.floatValue());
                    }
                    return new ArithmeticExpression(2, new NumericLiteral(-1), e);
                }
                if (t.kind == 38) {
                    return new ArithmeticExpression(2, new NumericLiteral(-1), e);
                }
                return e;
            }
            case 14: {
                Expression e = ExpressionParser.UnaryExpressionNotPlusMinus();
                return e;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                Expression e = ExpressionParser.PrimaryExpression();
                return e;
            }
        }
        ExpressionParser.jj_la1[13] = jj_gen;
        ExpressionParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final Expression UnaryExpressionNotPlusMinus() throws ParseException {
        ExpressionParser.jj_consume_token(14);
        Expression e = ExpressionParser.UnaryExpression();
        if (e instanceof NotPredicate) {
            return ((NotPredicate)e).getPredicate();
        }
        if (!(e instanceof Predicate)) {
            throw new ParseException("Can't negate a non-predicate");
        }
        return new NotPredicate((Predicate)e);
    }

    public static final Expression PrimaryExpression() throws ParseException {
        switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                Expression e = ExpressionParser.Literal();
                return e;
            }
            case 9: {
                Expression e = ExpressionParser.IfStatement();
                return e;
            }
            case 25: 
            case 26: {
                Expression e = ExpressionParser.Identifier();
                return e;
            }
            case 29: {
                ExpressionParser.jj_consume_token(29);
                Expression e = ExpressionParser.Expression();
                ExpressionParser.jj_consume_token(30);
                return e;
            }
        }
        ExpressionParser.jj_la1[14] = jj_gen;
        ExpressionParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final Expression Literal() throws ParseException {
        switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
            case 16: {
                Token t = ExpressionParser.jj_consume_token(16);
                return new NumericLiteral(Integer.parseInt(t.image));
            }
            case 20: {
                Token t = ExpressionParser.jj_consume_token(20);
                return new NumericLiteral(Long.parseLong(t.image.substring(0, t.image.length() - 1)));
            }
            case 22: {
                Token t = ExpressionParser.jj_consume_token(22);
                return new NumericLiteral(Float.parseFloat(t.image));
            }
            case 21: {
                Token t = ExpressionParser.jj_consume_token(21);
                return new NumericLiteral(Double.parseDouble(t.image));
            }
            case 24: {
                Token t = ExpressionParser.jj_consume_token(24);
                String s = ExpressionParser.unescape(t.image.substring(1, t.image.length() - 1));
                return new ObjectLiteral(s);
            }
            case 6: {
                ExpressionParser.jj_consume_token(6);
                return new BooleanLiteral(true);
            }
            case 7: {
                ExpressionParser.jj_consume_token(7);
                return new BooleanLiteral(false);
            }
            case 8: {
                ExpressionParser.jj_consume_token(8);
                return new ObjectLiteral(null);
            }
        }
        ExpressionParser.jj_la1[15] = jj_gen;
        ExpressionParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final Expression Identifier() throws ParseException {
        Function f = null;
        switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
            case 25: {
                String s = ExpressionParser.Quoted();
                return new ColumnExpression(s);
            }
            case 26: {
                String s = ExpressionParser.Name();
                switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                    case 29: {
                        ExpressionParser.jj_consume_token(29);
                        f = FunctionTable.createFunction(s);
                        block7 : switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 14: 
                            case 16: 
                            case 20: 
                            case 21: 
                            case 22: 
                            case 24: 
                            case 25: 
                            case 26: 
                            case 29: 
                            case 37: 
                            case 38: {
                                Expression e = ExpressionParser.Expression();
                                f.addParameter(e);
                                while (true) {
                                    switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                                        case 43: {
                                            break;
                                        }
                                        default: {
                                            ExpressionParser.jj_la1[16] = jj_gen;
                                            break block7;
                                        }
                                    }
                                    ExpressionParser.jj_consume_token(43);
                                    e = ExpressionParser.Expression();
                                    f.addParameter(e);
                                }
                            }
                            default: {
                                ExpressionParser.jj_la1[17] = jj_gen;
                            }
                        }
                        ExpressionParser.jj_consume_token(30);
                        break;
                    }
                    default: {
                        ExpressionParser.jj_la1[18] = jj_gen;
                    }
                }
                return f == null ? new ColumnExpression(s) : f;
            }
        }
        ExpressionParser.jj_la1[19] = jj_gen;
        ExpressionParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final Expression IfStatement() throws ParseException {
        ExpressionParser.jj_consume_token(9);
        Expression p = ExpressionParser.Expression();
        ExpressionParser.jj_consume_token(10);
        Expression t = ExpressionParser.Expression();
        ExpressionParser.jj_consume_token(11);
        Expression e = ExpressionParser.Expression();
        if (!(p instanceof Predicate)) {
            throw new ParseException("IF-statement test must be a predicate");
        }
        return new IfExpression((Predicate)p, t, e);
    }

    private static void jj_la1_0() {
        int[] nArray = new int[20];
        nArray[0] = 661734337;
        nArray[1] = 8192;
        nArray[2] = 32768;
        nArray[3] = 4096;
        nArray[4] = Integer.MIN_VALUE;
        nArray[5] = Integer.MIN_VALUE;
        nArray[13] = 661734336;
        nArray[14] = 661717952;
        nArray[15] = 24183232;
        nArray[17] = 661734336;
        nArray[18] = 0x20000000;
        nArray[19] = 0x6000000;
        jj_la1_0 = nArray;
    }

    private static void jj_la1_1() {
        int[] nArray = new int[20];
        nArray[0] = 96;
        nArray[4] = 16;
        nArray[5] = 16;
        nArray[6] = 15;
        nArray[7] = 15;
        nArray[8] = 1120;
        nArray[9] = 1120;
        nArray[10] = 896;
        nArray[11] = 896;
        nArray[12] = 96;
        nArray[13] = 96;
        nArray[16] = 2048;
        nArray[17] = 96;
        jj_la1_1 = nArray;
    }

    public ExpressionParser(InputStream stream) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  You must");
            System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new JavaCharStream(stream, 1, 1);
        token_source = new ExpressionParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int i = 0;
        while (i < 20) {
            ExpressionParser.jj_la1[i] = -1;
            ++i;
        }
    }

    public static void ReInit(InputStream stream) {
        jj_input_stream.ReInit(stream, 1, 1);
        ExpressionParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int i = 0;
        while (i < 20) {
            ExpressionParser.jj_la1[i] = -1;
            ++i;
        }
    }

    public ExpressionParser(Reader stream) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  You must");
            System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new JavaCharStream(stream, 1, 1);
        token_source = new ExpressionParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int i = 0;
        while (i < 20) {
            ExpressionParser.jj_la1[i] = -1;
            ++i;
        }
    }

    public static void ReInit(Reader stream) {
        jj_input_stream.ReInit(stream, 1, 1);
        ExpressionParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int i = 0;
        while (i < 20) {
            ExpressionParser.jj_la1[i] = -1;
            ++i;
        }
    }

    public ExpressionParser(ExpressionParserTokenManager tm) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  You must");
            System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int i = 0;
        while (i < 20) {
            ExpressionParser.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(ExpressionParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int i = 0;
        while (i < 20) {
            ExpressionParser.jj_la1[i] = -1;
            ++i;
        }
    }

    private static final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = token;
        token = oldToken.next != null ? ExpressionParser.token.next : (ExpressionParser.token.next = ExpressionParserTokenManager.getNextToken());
        jj_ntk = -1;
        if (ExpressionParser.token.kind == kind) {
            ++jj_gen;
            return token;
        }
        token = oldToken;
        jj_kind = kind;
        throw ExpressionParser.generateParseException();
    }

    public static final Token getNextToken() {
        token = ExpressionParser.token.next != null ? ExpressionParser.token.next : (ExpressionParser.token.next = ExpressionParserTokenManager.getNextToken());
        jj_ntk = -1;
        ++jj_gen;
        return token;
    }

    public static final Token getToken(int index) {
        Token t = token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = ExpressionParserTokenManager.getNextToken());
            ++i;
        }
        return t;
    }

    private static final int jj_ntk() {
        jj_nt = ExpressionParser.token.next;
        if (jj_nt == null) {
            ExpressionParser.token.next = ExpressionParserTokenManager.getNextToken();
            jj_ntk = ExpressionParser.token.next.kind;
            return jj_ntk;
        }
        jj_ntk = ExpressionParser.jj_nt.kind;
        return jj_ntk;
    }

    public static ParseException generateParseException() {
        jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[44];
        int i = 0;
        while (i < 44) {
            la1tokens[i] = false;
            ++i;
        }
        if (jj_kind >= 0) {
            la1tokens[ExpressionParser.jj_kind] = true;
            jj_kind = -1;
        }
        i = 0;
        while (i < 20) {
            if (jj_la1[i] == jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    if ((jj_la1_1[i] & 1 << j) != 0) {
                        la1tokens[32 + j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 44) {
            if (la1tokens[i]) {
                jj_expentry = new int[1];
                ExpressionParser.jj_expentry[0] = i;
                jj_expentries.addElement(jj_expentry);
            }
            ++i;
        }
        int[][] exptokseq = new int[jj_expentries.size()][];
        int i2 = 0;
        while (i2 < jj_expentries.size()) {
            exptokseq[i2] = jj_expentries.elementAt(i2);
            ++i2;
        }
        return new ParseException(token, exptokseq, tokenImage);
    }

    public static final void enable_tracing() {
    }

    public static final void disable_tracing() {
    }
}

