/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import prefuse.data.Table;
import prefuse.data.io.AbstractTableWriter;
import prefuse.data.io.DataIOException;
import prefuse.data.io.FixedWidthTextTableSchema;
import prefuse.util.TypeLib;
import prefuse.util.collections.IntIterator;

public class FixedWidthTextTableWriter
extends AbstractTableWriter {
    private FixedWidthTextTableSchema m_schema;

    public FixedWidthTextTableWriter(FixedWidthTextTableSchema schema) {
        this.m_schema = schema;
    }

    public FixedWidthTextTableWriter(String location) throws DataIOException {
        this(FixedWidthTextTableSchema.load(location));
    }

    public FixedWidthTextTableSchema getFixedWidthSchema() {
        return this.m_schema;
    }

    public void setFixedWidthSchema(FixedWidthTextTableSchema schema) {
        this.m_schema = schema;
    }

    public void writeTable(Table table, OutputStream os) throws DataIOException {
        try {
            PrintStream out = new PrintStream(new BufferedOutputStream(os));
            char[] pad = new char[table.getColumnCount()];
            boolean[] pre = new boolean[table.getColumnCount()];
            int i = 0;
            while (i < table.getColumnCount()) {
                Class<?> type = table.getColumnType(i);
                pre[i] = TypeLib.isNumericType(type);
                pad[i] = pre[i] ? 48 : 32;
                ++i;
            }
            IntIterator rows = table.rows();
            while (rows.hasNext()) {
                int row = rows.nextInt();
                int i2 = 0;
                while (i2 < table.getColumnCount()) {
                    out.print(FixedWidthTextTableWriter.pack(table.getString(row, i2), this.m_schema.getColumnLength(i2), pre[i2], pad[i2]));
                    ++i2;
                }
                out.println();
            }
            out.flush();
        }
        catch (Exception e) {
            throw new DataIOException(e);
        }
    }

    private static String pack(String value, int len, boolean prepend, char pad) {
        int vlen = value.length();
        if (vlen < len) {
            StringBuffer sbuf = new StringBuffer();
            if (prepend) {
                sbuf.append(value);
            }
            int i = len;
            while (i < vlen) {
                sbuf.append(pad);
                ++i;
            }
            if (!prepend) {
                sbuf.append(value);
            }
            return sbuf.toString();
        }
        return value.substring(0, len);
    }
}

