/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.search;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import prefuse.data.Tuple;
import prefuse.data.search.SearchTupleSet;
import prefuse.data.tuple.DefaultTupleSet;
import prefuse.data.tuple.TupleSet;
import prefuse.util.StringLib;

public class RegexSearchTupleSet
extends SearchTupleSet {
    private String m_query = "";
    private boolean m_caseSensitive;
    private LinkedHashMap m_source = new LinkedHashMap();

    public RegexSearchTupleSet() {
        this(false);
    }

    public RegexSearchTupleSet(boolean caseSensitive) {
        this.m_caseSensitive = caseSensitive;
    }

    public String getQuery() {
        return this.m_query;
    }

    public void search(String query) {
        if (query == null) {
            query = "";
        }
        if (!this.m_caseSensitive) {
            query = query.toLowerCase();
        }
        if (query.equals(this.m_query)) {
            return;
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(query);
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.warning("Pattern compile failed.\n" + StringLib.getStackTrace(e));
            return;
        }
        Tuple[] rem = this.clearInternal();
        this.m_query = query;
        for (String field : this.m_source.keySet()) {
            TupleSet ts = (TupleSet)this.m_source.get(field);
            Iterator<? extends Tuple> tuples = ts.tuples();
            while (tuples.hasNext()) {
                Tuple t = tuples.next();
                String text = t.getString(field);
                if (!this.m_caseSensitive) {
                    text = text.toLowerCase();
                }
                if (!pattern.matcher(text).matches()) continue;
                this.addInternal(t);
            }
        }
        Tuple[] add = this.getTupleCount() > 0 ? this.toArray() : null;
        this.fireTupleEvent(add, rem);
    }

    public void index(Tuple t, String field) {
        TupleSet ts = (TupleSet)this.m_source.get(field);
        if (ts == null) {
            ts = new DefaultTupleSet();
            this.m_source.put(field, ts);
        }
        ts.addTuple(t);
    }

    public void unindex(Tuple t, String field) {
        TupleSet ts = (TupleSet)this.m_source.get(field);
        if (ts != null) {
            ts.removeTuple(t);
        }
    }

    public boolean isUnindexSupported() {
        return true;
    }

    public void clear() {
        this.m_source.clear();
        super.clear();
    }
}

