/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.tuple;

import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.SwingPropertyChangeSupport;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.expression.Expression;
import prefuse.data.expression.Predicate;
import prefuse.data.tuple.TupleSet;
import prefuse.data.util.FilterIteratorFactory;
import prefuse.data.util.Sort;
import prefuse.data.util.SortedTupleIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTupleSet
implements TupleSet {
    private CopyOnWriteArrayList<TupleSetListener> m_tupleListeners;
    private HashMap<String, Object> m_props;
    private SwingPropertyChangeSupport m_propSupport;

    @Override
    public Iterator<? extends Tuple> tuples(Predicate filter) {
        if (filter == null) {
            return this.tuples();
        }
        return FilterIteratorFactory.tuples(this, filter);
    }

    @Override
    public Iterator<? extends Tuple> tuples(Predicate filter, Sort sort) {
        if (sort == null) {
            return this.tuples(filter);
        }
        Comparator c = sort.getComparator(this);
        return new SortedTupleIterator(this.tuples(filter), this.getTupleCount(), c);
    }

    @Override
    public void addTupleSetListener(TupleSetListener tsl) {
        if (this.m_tupleListeners == null) {
            this.m_tupleListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_tupleListeners.contains(tsl)) {
            this.m_tupleListeners.add(tsl);
        }
    }

    @Override
    public void removeTupleSetListener(TupleSetListener tsl) {
        if (this.m_tupleListeners != null) {
            this.m_tupleListeners.remove(tsl);
        }
    }

    protected void fireTupleEvent(Table t, int start, int end, int type) {
        if (this.m_tupleListeners != null && this.m_tupleListeners.size() > 0) {
            Object[] lstnrs = this.m_tupleListeners.toArray();
            Tuple[] tuples = new Tuple[end - start + 1];
            int i = 0;
            int r = start;
            while (r <= end) {
                tuples[i] = t.getTuple(r);
                ++r;
                ++i;
            }
            i = 0;
            while (i < lstnrs.length) {
                TupleSetListener tsl = (TupleSetListener)lstnrs[i];
                if (type == 1) {
                    tsl.tupleSetChanged(this, tuples, EMPTY_ARRAY);
                } else {
                    tsl.tupleSetChanged(this, EMPTY_ARRAY, tuples);
                }
                ++i;
            }
        }
    }

    protected void fireTupleEvent(Tuple t, int type) {
        if (this.m_tupleListeners != null && this.m_tupleListeners.size() > 0) {
            Object[] lstnrs = this.m_tupleListeners.toArray();
            Tuple[] ts = new Tuple[]{t};
            int i = 0;
            while (i < lstnrs.length) {
                TupleSetListener tsl = (TupleSetListener)lstnrs[i];
                if (type == 1) {
                    tsl.tupleSetChanged(this, ts, EMPTY_ARRAY);
                } else {
                    tsl.tupleSetChanged(this, EMPTY_ARRAY, ts);
                }
                ++i;
            }
        }
    }

    protected void fireTupleEvent(Tuple[] addedParameter, Tuple[] removedParameter) {
        Tuple[] added = addedParameter;
        Tuple[] removed = removedParameter;
        if (this.m_tupleListeners != null && this.m_tupleListeners.size() > 0) {
            Object[] lstnrs = this.m_tupleListeners.toArray();
            added = added == null ? EMPTY_ARRAY : added;
            removed = removed == null ? EMPTY_ARRAY : removed;
            int i = 0;
            while (i < lstnrs.length) {
                TupleSetListener tsl = (TupleSetListener)lstnrs[i];
                tsl.tupleSetChanged(this, added, removed);
                ++i;
            }
        }
    }

    @Override
    public boolean isAddColumnSupported() {
        return false;
    }

    @Override
    public void addColumns(Schema schema) {
        if (this.isAddColumnSupported()) {
            int i = 0;
            while (i < schema.getColumnCount()) {
                try {
                    this.addColumn(schema.getColumnName(i), schema.getColumnType(i), schema.getDefault(i));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                ++i;
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void addColumn(String name, Class<?> type, Object defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addColumn(String name, Class<?> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addColumn(String name, Expression expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addColumn(String name, String expr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener lstnr) {
        if (lstnr == null) {
            return;
        }
        if (this.m_propSupport == null) {
            this.m_propSupport = new SwingPropertyChangeSupport(this);
        }
        this.m_propSupport.addPropertyChangeListener(lstnr);
    }

    @Override
    public void addPropertyChangeListener(String key, PropertyChangeListener lstnr) {
        if (lstnr == null) {
            return;
        }
        if (this.m_propSupport == null) {
            this.m_propSupport = new SwingPropertyChangeSupport(this);
        }
        this.m_propSupport.addPropertyChangeListener(key, lstnr);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener lstnr) {
        if (lstnr == null) {
            return;
        }
        if (this.m_propSupport == null) {
            return;
        }
        this.m_propSupport.removePropertyChangeListener(lstnr);
    }

    @Override
    public void removePropertyChangeListener(String key, PropertyChangeListener lstnr) {
        if (lstnr == null) {
            return;
        }
        if (this.m_propSupport == null) {
            return;
        }
        this.m_propSupport.removePropertyChangeListener(key, lstnr);
    }

    @Override
    public void putClientProperty(String key, Object value) {
        Object prev = null;
        if (this.m_props == null && value == null) {
            return;
        }
        if (value == null) {
            prev = this.m_props.remove(key);
        } else {
            if (this.m_props == null) {
                this.m_props = new HashMap(2);
            }
            prev = this.m_props.put(key, value);
        }
        if (this.m_propSupport != null) {
            this.m_propSupport.firePropertyChange(key, prev, value);
        }
    }

    @Override
    public Object getClientProperty(String key) {
        return this.m_props == null ? null : this.m_props.get(key);
    }
}

