/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.tuple;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.expression.Expression;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.data.tuple.AbstractTupleSet;
import prefuse.data.tuple.TupleSet;
import prefuse.util.collections.CompositeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeTupleSet
extends AbstractTupleSet {
    private static final Logger s_logger = Logger.getLogger(CompositeTupleSet.class.getName());
    private Map<String, TupleSet> m_map = new LinkedHashMap<String, TupleSet>();
    private Set<TupleSet> m_sets = new HashSet<TupleSet>();
    private int m_count = 0;
    private Listener m_lstnr;

    public CompositeTupleSet() {
        this(true);
    }

    protected CompositeTupleSet(boolean listen) {
        this.m_lstnr = listen ? new Listener() : null;
    }

    public void addSet(String name, TupleSet set) {
        if (this.hasSet(name)) {
            throw new IllegalArgumentException("Name already in use: " + name);
        }
        this.m_map.put(name, set);
        this.m_sets.add(set);
        this.m_count += set.getTupleCount();
        if (this.m_lstnr != null) {
            set.addTupleSetListener(this.m_lstnr);
        }
    }

    public boolean hasSet(String name) {
        return this.m_map.containsKey(name);
    }

    public boolean containsSet(TupleSet set) {
        return this.m_sets.contains(set);
    }

    public TupleSet getSet(String name) {
        return this.m_map.get(name);
    }

    public Iterator<String> setNames() {
        return this.m_map.keySet().iterator();
    }

    public Iterator<TupleSet> sets() {
        return this.m_map.values().iterator();
    }

    public TupleSet removeSet(String name) {
        TupleSet ts = this.m_map.remove(name);
        if (ts != null) {
            this.m_sets.remove(ts);
            if (this.m_lstnr != null) {
                ts.removeTupleSetListener(this.m_lstnr);
            }
        }
        return ts;
    }

    public void removeAllSets() {
        Iterator<Map.Entry<String, TupleSet>> sets = this.m_map.entrySet().iterator();
        while (sets.hasNext()) {
            Map.Entry<String, TupleSet> entry = sets.next();
            TupleSet ts = entry.getValue();
            sets.remove();
            this.m_sets.remove(ts);
            if (this.m_lstnr == null) continue;
            ts.removeTupleSetListener(this.m_lstnr);
        }
        this.m_count = 0;
    }

    @Override
    public void clear() {
        for (Map.Entry<String, TupleSet> entry : this.m_map.entrySet()) {
            entry.getValue().clear();
        }
        this.m_count = 0;
    }

    @Override
    public Tuple addTuple(Tuple t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Tuple setTuple(Tuple t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeTuple(Tuple t) {
        Table table = t.getTable();
        if (this.m_sets.contains(table)) {
            return table.removeTuple(t);
        }
        return false;
    }

    @Override
    public boolean containsTuple(Tuple t) {
        for (Map.Entry<String, TupleSet> entry : this.m_map.entrySet()) {
            TupleSet ts = entry.getValue();
            if (!ts.containsTuple(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getTupleCount() {
        if (this.m_lstnr != null) {
            return this.m_count;
        }
        int count = 0;
        Iterator<Map.Entry<String, TupleSet>> it = this.m_map.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry<String, TupleSet> entry = it.next();
            TupleSet ts = entry.getValue();
            count += ts.getTupleCount();
            ++i;
        }
        return count;
    }

    public Iterator tuples() {
        CompositeIterator<? extends Tuple> ci = new CompositeIterator<Tuple>(this.m_map.size());
        Iterator<Map.Entry<String, TupleSet>> it = this.m_map.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry<String, TupleSet> entry = it.next();
            TupleSet ts = entry.getValue();
            ci.setIterator(i, ts.tuples());
            ++i;
        }
        return ci;
    }

    public Iterator tuples(Predicate filter) {
        CompositeIterator<? extends Tuple> ci = new CompositeIterator<Tuple>(this.m_map.size());
        Iterator<Map.Entry<String, TupleSet>> it = this.m_map.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry<String, TupleSet> entry = it.next();
            TupleSet ts = entry.getValue();
            ci.setIterator(i, ts.tuples(filter));
            ++i;
        }
        return ci;
    }

    @Override
    public boolean isAddColumnSupported() {
        return true;
    }

    @Override
    public void addColumn(String name, Class<?> type, Object defaultValue) {
        for (Map.Entry<String, TupleSet> entry : this.m_map.entrySet()) {
            TupleSet ts = entry.getValue();
            if (ts.isAddColumnSupported()) {
                try {
                    ts.addColumn(name, type, defaultValue);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            s_logger.fine("Skipped addColumn for " + entry.getKey());
        }
    }

    @Override
    public void addColumn(String name, Class<?> type) {
        for (Map.Entry<String, TupleSet> entry : this.m_map.entrySet()) {
            TupleSet ts = entry.getValue();
            if (ts.isAddColumnSupported()) {
                try {
                    ts.addColumn(name, type);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            s_logger.fine("Skipped addColumn for " + entry.getKey());
        }
    }

    @Override
    public void addColumn(String name, Expression expr) {
        for (Map.Entry<String, TupleSet> entry : this.m_map.entrySet()) {
            TupleSet ts = entry.getValue();
            if (ts.isAddColumnSupported()) {
                try {
                    ts.addColumn(name, expr);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            s_logger.fine("Skipped addColumn for " + entry.getKey());
        }
    }

    @Override
    public void addColumn(String name, String expr) {
        Expression ex = ExpressionParser.parse(expr);
        Throwable t = ExpressionParser.getError();
        if (t != null) {
            throw new RuntimeException(t);
        }
        this.addColumn(name, ex);
    }

    private class Listener
    implements TupleSetListener {
        private Listener() {
        }

        public void tupleSetChanged(TupleSet tset, Tuple[] add, Tuple[] rem) {
            CompositeTupleSet compositeTupleSet = CompositeTupleSet.this;
            compositeTupleSet.m_count = compositeTupleSet.m_count + (add.length - rem.length);
            CompositeTupleSet.this.fireTupleEvent(add, rem);
        }
    }
}

