/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.tuple;

import java.util.Date;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableTuple
implements Tuple {
    protected Table m_table;
    protected int m_row;

    protected void init(Table table, Graph graph, int row) {
        this.m_table = table;
        this.m_row = this.m_table.isValidRow(row) ? row : -1;
    }

    @Override
    public Schema getSchema() {
        return this.m_table.getSchema();
    }

    @Override
    public Table getTable() {
        return this.m_table;
    }

    @Override
    public int getRow() {
        return this.m_row;
    }

    @Override
    public boolean isValid() {
        return this.m_row != -1;
    }

    void invalidate() {
        this.m_row = -1;
    }

    private void validityCheck() {
        if (this.m_row == -1) {
            throw new IllegalStateException("This tuple is no longer valid. It has been deleted from its table");
        }
    }

    @Override
    public Class<?> getColumnType(String field) {
        return this.m_table.getColumnType(field);
    }

    @Override
    public Class<?> getColumnType(int col) {
        return this.m_table.getColumnType(col);
    }

    @Override
    public int getColumnIndex(String field) {
        return this.m_table.getColumnNumber(field);
    }

    @Override
    public int getColumnCount() {
        return this.m_table.getColumnCount();
    }

    @Override
    public String getColumnName(int col) {
        return this.m_table.getColumnName(col);
    }

    @Override
    public boolean canGet(String field, Class<?> type) {
        return this.m_table.canGet(field, type);
    }

    @Override
    public boolean canSet(String field, Class<?> type) {
        return this.m_table.canSet(field, type);
    }

    @Override
    public final Object get(String field) {
        this.validityCheck();
        return this.m_table.get(this.m_row, field);
    }

    @Override
    public final void set(String field, Object value) {
        this.validityCheck();
        this.m_table.set(this.m_row, field, value);
    }

    @Override
    public final Object get(int idx) {
        this.validityCheck();
        return this.m_table.get(this.m_row, idx);
    }

    @Override
    public final void set(int idx, Object value) {
        this.validityCheck();
        this.m_table.set(this.m_row, idx, value);
    }

    @Override
    public Object getDefault(String field) {
        this.validityCheck();
        return this.m_table.getDefault(field);
    }

    @Override
    public void revertToDefault(String field) {
        this.validityCheck();
        this.m_table.revertToDefault(this.m_row, field);
    }

    @Override
    public final boolean canGetInt(String field) {
        return this.m_table.canGetInt(field);
    }

    @Override
    public final boolean canSetInt(String field) {
        return this.m_table.canSetInt(field);
    }

    @Override
    public final int getInt(String field) {
        this.validityCheck();
        return this.m_table.getInt(this.m_row, field);
    }

    @Override
    public final void setInt(String field, int val) {
        this.validityCheck();
        this.m_table.setInt(this.m_row, field, val);
    }

    @Override
    public final int getInt(int col) {
        this.validityCheck();
        return this.m_table.getInt(this.m_row, col);
    }

    @Override
    public final void setInt(int col, int val) {
        this.validityCheck();
        this.m_table.setInt(this.m_row, col, val);
    }

    @Override
    public final boolean canGetLong(String field) {
        return this.m_table.canGetLong(field);
    }

    @Override
    public final boolean canSetLong(String field) {
        return this.m_table.canSetLong(field);
    }

    @Override
    public final long getLong(String field) {
        this.validityCheck();
        return this.m_table.getLong(this.m_row, field);
    }

    @Override
    public final void setLong(String field, long val) {
        this.validityCheck();
        this.m_table.setLong(this.m_row, field, val);
    }

    @Override
    public final long getLong(int col) {
        this.validityCheck();
        return this.m_table.getLong(this.m_row, col);
    }

    @Override
    public final void setLong(int col, long val) {
        this.validityCheck();
        this.m_table.setLong(this.m_row, col, val);
    }

    @Override
    public final boolean canGetFloat(String field) {
        return this.m_table.canGetFloat(field);
    }

    @Override
    public final boolean canSetFloat(String field) {
        return this.m_table.canSetFloat(field);
    }

    @Override
    public final float getFloat(String field) {
        this.validityCheck();
        return this.m_table.getFloat(this.m_row, field);
    }

    @Override
    public final void setFloat(String field, float val) {
        this.validityCheck();
        this.m_table.setFloat(this.m_row, field, val);
    }

    @Override
    public final float getFloat(int col) {
        this.validityCheck();
        return this.m_table.getFloat(this.m_row, col);
    }

    @Override
    public final void setFloat(int col, float val) {
        this.validityCheck();
        this.m_table.setFloat(this.m_row, col, val);
    }

    @Override
    public final boolean canGetDouble(String field) {
        return this.m_table.canGetDouble(field);
    }

    @Override
    public final boolean canSetDouble(String field) {
        return this.m_table.canSetDouble(field);
    }

    @Override
    public final double getDouble(String field) {
        this.validityCheck();
        return this.m_table.getDouble(this.m_row, field);
    }

    @Override
    public final void setDouble(String field, double val) {
        this.validityCheck();
        this.m_table.setDouble(this.m_row, field, val);
    }

    @Override
    public final double getDouble(int col) {
        this.validityCheck();
        return this.m_table.getDouble(this.m_row, col);
    }

    @Override
    public final void setDouble(int col, double val) {
        this.validityCheck();
        this.m_table.setDouble(this.m_row, col, val);
    }

    @Override
    public final boolean canGetBoolean(String field) {
        return this.m_table.canGetBoolean(field);
    }

    @Override
    public final boolean canSetBoolean(String field) {
        return this.m_table.canSetBoolean(field);
    }

    @Override
    public final boolean getBoolean(String field) {
        this.validityCheck();
        return this.m_table.getBoolean(this.m_row, field);
    }

    @Override
    public final void setBoolean(String field, boolean val) {
        this.validityCheck();
        this.m_table.setBoolean(this.m_row, field, val);
    }

    @Override
    public final boolean getBoolean(int col) {
        this.validityCheck();
        return this.m_table.getBoolean(this.m_row, col);
    }

    @Override
    public final void setBoolean(int col, boolean val) {
        this.validityCheck();
        this.m_table.setBoolean(this.m_row, col, val);
    }

    @Override
    public final boolean canGetString(String field) {
        return this.m_table.canGetString(field);
    }

    @Override
    public final boolean canSetString(String field) {
        return this.m_table.canSetString(field);
    }

    @Override
    public final String getString(String field) {
        this.validityCheck();
        return this.m_table.getString(this.m_row, field);
    }

    @Override
    public final void setString(String field, String val) {
        this.validityCheck();
        this.m_table.setString(this.m_row, field, val);
    }

    @Override
    public final String getString(int col) {
        this.validityCheck();
        return this.m_table.getString(this.m_row, col);
    }

    @Override
    public final void setString(int col, String val) {
        this.validityCheck();
        this.m_table.setString(this.m_row, col, val);
    }

    @Override
    public final boolean canGetDate(String field) {
        return this.m_table.canGetDate(field);
    }

    @Override
    public final boolean canSetDate(String field) {
        return this.m_table.canSetDate(field);
    }

    @Override
    public final Date getDate(String field) {
        this.validityCheck();
        return this.m_table.getDate(this.m_row, field);
    }

    @Override
    public final void setDate(String field, Date val) {
        this.validityCheck();
        this.m_table.setDate(this.m_row, field, val);
    }

    @Override
    public final Date getDate(int col) {
        this.validityCheck();
        return this.m_table.getDate(this.m_row, col);
    }

    @Override
    public final void setDate(int col, Date val) {
        this.validityCheck();
        this.m_table.setDate(this.m_row, col, val);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Tuple[");
        int i = 0;
        while (i < this.getColumnCount()) {
            if (i > 0) {
                sb.append(',');
            }
            try {
                sb.append(this.get(i).toString());
            }
            catch (Exception e) {
                sb.append("?");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }
}

