/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import prefuse.data.Tuple;
import prefuse.data.expression.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterIterator
implements Iterator<Tuple> {
    private Predicate predicate;
    private Iterator<? extends Tuple> tuples;
    private Tuple next;

    public FilterIterator(Iterator<? extends Tuple> tuples, Predicate p) {
        this.predicate = p;
        this.tuples = tuples;
        this.next = this.advance();
    }

    private Tuple advance() {
        while (this.tuples.hasNext()) {
            Tuple t = this.tuples.next();
            if (!this.predicate.getBoolean(t)) continue;
            return t;
        }
        this.tuples = null;
        this.next = null;
        return null;
    }

    @Override
    public Tuple next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements");
        }
        Tuple retval = this.next;
        this.next = this.advance();
        return retval;
    }

    @Override
    public boolean hasNext() {
        return this.tuples != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

