/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeLib {
    private TypeLib() {
    }

    public static boolean typeCheck(Class<?> type, Object instance) {
        return type.isAssignableFrom(instance.getClass()) || TypeLib.isWrapperInstance(type, instance);
    }

    public static Class<?> getSharedType(Object o1, Object o2) {
        return TypeLib.getSharedType(o1.getClass(), o2.getClass());
    }

    public static Class<?> getSharedType(Class<?> type1, Class<?> type2) {
        if (type1 == type2) {
            return type1;
        }
        if (type1.isAssignableFrom(type2)) {
            return type1;
        }
        if (type2.isAssignableFrom(type1)) {
            return type2;
        }
        return null;
    }

    public static boolean isWrapperInstance(Class<?> type, Object instance) {
        if (!type.isPrimitive()) {
            throw new IllegalArgumentException("Input type must be a primitive");
        }
        if (Integer.TYPE == type && instance instanceof Integer) {
            return true;
        }
        if (Long.TYPE == type && instance instanceof Long) {
            return true;
        }
        if (Float.TYPE == type && instance instanceof Float) {
            return true;
        }
        if (Double.TYPE == type && instance instanceof Double) {
            return true;
        }
        if (Boolean.TYPE == type && instance instanceof Boolean) {
            return true;
        }
        if (Short.TYPE == type && instance instanceof Short) {
            return true;
        }
        if (Byte.TYPE == type && instance instanceof Byte) {
            return true;
        }
        return Character.TYPE == type && instance instanceof Character;
    }

    public static Class<?> getPrimitiveType(Class<?> type) {
        if (Integer.class.equals(type) || type == Integer.TYPE) {
            return Integer.TYPE;
        }
        if (Long.class.equals(type) || type == Long.TYPE) {
            return Long.TYPE;
        }
        if (Float.class.equals(type) || type == Float.TYPE) {
            return Float.TYPE;
        }
        if (Double.class.equals(type) || type == Double.TYPE) {
            return Double.TYPE;
        }
        if (Byte.class.equals(type) || type == Byte.TYPE) {
            return Byte.TYPE;
        }
        if (Short.class.equals(type) || type == Short.TYPE) {
            return Short.TYPE;
        }
        throw new IllegalArgumentException("Input class must be a numeric type");
    }

    public static Class<?> getWrapperType(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (Integer.TYPE == type) {
            return Integer.class;
        }
        if (Long.TYPE == type) {
            return Long.class;
        }
        if (Float.TYPE == type) {
            return Float.class;
        }
        if (Double.TYPE == type) {
            return Double.class;
        }
        if (Boolean.TYPE == type) {
            return Boolean.class;
        }
        if (Short.TYPE == type) {
            return Short.class;
        }
        if (Character.TYPE == type) {
            return Character.class;
        }
        if (Byte.TYPE == type) {
            return Byte.class;
        }
        if (Short.TYPE == type) {
            return Short.class;
        }
        throw new IllegalArgumentException();
    }

    public static boolean isIntegerType(Class<?> type) {
        return type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE;
    }

    public static boolean isNumericType(Class<?> type) {
        return type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Double.TYPE || type == Float.TYPE;
    }

    public static Class<?> getNumericType(Class<?> c1, Class<?> c2) {
        if (!TypeLib.isNumericType(c1) || !TypeLib.isNumericType(c2)) {
            throw new IllegalArgumentException("Input types must be primitive number types");
        }
        if (c1 == Double.TYPE || c2 == Double.TYPE) {
            return Double.TYPE;
        }
        if (c1 == Float.TYPE || c1 == Float.TYPE) {
            return Float.TYPE;
        }
        if (c1 == Long.TYPE || c2 == Long.TYPE) {
            return Long.TYPE;
        }
        return Integer.TYPE;
    }
}

