/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeIterator<E>
implements Iterator<E> {
    private Iterator<E>[] m_iters;
    private int m_cur;

    public CompositeIterator(int size) {
        this.m_iters = new Iterator[size];
    }

    public CompositeIterator(Iterator<E> iter1, Iterator<E> iter2) {
        this(new Iterator[]{iter1, iter2});
    }

    public CompositeIterator(Iterator<E>[] iters) {
        this.m_iters = iters;
        this.m_cur = 0;
    }

    public void setIterator(int idx, Iterator<E> iter) {
        this.m_iters[idx] = iter;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E next() {
        if (this.hasNext()) {
            return this.m_iters[this.m_cur].next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasNext() {
        if (this.m_iters == null) {
            return false;
        }
        while (true) {
            if (this.m_cur >= this.m_iters.length) {
                this.m_iters = null;
                return false;
            }
            if (this.m_iters[this.m_cur] == null) {
                ++this.m_cur;
                continue;
            }
            if (this.m_iters[this.m_cur].hasNext()) {
                return true;
            }
            ++this.m_cur;
        }
    }
}

