/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import prefuse.util.force.Force;
import prefuse.util.force.ForceSimulator;
import prefuse.util.ui.JValueSlider;

public class JForcePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ForcePanelChangeListener lstnr = new ForcePanelChangeListener();
    private ForceSimulator fsim;

    public JForcePanel(ForceSimulator fsim) {
        this.fsim = fsim;
        this.setBackground(Color.WHITE);
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BoxLayout(this, 1));
        Force[] forces = this.fsim.getForces();
        int i = 0;
        while (i < forces.length) {
            Force f = forces[i];
            Box v = new Box(1);
            int j = 0;
            while (j < f.getParameterCount()) {
                JValueSlider field = JForcePanel.createField(f, j);
                field.addChangeListener(this.lstnr);
                v.add(field);
                ++j;
            }
            String name = f.getClass().getName();
            name = name.substring(name.lastIndexOf(".") + 1);
            v.setBorder(BorderFactory.createTitledBorder(name));
            this.add(v);
            ++i;
        }
    }

    private static JValueSlider createField(Force f, int param) {
        double value = f.getParameter(param);
        double min = f.getMinValue(param);
        double max = f.getMaxValue(param);
        String name = f.getParameterName(param);
        JValueSlider s = new JValueSlider(name, min, max, value);
        s.setBackground(Color.WHITE);
        s.putClientProperty("force", f);
        s.putClientProperty("param", new Integer(param));
        s.setPreferredSize(new Dimension(300, 30));
        s.setMaximumSize(new Dimension(300, 30));
        return s;
    }

    public static JFrame showForcePanel(ForceSimulator fsim) {
        JFrame frame = new JFrame("prefuse Force Simulator");
        frame.setContentPane(new JForcePanel(fsim));
        frame.pack();
        frame.setVisible(true);
        return frame;
    }

    private static class ForcePanelChangeListener
    implements ChangeListener {
        private ForcePanelChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            JValueSlider s = (JValueSlider)e.getSource();
            float val = s.getValue().floatValue();
            Force f = (Force)s.getClientProperty("force");
            Integer p = (Integer)s.getClientProperty("param");
            f.setParameter(p, val);
        }
    }
}

