/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Tree;
import prefuse.data.event.GraphListener;
import prefuse.util.StringLib;
import prefuse.visual.VisualTree;

public class JPrefuseTree
extends JTree {
    private static final long serialVersionUID = 1L;
    private Tree m_tree;
    private String m_field;

    public JPrefuseTree(Tree t, String labelField) {
        this.m_tree = t;
        this.m_field = labelField;
        PrefuseTreeModel model = new PrefuseTreeModel();
        super.setModel(model);
        this.m_tree.addGraphModelListener(model);
    }

    public Tree getTree() {
        return this.m_tree;
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value == null) {
            return "";
        }
        if (value instanceof Node) {
            Object o = ((Node)value).get(this.m_field);
            if (o.getClass().isArray()) {
                return StringLib.getArrayString(o);
            }
            return o.toString();
        }
        return value.toString();
    }

    public static JFrame showTreeWindow(Tree t, String labelField) {
        JPrefuseTree tree = new JPrefuseTree(t, labelField);
        String title = t.toString();
        if (t instanceof VisualTree) {
            title = String.valueOf(((VisualTree)t).getGroup()) + " " + title;
        }
        JFrame frame = new JFrame(title);
        frame.getContentPane().add(new JScrollPane(tree));
        frame.pack();
        frame.setVisible(true);
        return frame;
    }

    public class PrefuseTreeModel
    implements TreeModel,
    GraphListener {
        private CopyOnWriteArrayList m_listeners = new CopyOnWriteArrayList();

        public Object getRoot() {
            return JPrefuseTree.this.m_tree.getRoot();
        }

        public Object getChild(Object node, int idx) {
            Node c = ((Node)node).getChild(idx);
            if (c == null) {
                throw new IllegalArgumentException("Index out of range: " + idx);
            }
            return c;
        }

        public int getChildCount(Object node) {
            return ((Node)node).getChildCount();
        }

        public boolean isLeaf(Object node) {
            return ((Node)node).getChildCount() == 0;
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        public int getIndexOfChild(Object parent, Object child) {
            return ((Node)parent).getChildIndex((Node)child);
        }

        public void addTreeModelListener(TreeModelListener tml) {
            if (!this.m_listeners.contains(tml)) {
                this.m_listeners.add(tml);
            }
        }

        public void removeTreeModelListener(TreeModelListener tml) {
            this.m_listeners.remove(tml);
        }

        public void graphChanged(Graph g, String table, int start, int end, int col, int type) {
            if (this.m_listeners == null || this.m_listeners.size() == 0) {
                return;
            }
            boolean nodeTable = table.equals(Graph.NODES);
            if (type != 0 && nodeTable) {
                return;
            }
            if (type == 0 && !nodeTable) {
                return;
            }
            int row = start;
            while (row <= end) {
                Node n = null;
                n = nodeTable ? g.getNode(row) : g.getEdge(row).getTargetNode();
                Object[] path = new Object[n.getDepth() + 1];
                int i = path.length;
                while (--i >= 0) {
                    path[i] = n;
                    n = n.getParent();
                }
                TreeModelEvent e = new TreeModelEvent((Object)this, path);
                Object[] lstnrs = this.m_listeners.toArray();
                int i2 = 0;
                while (i2 < lstnrs.length) {
                    TreeModelListener tml = (TreeModelListener)lstnrs[i2];
                    switch (type) {
                        case 1: {
                            tml.treeNodesInserted(e);
                            break;
                        }
                        case -1: {
                            tml.treeNodesRemoved(e);
                            break;
                        }
                        case 0: {
                            tml.treeNodesChanged(e);
                        }
                    }
                    ++i2;
                }
                ++row;
            }
        }
    }
}

