/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JRangeSlider
extends JComponent
implements MouseListener,
MouseMotionListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final int LEFTRIGHT_TOPBOTTOM = 0;
    public static final int RIGHTLEFT_BOTTOMTOP = 1;
    public static final int PREFERRED_BREADTH = 16;
    public static final int PREFERRED_LENGTH = 300;
    protected static final int ARROW_SZ = 16;
    protected static final int ARROW_WIDTH = 8;
    protected static final int ARROW_HEIGHT = 4;
    protected BoundedRangeModel model;
    protected int orientation;
    protected int direction;
    protected boolean empty;
    protected int increment = 1;
    protected int minExtent = 0;
    protected ArrayList listeners = new ArrayList();
    protected ChangeEvent changeEvent = null;
    protected ChangeListener lstnr;
    protected Color thumbColor = new Color(150, 180, 220);
    static final int PICK_NONE = 0;
    static final int PICK_LEFT_OR_TOP = 1;
    static final int PICK_THUMB = 2;
    static final int PICK_RIGHT_OR_BOTTOM = 3;
    int pick;
    int pickOffsetLow;
    int pickOffsetHigh;
    int mouse;

    public JRangeSlider(int minimum, int maximum, int lowValue, int highValue, int orientation) {
        this(new DefaultBoundedRangeModel(lowValue, highValue - lowValue, minimum, maximum), orientation, 0);
    }

    public JRangeSlider(int minimum, int maximum, int lowValue, int highValue, int orientation, int direction) {
        this(new DefaultBoundedRangeModel(lowValue, highValue - lowValue, minimum, maximum), orientation, direction);
    }

    public JRangeSlider(BoundedRangeModel model, int orientation, int direction) {
        super.setFocusable(true);
        this.model = model;
        this.orientation = orientation;
        this.direction = direction;
        this.setForeground(Color.LIGHT_GRAY);
        this.lstnr = this.createListener();
        model.addChangeListener(this.lstnr);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    protected ChangeListener createListener() {
        return new RangeSliderChangeListener();
    }

    public int getLowValue() {
        return this.model.getValue();
    }

    public void setLowValue(int lowValue) {
        int e = this.model.getValue() - lowValue + this.model.getExtent();
        this.model.setRangeProperties(lowValue, e, this.model.getMinimum(), this.model.getMaximum(), false);
        this.model.setValue(lowValue);
    }

    public int getHighValue() {
        return this.model.getValue() + this.model.getExtent();
    }

    public void setHighValue(int highValue) {
        this.model.setExtent(highValue - this.model.getValue());
    }

    public void setRange(int lowValue, int highValue) {
        this.model.setRangeProperties(lowValue, highValue - lowValue, this.model.getMinimum(), this.model.getMaximum(), false);
    }

    public int getMinimum() {
        return this.model.getMinimum();
    }

    public void setMinimum(int minimum) {
        this.model.setMinimum(minimum);
    }

    public int getMaximum() {
        return this.model.getMaximum();
    }

    public void setMaximum(int maximum) {
        this.model.setMaximum(maximum);
    }

    public void setMinExtent(int minExtent) {
        this.minExtent = minExtent;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
        this.repaint();
    }

    public Color getThumbColor() {
        return this.thumbColor;
    }

    public void setThumbColor(Color thumbColor) {
        this.thumbColor = thumbColor;
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public void setModel(BoundedRangeModel brm) {
        this.model.removeChangeListener(this.lstnr);
        this.model = brm;
        this.model.addChangeListener(this.lstnr);
        this.repaint();
    }

    public void addChangeListener(ChangeListener cl) {
        if (!this.listeners.contains(cl)) {
            this.listeners.add(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        this.listeners.remove(cl);
    }

    protected void fireChangeEvent() {
        this.repaint();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ChangeListener)iter.next()).stateChanged(this.changeEvent);
        }
    }

    public Dimension getPreferredSize() {
        if (this.orientation == 0) {
            return new Dimension(16, 300);
        }
        return new Dimension(300, 16);
    }

    protected void customPaint(Graphics2D g, int width, int height) {
    }

    public void paintComponent(Graphics g) {
        Rectangle bounds = this.getBounds();
        int width = (int)bounds.getWidth() - 1;
        int height = (int)bounds.getHeight() - 1;
        int min = this.toScreen(this.getLowValue());
        int max = this.toScreen(this.getHighValue());
        if (this.empty) {
            if (this.direction == 0) {
                min = 16;
                max = this.orientation == 0 ? height - 16 : width - 16;
            } else {
                min = this.orientation == 0 ? height - 16 : width - 16;
                max = 16;
            }
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, width, height);
        g2.setColor(this.getForeground());
        g2.drawRect(0, 0, width, height);
        this.customPaint(g2, width, height);
        g2.setStroke(new BasicStroke(1.0f));
        if (this.orientation == 0) {
            if (this.direction == 0) {
                g2.setColor(this.getForeground());
                g2.fillRect(0, min - 16, width, 15);
                this.paint3DRectLighting(g2, 0, min - 16, width, 15);
                if (this.thumbColor != null) {
                    g2.setColor(this.thumbColor);
                    g2.fillRect(0, min, width, max - min - 1);
                    this.paint3DRectLighting(g2, 0, min, width, max - min - 1);
                }
                g2.setColor(this.getForeground());
                g2.fillRect(0, max, width, 15);
                this.paint3DRectLighting(g2, 0, max, width, 15);
                g2.setColor(Color.black);
                this.paintArrow(g2, (double)(width - 8) / 2.0, (double)(min - 16) + 6.0, 8, 4, true);
                this.paintArrow(g2, (double)(width - 8) / 2.0, (double)max + 6.0, 8, 4, false);
            } else {
                g2.setColor(this.getForeground());
                g2.fillRect(0, min, width, 15);
                this.paint3DRectLighting(g2, 0, min, width, 15);
                if (this.thumbColor != null) {
                    g2.setColor(this.thumbColor);
                    g2.fillRect(0, max, width, min - max - 1);
                    this.paint3DRectLighting(g2, 0, max, width, min - max - 1);
                }
                g2.setColor(this.getForeground());
                g2.fillRect(0, max - 16, width, 15);
                this.paint3DRectLighting(g2, 0, max - 16, width, 15);
                g2.setColor(Color.black);
                this.paintArrow(g2, (double)(width - 8) / 2.0, (double)min + 6.0, 8, 4, false);
                this.paintArrow(g2, (double)(width - 8) / 2.0, (double)(max - 16) + 6.0, 8, 4, true);
            }
        } else if (this.direction == 0) {
            g2.setColor(this.getForeground());
            g2.fillRect(min - 16, 0, 15, height);
            this.paint3DRectLighting(g2, min - 16, 0, 15, height);
            if (this.thumbColor != null) {
                g2.setColor(this.thumbColor);
                g2.fillRect(min, 0, max - min - 1, height);
                this.paint3DRectLighting(g2, min, 0, max - min - 1, height);
            }
            g2.setColor(this.getForeground());
            g2.fillRect(max, 0, 15, height);
            this.paint3DRectLighting(g2, max, 0, 15, height);
            g2.setColor(Color.black);
            this.paintArrow(g2, (double)(min - 16) + 6.0, (double)(height - 8) / 2.0, 4, 8, true);
            this.paintArrow(g2, (double)max + 6.0, (double)(height - 8) / 2.0, 4, 8, false);
        } else {
            g2.setColor(this.getForeground());
            g2.fillRect(min, 0, 15, height);
            this.paint3DRectLighting(g2, min, 0, 15, height);
            if (this.thumbColor != null) {
                g2.setColor(this.thumbColor);
                g2.fillRect(max, 0, min - max - 1, height);
                this.paint3DRectLighting(g2, max, 0, min - max - 1, height);
            }
            g2.setColor(this.getForeground());
            g2.fillRect(max - 16, 0, 15, height);
            this.paint3DRectLighting(g2, max - 16, 0, 15, height);
            g2.setColor(Color.black);
            this.paintArrow(g2, (double)min + 6.0, (double)(height - 8) / 2.0, 4, 8, true);
            this.paintArrow(g2, (double)(max - 16) + 6.0, (double)(height - 8) / 2.0, 4, 8, false);
        }
    }

    protected void paintArrow(Graphics2D g2, double x, double y, int w, int h, boolean topDown) {
        int intX = (int)(x + 0.5);
        int intY = (int)(y + 0.5);
        if (this.orientation == 0) {
            if (w % 2 == 0) {
                --w;
            }
            if (topDown) {
                int i = 0;
                while (i < w / 2 + 1) {
                    g2.drawLine(intX + i, intY + i, intX + w - i - 1, intY + i);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < w / 2 + 1) {
                    g2.drawLine(intX + w / 2 - i, intY + i, intX + w - w / 2 + i - 1, intY + i);
                    ++i;
                }
            }
        } else {
            if (h % 2 == 0) {
                --h;
            }
            if (topDown) {
                int i = 0;
                while (i < h / 2 + 1) {
                    g2.drawLine(intX + i, intY + i, intX + i, intY + h - i - 1);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < h / 2 + 1) {
                    g2.drawLine(intX + i, intY + h / 2 - i, intX + i, intY + h - h / 2 + i - 1);
                    ++i;
                }
            }
        }
    }

    protected void paint3DRectLighting(Graphics2D g2, int x, int y, int width, int height) {
        g2.setColor(Color.white);
        g2.drawLine(x + 1, y + 1, x + 1, y + height - 1);
        g2.drawLine(x + 1, y + 1, x + width - 1, y + 1);
        g2.setColor(Color.gray);
        g2.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
        g2.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 1);
        g2.setColor(Color.darkGray);
        g2.drawLine(x, y + height, x + width, y + height);
        g2.drawLine(x + width, y, x + width, y + height);
    }

    protected int toLocal(int xOrY) {
        Dimension sz = this.getSize();
        int min = this.getMinimum();
        double scale = this.orientation == 0 ? (double)(sz.height - 32) / (double)(this.getMaximum() - min) : (double)(sz.width - 32) / (double)(this.getMaximum() - min);
        if (this.direction == 0) {
            return (int)((double)(xOrY - 16) / scale + (double)min + 0.5);
        }
        if (this.orientation == 0) {
            return (int)((double)(sz.height - xOrY - 16) / scale + (double)min + 0.5);
        }
        return (int)((double)(sz.width - xOrY - 16) / scale + (double)min + 0.5);
    }

    protected int toScreen(int xOrY) {
        Dimension sz = this.getSize();
        int min = this.getMinimum();
        double scale = this.orientation == 0 ? (double)(sz.height - 32) / (double)(this.getMaximum() - min) : (double)(sz.width - 32) / (double)(this.getMaximum() - min);
        if (this.direction == 0) {
            return (int)(16.0 + (double)(xOrY - min) * scale + 0.5);
        }
        if (this.orientation == 0) {
            return (int)((double)sz.height - (double)(xOrY - min) * scale - 16.0 + 0.5);
        }
        return (int)((double)sz.width - (double)(xOrY - min) * scale - 16.0 + 0.5);
    }

    protected double toScreenDouble(int xOrY) {
        Dimension sz = this.getSize();
        int min = this.getMinimum();
        double scale = this.orientation == 0 ? (double)(sz.height - 32) / (double)(this.getMaximum() + 1 - min) : (double)(sz.width - 32) / (double)(this.getMaximum() + 1 - min);
        if (this.direction == 0) {
            return 16.0 + (double)(xOrY - min) * scale;
        }
        if (this.orientation == 0) {
            return (double)sz.height - (double)(xOrY - min) * scale - 16.0;
        }
        return (double)sz.width - (double)(xOrY - min) * scale - 16.0;
    }

    private int pickHandle(int xOrY) {
        int min = this.toScreen(this.getLowValue());
        int max = this.toScreen(this.getHighValue());
        int pick = 0;
        if (this.direction == 0) {
            if (xOrY > min - 16 && xOrY < min) {
                pick = 1;
            } else if (xOrY >= min && xOrY <= max) {
                pick = 2;
            } else if (xOrY > max && xOrY < max + 16) {
                pick = 3;
            }
        } else if (xOrY > min && xOrY < min + 16) {
            pick = 1;
        } else if (xOrY <= min && xOrY >= max) {
            pick = 2;
        } else if (xOrY > max - 16 && xOrY < max) {
            pick = 3;
        }
        return pick;
    }

    private void offset(int dxOrDy) {
        this.model.setValue(this.model.getValue() + dxOrDy);
    }

    public void mousePressed(MouseEvent e) {
        if (this.orientation == 0) {
            this.pick = this.pickHandle(e.getY());
            this.pickOffsetLow = e.getY() - this.toScreen(this.getLowValue());
            this.pickOffsetHigh = e.getY() - this.toScreen(this.getHighValue());
            this.mouse = e.getY();
        } else {
            this.pick = this.pickHandle(e.getX());
            this.pickOffsetLow = e.getX() - this.toScreen(this.getLowValue());
            this.pickOffsetHigh = e.getX() - this.toScreen(this.getHighValue());
            this.mouse = e.getX();
        }
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        this.requestFocus();
        int value = this.orientation == 0 ? e.getY() : e.getX();
        int minimum = this.getMinimum();
        int maximum = this.getMaximum();
        int lowValue = this.getLowValue();
        int highValue = this.getHighValue();
        switch (this.pick) {
            case 1: {
                int low = this.toLocal(value - this.pickOffsetLow);
                if (low < minimum) {
                    low = minimum;
                }
                if (low > maximum - this.minExtent) {
                    low = maximum - this.minExtent;
                }
                if (low > highValue - this.minExtent) {
                    this.setRange(low, low + this.minExtent);
                    break;
                }
                this.setLowValue(low);
                break;
            }
            case 3: {
                int high = this.toLocal(value - this.pickOffsetHigh);
                if (high < minimum + this.minExtent) {
                    high = minimum + this.minExtent;
                }
                if (high > maximum) {
                    high = maximum;
                }
                if (high < lowValue + this.minExtent) {
                    this.setRange(high - this.minExtent, high);
                    break;
                }
                this.setHighValue(high);
                break;
            }
            case 2: {
                int dxOrDy = this.toLocal(value - this.pickOffsetLow) - lowValue;
                if (dxOrDy < 0 && lowValue + dxOrDy < minimum) {
                    dxOrDy = minimum - lowValue;
                }
                if (dxOrDy > 0 && highValue + dxOrDy > maximum) {
                    dxOrDy = maximum - highValue;
                }
                if (dxOrDy == 0) break;
                this.offset(dxOrDy);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.pick = 0;
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        if (this.orientation == 0) {
            switch (this.pickHandle(e.getY())) {
                case 1: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 3: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 2: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 0: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        } else {
            switch (this.pickHandle(e.getX())) {
                case 1: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 3: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 2: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 0: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    private void grow(int increment) {
        this.model.setRangeProperties(this.model.getValue() - increment, this.model.getExtent() + 2 * increment, this.model.getMinimum(), this.model.getMaximum(), false);
    }

    public void keyPressed(KeyEvent e) {
        int kc = e.getKeyCode();
        boolean v = this.orientation == 0;
        boolean d = kc == 40;
        boolean u = kc == 38;
        boolean l = kc == 37;
        boolean r = kc == 39;
        int minimum = this.getMinimum();
        int maximum = this.getMaximum();
        int lowValue = this.getLowValue();
        int highValue = this.getHighValue();
        if (v && r || !v && u) {
            if (lowValue - this.increment >= minimum && highValue + this.increment <= maximum) {
                this.grow(this.increment);
            }
        } else if (v && l || !v && d) {
            if (highValue - lowValue >= 2 * this.increment) {
                this.grow(-1 * this.increment);
            }
        } else if (v && d || !v && l) {
            if (lowValue - this.increment >= minimum) {
                this.offset(-this.increment);
            }
        } else if ((v && u || !v && r) && highValue + this.increment <= maximum) {
            this.offset(this.increment);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    protected class RangeSliderChangeListener
    implements ChangeListener {
        protected RangeSliderChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            JRangeSlider.this.fireChangeEvent();
        }
    }
}

