/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.editors;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.actions.BrowseAction;
import org.eclipse.gmt.modisco.infra.browser.actions.DecreaseFontSizeAction;
import org.eclipse.gmt.modisco.infra.browser.actions.ExecuteSelectedQueryAction;
import org.eclipse.gmt.modisco.infra.browser.actions.IBrowserActionBarContributor;
import org.eclipse.gmt.modisco.infra.browser.actions.IncreaseFontSizeAction;
import org.eclipse.gmt.modisco.infra.browser.actions.LoadCustomizationsAction;
import org.eclipse.gmt.modisco.infra.browser.actions.LoadFacetsAction;
import org.eclipse.gmt.modisco.infra.browser.actions.OpenTableEditorAction;
import org.eclipse.gmt.modisco.infra.browser.actions.RefreshViewerAction;
import org.eclipse.gmt.modisco.infra.browser.actions.RemoveQueryAction;
import org.eclipse.gmt.modisco.infra.browser.actions.RestoreFontSizeAction;
import org.eclipse.gmt.modisco.infra.browser.actions.SelectQueryAction;
import org.eclipse.gmt.modisco.infra.browser.actions.ShowPropertiesViewAction;
import org.eclipse.gmt.modisco.infra.browser.core.QueryItem;
import org.eclipse.gmt.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.gmt.modisco.infra.browser.editors.IBrowserSelectionChangedListener;
import org.eclipse.gmt.modisco.infra.browser.editors.table.TableEditor;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.LinkItem;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserActionBarContributor
extends EditingDomainActionBarContributor
implements IBrowserSelectionChangedListener,
IBrowserActionBarContributor {
    private static final String EDIT_MENU_ID = "org.eclipse.gmt.modisco.infra.browser.editMenu";
    private IEditorPart fActiveEditor;
    private ISelectionProvider selectionProvider;
    private final IAction showPropertiesViewAction = new ShowPropertiesViewAction();
    private final IAction openTableEditorAction = new OpenTableEditorAction(this);
    private final IAction refreshViewerAction = new RefreshViewerAction(this);
    private final IAction selectQueryAction = new SelectQueryAction(this);
    private final IAction executeSelectedQueryAction = new ExecuteSelectedQueryAction(this);
    private final IAction removeQueryAction = new RemoveQueryAction(this);
    private ISelection fSelection;
    private final Action browseAction = new BrowseAction(this);
    private final Action increaseFontSizeAction = new IncreaseFontSizeAction(this);
    private final Action decreaseFontSizeAction = new DecreaseFontSizeAction(this);
    private final Action restoreFontSizeAction = new RestoreFontSizeAction(this);
    private final Action loadCustomizationsAction = new LoadCustomizationsAction(this);
    private final Action loadFacetsAction = new LoadFacetsAction(this);
    private Collection<IAction> createChildActions;
    private IMenuManager createChildMenuManager;
    private IMenuManager editorMenuManager;

    @Override
    public EcoreBrowser getBrowser() {
        return (EcoreBrowser)this.fActiveEditor;
    }

    @Override
    public ISelection getSelection() {
        return this.fSelection;
    }

    public BrowserActionBarContributor() {
        super(1);
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.increaseFontSizeAction);
        toolBarManager.add((IAction)this.decreaseFontSizeAction);
        toolBarManager.add((IAction)this.restoreFontSizeAction);
        toolBarManager.add((IAction)this.loadCustomizationsAction);
        toolBarManager.add((IAction)this.loadFacetsAction);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.fActiveEditor = part;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else if (part instanceof EcoreBrowser) {
            EcoreBrowser browser = (EcoreBrowser)part;
            this.selectionProvider = browser.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (browser.getEditorSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, browser.getEditorSelection()));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fSelection = event.getSelection();
    }

    private void updateActions(ISelection selection) {
        this.browseAction.setEnabled(this.enableBrowse(selection));
        this.openTableEditorAction.setEnabled(TableEditor.canBeOpenedOnSelection(selection));
    }

    private boolean enableBrowse(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() != 1) {
                return false;
            }
            Object element = structuredSelection.getFirstElement();
            if (element instanceof ModelElementItem) {
                return true;
            }
        }
        return false;
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        int nSelectedQueries;
        if (!this.getBrowser().isReadOnly()) {
            this.updateMenu();
            MenuManager submenuManager = null;
            submenuManager = new MenuManager(Messages.UI_CreateChild_menu_item);
            this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
            menuManager.add((IContributionItem)submenuManager);
        }
        menuManager.add((IAction)this.browseAction);
        menuManager.add(this.openTableEditorAction);
        int nSelectedModelElementItems = this.selectionCount(ModelElementItem.class);
        if (nSelectedModelElementItems > 0) {
            menuManager.add(this.selectQueryAction);
            if (nSelectedModelElementItems > 1) {
                this.selectQueryAction.setText(Messages.SelectQueryAction_addQueryOnElements);
            } else {
                this.selectQueryAction.setText(Messages.SelectQueryAction_addQueryOnElement);
            }
        }
        if ((nSelectedQueries = this.selectionCount(QueryItem.class)) > 0) {
            menuManager.add(this.executeSelectedQueryAction);
            menuManager.add(this.removeQueryAction);
            if (nSelectedQueries > 1) {
                this.executeSelectedQueryAction.setText(Messages.ExecuteQueryAction_executeQueries);
                this.removeQueryAction.setText(Messages.RemoveQueryAction_removeQueries);
            } else {
                this.executeSelectedQueryAction.setText(Messages.ExecuteQueryAction_executeSelectedQuery);
                this.removeQueryAction.setText(Messages.RemoveQueryAction_removeQuery);
            }
        }
        if (!this.getBrowser().isReadOnly()) {
            super.menuAboutToShow(menuManager);
        }
        this.updateActions(this.getSelection());
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.showPropertiesViewAction);
        menuManager.add(this.refreshViewerAction);
    }

    private void updateMenu() {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        Collection newChildDescriptors = null;
        ISelection selectionOnBrowser = null;
        if (this.fSelection instanceof IStructuredSelection && ((IStructuredSelection)this.fSelection).size() == 1 && this.fActiveEditor instanceof EcoreBrowser) {
            selectionOnBrowser = ((EcoreBrowser)this.fActiveEditor).getSelection();
            Object selectedObject = ((IStructuredSelection)this.fSelection).getFirstElement();
            EditingDomain domain = this.getBrowser().getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(selectedObject, null);
            if (selectedObject instanceof LinkItem) {
                LinkItem linkItem = (LinkItem)selectedObject;
                selectionOnBrowser = new StructuredSelection((Object)((ModelElementItem)linkItem.getTreeParent()).getEObject());
            }
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selectionOnBrowser);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
    }

    private int selectionCount(Class<?> clazz) {
        ISelection selection = this.getSelection();
        int count = 0;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection) {
                if (!clazz.isAssignableFrom(element.getClass())) continue;
                ++count;
            }
        }
        return count;
    }

    public IEditorPart getActiveEditor() {
        return this.fActiveEditor;
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        this.editorMenuManager = new MenuManager(Messages.UI_modiscoEditor_menu, EDIT_MENU_ID);
        menuManager.insertAfter("additions", (IContributionItem)this.editorMenuManager);
        this.editorMenuManager.add((IAction)this.increaseFontSizeAction);
        this.editorMenuManager.add((IAction)this.decreaseFontSizeAction);
        this.editorMenuManager.add((IAction)this.restoreFontSizeAction);
        this.editorMenuManager.add((IAction)this.loadCustomizationsAction);
        this.editorMenuManager.add((IAction)this.loadFacetsAction);
        this.editorMenuManager.add((IContributionItem)new Separator());
        this.editorMenuManager.add(this.showPropertiesViewAction);
        this.editorMenuManager.add(this.refreshViewerAction);
        this.editorMenuManager.add((IContributionItem)new Separator("settings"));
        this.editorMenuManager.add((IContributionItem)new Separator("actions"));
        this.editorMenuManager.add((IContributionItem)new Separator("additions"));
        this.editorMenuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(Messages.UI_CreateChild_menu_item);
        this.editorMenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.editorMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManag) {
                menuManag.updateAll(true);
            }
        });
        this.addGlobalActions(this.editorMenuManager);
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateChildAction(this.fActiveEditor, selection, descriptor));
            }
        }
        return actions;
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateSiblingAction(this.fActiveEditor, selection, descriptor));
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection<? extends IAction> actions) {
        if (actions != null) {
            IContributionItem[] items;
            IContributionItem[] iContributionItemArray = items = manager.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IAction action;
                IContributionItem contributionItem = iContributionItemArray[n2];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++n2;
            }
        }
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }
}

