/*******************************************************************************
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gregoire DUPE (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.infra.common.core.internal.resource;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;


public class BrokenRefException extends Exception implements Resource.Diagnostic {

	private static final long serialVersionUID = -2774251759867331337L;
	private EObject referedEObject;
	private Resource resource;

	public Resource getResource() {
		return this.resource;
	}

	public EObject getReferedEObject() {
		return this.referedEObject;
	}

	public BrokenRefException(final String message) {
		super(message);
	}

	public BrokenRefException(final Throwable cause) {
		super(cause);
	}

	public BrokenRefException(final String message, final Throwable cause) {
		super(message, cause);
	}

	public BrokenRefException(final EObject referedEObject) {
		this("A proxy with a null resource has been found: " //$NON-NLS-1$
				+ EcoreUtil.getURI(referedEObject).toString());
		this.referedEObject = referedEObject;
	}

	public BrokenRefException(final Resource resource) {
		this.resource = resource;
	}

	public String getLocation() {
		if (this.referedEObject != null) {
			return EcoreUtil.getURI(this.referedEObject).toString();
		} else if (this.resource != null) {
			return this.resource.getURI().toString();
		}
		return ""; //$NON-NLS-1$
	}

	public int getLine() {
		return 0;
	}

	public int getColumn() {
		return 0;
	}

}
