/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.common.ui.internal.dialogs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.ImageUtils;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.common.ui.internal.Messages;
import org.eclipse.gmt.modisco.infra.common.ui.internal.MoDiscoCommonUIPlugin;
import org.eclipse.gmt.modisco.infra.common.ui.internal.controls.FilteredElementSelectionControl;
import org.eclipse.gmt.modisco.infra.common.ui.internal.controls.MetamodelSelectionControl;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaclassSelectionDialog
extends Dialog {
    private static final int METAMODEL_GROUP_WIDTH = 400;
    private static final int METAMODEL_GROUP_HEIGHT = 400;
    private static final int METACLASS_GROUP_WIDTH = 400;
    private static final int METACLASS_GROUP_HEIGHT = 500;
    private static final String SETTINGS_FILENAME = "dialogSettings.txt";
    private static final String LAST_SELECTION_SETTINGS_SECTION = "LastSelection";
    private static final String METAMODEL_SETTING = "metamodel";
    private static final String CLASSIFIERS_SETTING = "classifiers";
    private MetamodelSelectionControl metamodelSelectionControl;
    private FilteredElementSelectionControl metaclassSelectionControl;
    private final List<EClassifier> selectedMetaclasses = new ArrayList<EClassifier>();
    private final boolean multiSelection;
    private final boolean restrictToEClass;
    private String selectedMetamodel;
    private List<EClassifier> initiallySelectedClassifiers;

    public MetaclassSelectionDialog(Shell parentShell, boolean multiSelection, boolean restrictToEClass) {
        super(parentShell);
        this.multiSelection = multiSelection;
        this.restrictToEClass = restrictToEClass;
    }

    public boolean close() {
        this.saveSettings();
        return super.close();
    }

    private void saveSettings() {
        try {
            IPath path = MoDiscoCommonUIPlugin.getDefault().getStateLocation();
            String filename = path.append(SETTINGS_FILENAME).toOSString();
            DialogSettings settings = new DialogSettings(LAST_SELECTION_SETTINGS_SECTION);
            settings.put(METAMODEL_SETTING, this.selectedMetamodel);
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < this.selectedMetaclasses.size()) {
                EClassifier eClassifier = this.selectedMetaclasses.get(i);
                builder.append(eClassifier.getName());
                if (i != this.selectedMetaclasses.size() - 1) {
                    builder.append("|");
                }
                ++i;
            }
            settings.put(CLASSIFIERS_SETTING, builder.toString());
            settings.save(filename);
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)MoDiscoCommonUIPlugin.getDefault());
        }
    }

    private void loadSettings() {
        try {
            IPath path = MoDiscoCommonUIPlugin.getDefault().getStateLocation();
            String filename = path.append(SETTINGS_FILENAME).toOSString();
            if (!new File(filename).isFile()) {
                return;
            }
            DialogSettings settings = new DialogSettings(LAST_SELECTION_SETTINGS_SECTION);
            settings.load(filename);
            String metamodel = settings.get(METAMODEL_SETTING);
            if (metamodel != null) {
                this.metamodelSelectionControl.getFilteredList().setSelection(new Object[]{metamodel});
                String classifiersStr = settings.get(CLASSIFIERS_SETTING);
                if (classifiersStr != null) {
                    String[] classifiers = classifiersStr.split("\\|");
                    EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(metamodel);
                    if (ePackage != null) {
                        EList eClassifiers = ePackage.getEClassifiers();
                        this.initiallySelectedClassifiers = new ArrayList<EClassifier>();
                        String[] stringArray = classifiers;
                        int n = classifiers.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String classifier = stringArray[n2];
                            for (EClassifier eClassifier : eClassifiers) {
                                if (!classifier.equals(eClassifier.getName())) continue;
                                this.initiallySelectedClassifiers.add(eClassifier);
                            }
                            ++n2;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)MoDiscoCommonUIPlugin.getDefault());
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return MoDiscoCommonUIPlugin.getDefault().getDialogSettings();
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(4, 4, true, true));
        contents.setLayout((Layout)new GridLayout(2, true));
        Composite leftPane = new Composite(contents, 0);
        leftPane.setLayoutData((Object)new GridData(4, 4, true, true));
        leftPane.setLayout((Layout)new GridLayout());
        this.createMetamodelPane(leftPane);
        Composite rightPane = new Composite(contents, 0);
        rightPane.setLayoutData((Object)new GridData(4, 4, true, true));
        rightPane.setLayout((Layout)new GridLayout());
        this.createMetaclassPane(rightPane);
        this.loadSettings();
        return contents;
    }

    private void createMetamodelPane(Composite contents) {
        Group metamodelGroup = new Group(contents, 0);
        metamodelGroup.setLayout((Layout)new GridLayout());
        metamodelGroup.setText(Messages.MetaclassSelectionDialog_metamodel);
        GridData metamodelGroupData = new GridData(4, 4, true, true);
        metamodelGroupData.widthHint = 400;
        metamodelGroupData.heightHint = 400;
        metamodelGroup.setLayoutData((Object)metamodelGroupData);
        this.metamodelSelectionControl = new MetamodelSelectionControl((Composite)metamodelGroup);
        this.metamodelSelectionControl.setLayoutData(new GridData(4, 4, true, true));
        this.metamodelSelectionControl.getFilteredList().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaclassSelectionDialog.this.metamodelChanged();
            }
        });
    }

    private void metamodelChanged() {
        Object[] selection = this.metamodelSelectionControl.getFilteredList().getSelection();
        if (selection.length == 1) {
            String metamodelURI;
            this.selectedMetamodel = metamodelURI = (String)selection[0];
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(metamodelURI);
            if (ePackage != null) {
                ArrayList<EClassifier> eClasses = new ArrayList<EClassifier>();
                EList eClassifiers = ePackage.getEClassifiers();
                for (EClassifier eClassifier : eClassifiers) {
                    if (this.restrictToEClass && !(eClassifier instanceof EClass)) continue;
                    eClasses.add(eClassifier);
                }
                this.metaclassSelectionControl.setElements(eClasses.toArray());
                if (this.initiallySelectedClassifiers != null) {
                    this.metaclassSelectionControl.getFilteredList().setSelection(this.initiallySelectedClassifiers.toArray());
                    this.initiallySelectedClassifiers = null;
                }
            } else {
                this.metaclassSelectionControl.setElements(new Object[0]);
            }
        } else {
            this.metaclassSelectionControl.setElements(new Object[0]);
        }
    }

    private void createMetaclassPane(Composite contents) {
        Group metaclassGroup = new Group(contents, 0);
        metaclassGroup.setLayout((Layout)new GridLayout());
        metaclassGroup.setText(Messages.MetaclassSelectionDialog_metaclass);
        GridData metaclassGroupData = new GridData(4, 4, true, true);
        metaclassGroupData.widthHint = 400;
        metaclassGroupData.heightHint = 500;
        metaclassGroup.setLayoutData((Object)metaclassGroupData);
        this.metaclassSelectionControl = new FilteredElementSelectionControl((Composite)metaclassGroup, false, this.multiSelection);
        this.metaclassSelectionControl.setLayoutData(new GridData(4, 4, true, true));
        this.metaclassSelectionControl.getFilteredList().setLabelProvider((ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return ImageUtils.getImage((Object)element);
            }

            public String getText(Object element) {
                EClassifier eClassifier = (EClassifier)element;
                return eClassifier.getName();
            }
        });
        this.metaclassSelectionControl.getFilteredList().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaclassSelectionDialog.this.metaclassChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                MetaclassSelectionDialog.this.okPressed();
            }
        });
    }

    private void metaclassChanged() {
        Button okButton = this.getButton(0);
        Object[] selection = this.metaclassSelectionControl.getFilteredList().getSelection();
        this.selectedMetaclasses.clear();
        if (selection.length > 0) {
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                Object selected = objectArray[n2];
                EClassifier eClassifier = (EClassifier)selected;
                this.selectedMetaclasses.add(eClassifier);
                ++n2;
            }
            if (okButton != null) {
                okButton.setEnabled(true);
            }
        } else if (okButton != null) {
            okButton.setEnabled(false);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.multiSelection) {
            if (this.restrictToEClass) {
                newShell.setText(Messages.MetaclassSelectionDialog_selectMetaclasses);
            } else {
                newShell.setText(Messages.MetaclassSelectionDialog_selectClassifiers);
            }
        } else if (this.restrictToEClass) {
            newShell.setText(Messages.MetaclassSelectionDialog_selectMetaclass);
        } else {
            newShell.setText(Messages.MetaclassSelectionDialog_selectClassifier);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    public List<EClassifier> getSelectedClassifiers() {
        return Collections.unmodifiableList(this.selectedMetaclasses);
    }

    public List<EClass> getSelectedMetaclasses() {
        ArrayList<EClass> list = new ArrayList<EClass>();
        for (EClassifier eClassifier : this.selectedMetaclasses) {
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            list.add(eClass);
        }
        return Collections.unmodifiableList(list);
    }
}

