/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 */

package org.eclipse.gmt.modisco.infra.discoverymanager.ui.launch.parametersdisplay;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterDirectionKind;
import org.eclipse.gmt.modisco.infra.discoverymanager.ui.launch.data.DiscoveryParameterDisplay;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;

/**
 * @author GBarbier
 * 
 */
public class DiscovererParametersComposite extends Composite {

	private static final class InnerParametersGroup {

		private ParametersTableComposite parametersGroup = null;
		private ExpandItem parametersItem = null;
		
		InnerParametersGroup() {
			// Empty
		}

		/**
		 * This method initializes inParametersGroup
		 * 
		 */
		void createInParametersGroup(final ExpandBar parametersBar,
				final List<DiscoveryParameterDisplay> discoveryParameters, final String message) {
			this.parametersGroup = new ParametersTableComposite(parametersBar, SWT.NONE,
					discoveryParameters);
			this.parametersItem = new ExpandItem(parametersBar, SWT.NONE, 0);
			this.parametersItem.setText(message);
			this.parametersItem.setHeight(this.parametersGroup
					.computeSize(SWT.DEFAULT, SWT.DEFAULT).y);
			this.parametersItem.setControl(this.parametersGroup);
			this.parametersItem.setExpanded(!discoveryParameters.isEmpty());
		}
		
		void updateDisplayParameters(
				final List<DiscoveryParameterDisplay> discoveryParameters) {
			this.parametersGroup.updateDisplayParameters(discoveryParameters);
		}
	}
	
	private Group discovererParametersGroup = null;
	private InnerParametersGroup inGroup = null;
//	private ParametersTableComposite inParametersGroup = null;
	private ParametersTableComposite inoutParametersGroup = null;
	private ParametersTableComposite outParametersGroup = null;
	private ExpandBar parametersBar = null;
//	private ExpandItem inParametersItem = null;
	private ExpandItem inoutParametersItem = null;
	private ExpandItem outParametersItem = null;

	private List<DiscoveryParameterDisplay> discoveryParameters;

	public DiscovererParametersComposite(final Composite parent, final int style) {
		super(parent, style);
		this.discoveryParameters = Collections.emptyList();
		initialize();
	}

	private final void initialize() {
		GridLayout gridLayout = new GridLayout();
		gridLayout.marginWidth = 0;
		gridLayout.marginHeight = 0;
		GridData gridData = new GridData();
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessVerticalSpace = true;
		setLayoutData(gridData);
		setLayout(gridLayout);
		createDiscovererParametersGroup();
	}

	/**
	 * This method initializes discovererParametersGroup
	 * 
	 */
	private final void createDiscovererParametersGroup() {
		GridData gridData1 = new GridData();
		gridData1.grabExcessHorizontalSpace = true;
		gridData1.horizontalAlignment = GridData.FILL;
		gridData1.verticalAlignment = GridData.FILL;
		gridData1.grabExcessVerticalSpace = true;
		this.discovererParametersGroup = new Group(this, SWT.NONE);
		this.discovererParametersGroup.setText(Messages.DiscovererParametersComposite_2);
		this.discovererParametersGroup.setLayoutData(gridData1);
		this.parametersBar = new ExpandBar(this.discovererParametersGroup, SWT.V_SCROLL);
		GridData gridData = new GridData();
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessVerticalSpace = true;
		this.parametersBar.setLayoutData(gridData);
		createInParametersGroup();
		createInoutParametersGroup();
		createOutParametersGroup();
		this.discovererParametersGroup.setLayout(new GridLayout());
	}

	/**
	 * This method initializes inParametersGroup
	 * 
	 */
	private final void createInParametersGroup() {
//		this.inParametersGroup = new ParametersTableComposite(this.parametersBar, SWT.NONE,
//				getInDiscoveryParameters());
//		this.inParametersItem = new ExpandItem(this.parametersBar, SWT.NONE, 0);
//		this.inParametersItem.setText(Messages.DiscovererParametersComposite_0);
//		this.inParametersItem.setHeight(this.inParametersGroup
//				.computeSize(SWT.DEFAULT, SWT.DEFAULT).y);
//		this.inParametersItem.setControl(this.inParametersGroup);
//		this.inParametersItem.setExpanded(getInDiscoveryParameters().isEmpty() == false);
		this.inGroup = new InnerParametersGroup();
		this.inGroup.createInParametersGroup(this.parametersBar, this.getInDiscoveryParameters(), Messages.DiscovererParametersComposite_0);
	}

	private final List<DiscoveryParameterDisplay> getInDiscoveryParameters() {
		List<DiscoveryParameterDisplay> inParameters = new ArrayList<DiscoveryParameterDisplay>();
		for (DiscoveryParameterDisplay parameter : this.discoveryParameters) {
			if (parameter.getParameterDirectionKind() == DiscoveryParameterDirectionKind.in) {
				inParameters.add(parameter);
			}
		}
		return inParameters;
	}

	/**
	 * This method initializes inoutParametersGroup
	 * 
	 */
	private final void createInoutParametersGroup() {
		this.inoutParametersGroup = new ParametersTableComposite(this.parametersBar, SWT.NONE,
				getInOutDiscoveryParameters());
		this.inoutParametersItem = new ExpandItem(this.parametersBar, SWT.NONE, 1);
		this.inoutParametersItem.setText(Messages.DiscovererParametersComposite_1);
		this.inoutParametersItem.setHeight(this.inoutParametersGroup.computeSize(SWT.DEFAULT,
				SWT.DEFAULT).y);
		this.inoutParametersItem.setControl(this.inoutParametersGroup);
		this.inoutParametersItem.setExpanded(!getInOutDiscoveryParameters().isEmpty());
	}

	private final List<DiscoveryParameterDisplay> getInOutDiscoveryParameters() {
		List<DiscoveryParameterDisplay> inoutParameters = new ArrayList<DiscoveryParameterDisplay>();
		for (DiscoveryParameterDisplay parameter : this.discoveryParameters) {
			if (parameter.getParameterDirectionKind() == DiscoveryParameterDirectionKind.inout) {
				inoutParameters.add(parameter);
			}
		}
		return inoutParameters;
	}

	/**
	 * This method initializes outParametersGroup
	 * 
	 */
	private final void createOutParametersGroup() {
		this.outParametersGroup = new ParametersTableComposite(this.parametersBar, SWT.NONE,
				getOutDiscoveryParameters());
		this.outParametersItem = new ExpandItem(this.parametersBar, SWT.NONE, 2);
		this.outParametersItem.setText(Messages.DiscovererParametersComposite_3);
		this.outParametersItem.setHeight(this.outParametersGroup.computeSize(SWT.DEFAULT,
				SWT.DEFAULT).y);
		this.outParametersItem.setControl(this.outParametersGroup);
		this.outParametersItem.setExpanded(!getOutDiscoveryParameters().isEmpty());
	}

	private final List<DiscoveryParameterDisplay> getOutDiscoveryParameters() {
		List<DiscoveryParameterDisplay> outParameters = new ArrayList<DiscoveryParameterDisplay>();
		for (DiscoveryParameterDisplay parameter : this.discoveryParameters) {
			if (parameter.getParameterDirectionKind() == DiscoveryParameterDirectionKind.out) {
				outParameters.add(parameter);
			}
		}
		return outParameters;
	}

	/**
	 * @param displayParameters
	 */
	public void updateDiscoveryParameters(final List<DiscoveryParameterDisplay> displayParameters) {
		this.discoveryParameters = displayParameters;
		this.inGroup.updateDisplayParameters(this.getInDiscoveryParameters());
//		this.inParametersGroup.updateDisplayParameters(getInDiscoveryParameters());
		this.inoutParametersGroup.updateDisplayParameters(getInOutDiscoveryParameters());
		this.outParametersGroup.updateDisplayParameters(getOutDiscoveryParameters());

		updateParametersItems();
	}

	private final void updateParametersItems() {
//		int size = getInDiscoveryParameters().size();
//		this.inParametersItem.setExpanded(size != 0);
//		if (this.inParametersItem.getExpanded()) {
//			this.inParametersItem.setHeight(this.inParametersGroup.getBounds().height);
//		}
		int size = getInOutDiscoveryParameters().size();
		this.inoutParametersItem.setExpanded(size != 0);
		if (this.inoutParametersItem.getExpanded()) {
			this.inoutParametersItem.setHeight(this.inoutParametersGroup.getBounds().height);
		}
		size = getOutDiscoveryParameters().size();
		this.outParametersItem.setExpanded(size != 0);
		if (this.outParametersItem.getExpanded()) {
			this.outParametersItem.setHeight(this.outParametersGroup.getBounds().height);
		}
	}
} // @jve:decl-index=0:visual-constraint="10,10"
