/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 */

package org.eclipse.gmt.modisco.infra.discoverymanager.ui.launch.utils;

import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

/**
 * @author Gabriel Barbier
 *
 */
public class IContainerCellEditor extends DialogCellEditor {

	/**
     * Opens a dialog box under the given parent control and returns the
     * dialog's value when it closes, or <code>null</code> if the dialog
     * was canceled or no selection was made in the dialog.
     * <p>
     * This framework method must be implemented by concrete subclasses.
     * It is called when the user has pressed the button and the dialog
     * box must pop up.
     * </p>
     *
     * @param cellEditorWindow the parent control cell editor's window
     *   so that a subclass can adjust the dialog box accordingly
     * @return the selected value, or <code>null</code> if the dialog was 
     *   canceled or no selection was made in the dialog
     */
	@Override
	protected Object openDialogBox(final Control cellEditorWindow) {
		Object result = null;
		ContainerSelectionDialog dialog = new ContainerSelectionDialog(cellEditorWindow.getShell(),
				null, true, null);
		if (dialog.open() == Window.OK) {
			result = dialog.getResult()[0];
		}
		return result;
	}

}
