/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Grgoire Dup (Mia-Software) - initial API and implementation
 * 
 *
 * $Id$
 */
package org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.CDOConfiguration;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.ReportmodelPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>CDO Configuration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.CDOConfigurationImpl#getVersion <em>Version</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.CDOConfigurationImpl#getRevisedLruCapacity <em>Revised Lru Capacity</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.CDOConfigurationImpl#getCacheType <em>Cache Type</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.CDOConfigurationImpl#getServerDescription <em>Server Description</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.CDOConfigurationImpl#getCurrentLruCapacity <em>Current Lru Capacity</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.CDOConfigurationImpl#getInitTime <em>Init Time</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CDOConfigurationImpl extends ConfigurationImpl implements CDOConfiguration {
	/**
	 * The default value of the '{@link #getVersion() <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVersion()
	 * @generated
	 * @ordered
	 */
	protected static final String VERSION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVersion() <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVersion()
	 * @generated
	 * @ordered
	 */
	protected String version = VERSION_EDEFAULT;

	/**
	 * The default value of the '{@link #getRevisedLruCapacity() <em>Revised Lru Capacity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRevisedLruCapacity()
	 * @generated
	 * @ordered
	 */
	protected static final int REVISED_LRU_CAPACITY_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getRevisedLruCapacity() <em>Revised Lru Capacity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRevisedLruCapacity()
	 * @generated
	 * @ordered
	 */
	protected int revisedLruCapacity = REVISED_LRU_CAPACITY_EDEFAULT;

	/**
	 * The default value of the '{@link #getCacheType() <em>Cache Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCacheType()
	 * @generated
	 * @ordered
	 */
	protected static final String CACHE_TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCacheType() <em>Cache Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCacheType()
	 * @generated
	 * @ordered
	 */
	protected String cacheType = CACHE_TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getServerDescription() <em>Server Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getServerDescription()
	 * @generated
	 * @ordered
	 */
	protected static final String SERVER_DESCRIPTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getServerDescription() <em>Server Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getServerDescription()
	 * @generated
	 * @ordered
	 */
	protected String serverDescription = SERVER_DESCRIPTION_EDEFAULT;

	/**
	 * The default value of the '{@link #getCurrentLruCapacity() <em>Current Lru Capacity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCurrentLruCapacity()
	 * @generated
	 * @ordered
	 */
	protected static final int CURRENT_LRU_CAPACITY_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCurrentLruCapacity() <em>Current Lru Capacity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCurrentLruCapacity()
	 * @generated
	 * @ordered
	 */
	protected int currentLruCapacity = CURRENT_LRU_CAPACITY_EDEFAULT;

	/**
	 * The default value of the '{@link #getInitTime() <em>Init Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInitTime()
	 * @generated
	 * @ordered
	 */
	protected static final double INIT_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getInitTime() <em>Init Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInitTime()
	 * @generated
	 * @ordered
	 */
	protected double initTime = INIT_TIME_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CDOConfigurationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ReportmodelPackage.Literals.CDO_CONFIGURATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVersion(String newVersion) {
		String oldVersion = version;
		version = newVersion;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ReportmodelPackage.CDO_CONFIGURATION__VERSION, oldVersion, version));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getRevisedLruCapacity() {
		return revisedLruCapacity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRevisedLruCapacity(int newRevisedLruCapacity) {
		int oldRevisedLruCapacity = revisedLruCapacity;
		revisedLruCapacity = newRevisedLruCapacity;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ReportmodelPackage.CDO_CONFIGURATION__REVISED_LRU_CAPACITY, oldRevisedLruCapacity, revisedLruCapacity));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getCacheType() {
		return cacheType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCacheType(String newCacheType) {
		String oldCacheType = cacheType;
		cacheType = newCacheType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ReportmodelPackage.CDO_CONFIGURATION__CACHE_TYPE, oldCacheType, cacheType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getServerDescription() {
		return serverDescription;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setServerDescription(String newServerDescription) {
		String oldServerDescription = serverDescription;
		serverDescription = newServerDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ReportmodelPackage.CDO_CONFIGURATION__SERVER_DESCRIPTION, oldServerDescription, serverDescription));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCurrentLruCapacity() {
		return currentLruCapacity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCurrentLruCapacity(int newCurrentLruCapacity) {
		int oldCurrentLruCapacity = currentLruCapacity;
		currentLruCapacity = newCurrentLruCapacity;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ReportmodelPackage.CDO_CONFIGURATION__CURRENT_LRU_CAPACITY, oldCurrentLruCapacity, currentLruCapacity));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getInitTime() {
		return initTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInitTime(double newInitTime) {
		double oldInitTime = initTime;
		initTime = newInitTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ReportmodelPackage.CDO_CONFIGURATION__INIT_TIME, oldInitTime, initTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ReportmodelPackage.CDO_CONFIGURATION__VERSION:
				return getVersion();
			case ReportmodelPackage.CDO_CONFIGURATION__REVISED_LRU_CAPACITY:
				return getRevisedLruCapacity();
			case ReportmodelPackage.CDO_CONFIGURATION__CACHE_TYPE:
				return getCacheType();
			case ReportmodelPackage.CDO_CONFIGURATION__SERVER_DESCRIPTION:
				return getServerDescription();
			case ReportmodelPackage.CDO_CONFIGURATION__CURRENT_LRU_CAPACITY:
				return getCurrentLruCapacity();
			case ReportmodelPackage.CDO_CONFIGURATION__INIT_TIME:
				return getInitTime();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ReportmodelPackage.CDO_CONFIGURATION__VERSION:
				setVersion((String)newValue);
				return;
			case ReportmodelPackage.CDO_CONFIGURATION__REVISED_LRU_CAPACITY:
				setRevisedLruCapacity((Integer)newValue);
				return;
			case ReportmodelPackage.CDO_CONFIGURATION__CACHE_TYPE:
				setCacheType((String)newValue);
				return;
			case ReportmodelPackage.CDO_CONFIGURATION__SERVER_DESCRIPTION:
				setServerDescription((String)newValue);
				return;
			case ReportmodelPackage.CDO_CONFIGURATION__CURRENT_LRU_CAPACITY:
				setCurrentLruCapacity((Integer)newValue);
				return;
			case ReportmodelPackage.CDO_CONFIGURATION__INIT_TIME:
				setInitTime((Double)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ReportmodelPackage.CDO_CONFIGURATION__VERSION:
				setVersion(VERSION_EDEFAULT);
				return;
			case ReportmodelPackage.CDO_CONFIGURATION__REVISED_LRU_CAPACITY:
				setRevisedLruCapacity(REVISED_LRU_CAPACITY_EDEFAULT);
				return;
			case ReportmodelPackage.CDO_CONFIGURATION__CACHE_TYPE:
				setCacheType(CACHE_TYPE_EDEFAULT);
				return;
			case ReportmodelPackage.CDO_CONFIGURATION__SERVER_DESCRIPTION:
				setServerDescription(SERVER_DESCRIPTION_EDEFAULT);
				return;
			case ReportmodelPackage.CDO_CONFIGURATION__CURRENT_LRU_CAPACITY:
				setCurrentLruCapacity(CURRENT_LRU_CAPACITY_EDEFAULT);
				return;
			case ReportmodelPackage.CDO_CONFIGURATION__INIT_TIME:
				setInitTime(INIT_TIME_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ReportmodelPackage.CDO_CONFIGURATION__VERSION:
				return VERSION_EDEFAULT == null ? version != null : !VERSION_EDEFAULT.equals(version);
			case ReportmodelPackage.CDO_CONFIGURATION__REVISED_LRU_CAPACITY:
				return revisedLruCapacity != REVISED_LRU_CAPACITY_EDEFAULT;
			case ReportmodelPackage.CDO_CONFIGURATION__CACHE_TYPE:
				return CACHE_TYPE_EDEFAULT == null ? cacheType != null : !CACHE_TYPE_EDEFAULT.equals(cacheType);
			case ReportmodelPackage.CDO_CONFIGURATION__SERVER_DESCRIPTION:
				return SERVER_DESCRIPTION_EDEFAULT == null ? serverDescription != null : !SERVER_DESCRIPTION_EDEFAULT.equals(serverDescription);
			case ReportmodelPackage.CDO_CONFIGURATION__CURRENT_LRU_CAPACITY:
				return currentLruCapacity != CURRENT_LRU_CAPACITY_EDEFAULT;
			case ReportmodelPackage.CDO_CONFIGURATION__INIT_TIME:
				return initTime != INIT_TIME_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (version: "); //$NON-NLS-1$
		result.append(version);
		result.append(", revisedLruCapacity: "); //$NON-NLS-1$
		result.append(revisedLruCapacity);
		result.append(", cacheType: "); //$NON-NLS-1$
		result.append(cacheType);
		result.append(", serverDescription: "); //$NON-NLS-1$
		result.append(serverDescription);
		result.append(", currentLruCapacity: "); //$NON-NLS-1$
		result.append(currentLruCapacity);
		result.append(", initTime: "); //$NON-NLS-1$
		result.append(initTime);
		result.append(')');
		return result.toString();
	}

} //CDOConfigurationImpl
