/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.discoverer.benchmark;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.ComponentFactory;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Scale;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.Activator;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.Messages;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Benchmark;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.CDOConfiguration;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Configuration;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.ReportmodelFactory;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.template.html.HtmlReport;
import org.eclipse.swt.graphics.Point;

public class Report {
    private static final int MINUTE_MS_RANGE = 60000;
    private static final int CHART_SIZE = 1000;
    private static final int RESCALE_COEF = 10;
    private static final double BOUNDS_SCALE_CONST = 72.0;
    public static final String HTMLREPORT_FILE_NAME = "report.html";
    private final IProject statProject;
    private final Map<Integer, ArrayList<Float>> map = new HashMap<Integer, ArrayList<Float>>();
    private final Map<String, Integer> titleMap = new HashMap<String, Integer>();
    private int index = 0;

    public Report(IProject statProject) {
        this.statProject = statProject;
    }

    public Benchmark generate() throws CoreException, IOException {
        Benchmark benchmark = this.buildReportModelAndDiagrams();
        this.generateHTML(benchmark, this.statProject.getLocation().toFile());
        return benchmark;
    }

    private Benchmark buildReportModelAndDiagrams() throws CoreException, IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createURI((String)("platform:/resource/" + this.statProject.getName() + "/report.xmi"));
        Resource modelResource = resourceSet.createResource(uri);
        Benchmark benchmark = ReportmodelFactory.eINSTANCE.createBenchmark();
        modelResource.getContents().add((Object)benchmark);
        ArrayList<Status> errors = new ArrayList<Status>();
        this.statProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        IResource[] iResourceArray = this.statProject.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            try {
                IFile file;
                if (resource instanceof IFile && (file = (IFile)resource).getLocation().getFileExtension().equals("tsv")) {
                    Configuration configuration;
                    String lastLine1 = "";
                    String lastLine2 = "";
                    BufferedReader bufferReader = new BufferedReader(new FileReader(file.getLocation().toFile()));
                    String line = bufferReader.readLine();
                    this.titleLine(line);
                    line = bufferReader.readLine();
                    int maxUsedMemory = 0;
                    while (line != null) {
                        this.addToSeries(line);
                        lastLine2 = lastLine1;
                        lastLine1 = line;
                        int usedMemory = new Integer(this.getValue(line, "USED_MEMORY"));
                        maxUsedMemory = Math.max(maxUsedMemory, usedMemory);
                        line = bufferReader.readLine();
                    }
                    IResource txtResource = resource.getParent().findMember(resource.getName().replaceAll("(.*)tsv", "$1txt"));
                    Properties properties = new Properties();
                    properties.load(txtResource.getLocationURI().toURL().openStream());
                    String storageKind = properties.getProperty("STORAGE_KIND");
                    if (storageKind != null && storageKind.equals("CDO")) {
                        CDOConfiguration cdoConfiguration = ReportmodelFactory.eINSTANCE.createCDOConfiguration();
                        configuration = cdoConfiguration;
                        cdoConfiguration.setVersion(properties.getProperty("CDO_VERSION"));
                        cdoConfiguration.setServerDescription(properties.getProperty("CDO_SERVER_DESCRIPTION"));
                        cdoConfiguration.setRevisedLruCapacity(new Integer(properties.getProperty("REVISED_LRU_CAPACITY")));
                        cdoConfiguration.setCacheType(properties.getProperty("CDO_CACHE_TYPE"));
                        cdoConfiguration.setCurrentLruCapacity(new Integer(properties.getProperty("CURRENT_LRU_CAPACITY")));
                        try {
                            cdoConfiguration.setInitTime(new Double(properties.getProperty("INIT_TIME")) / 60000.0);
                        }
                        catch (Exception e) {
                            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                            Status status = new Status(4, "org.eclipse.gmt.modisco.java.discoverer.benchmark", e.getMessage(), (Throwable)e);
                            errors.add(status);
                        }
                    } else {
                        configuration = ReportmodelFactory.eINSTANCE.createConfiguration();
                    }
                    benchmark.getConfigurations().add((Object)configuration);
                    configuration.setName(resource.getName().replaceAll("(.*)\\.tsv", "$1"));
                    configuration.setMaxUsedMemory(maxUsedMemory);
                    configuration.setMetaModelVariante(properties.getProperty("MM_VARIANTE"));
                    configuration.setAlgoVariante(properties.getProperty("ALGO_VARIANTE"));
                    configuration.setSaveTime(new Double(this.getValue(lastLine2, "SAVE (ms)")) / 60000.0);
                    configuration.setTotalExecutionTime(new Double(this.getValue(lastLine2, "SINCEBEGIN (ms)")) / 60000.0);
                    configuration.setDiscovererClassName(properties.getProperty("DISCOVERER_CLASS_NAME"));
                    benchmark.setXmx(new Integer(properties.getProperty("XMX").replaceAll("^([0-9]+).*", "$1")));
                    benchmark.setJavaProjectName(properties.getProperty("JAVA_PROJECT_NAME"));
                    this.rescaleDebugCode(benchmark.getXmx());
                    this.birt(file, benchmark, configuration);
                }
                this.statProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                Status status = new Status(4, "org.eclipse.gmt.modisco.java.discoverer.benchmark", e.getMessage(), (Throwable)e);
                errors.add(status);
            }
            ++n2;
        }
        modelResource.save(Collections.EMPTY_MAP);
        if (errors.size() > 0) {
            CoreException e = new CoreException((IStatus)new MultiStatus("org.eclipse.gmt.modisco.java.discoverer.benchmark", 4, errors.toArray(new IStatus[0]), "", (Throwable)new Exception()));
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return benchmark;
    }

    private void birt(IFile file, Benchmark benchmark, Configuration configuration) {
        String diagramTitle = "";
        if (configuration instanceof CDOConfiguration) {
            diagramTitle = String.valueOf(diagramTitle) + "CDO ";
        }
        if (configuration.getAlgoVariante() != null) {
            diagramTitle = String.valueOf(diagramTitle) + configuration.getAlgoVariante() + " ";
        }
        if (configuration.getMetaModelVariante() != null) {
            diagramTitle = String.valueOf(diagramTitle) + configuration.getMetaModelVariante() + " ";
        }
        if (configuration instanceof CDOConfiguration) {
            CDOConfiguration cdoConfiguration = (CDOConfiguration)configuration;
            diagramTitle = String.valueOf(diagramTitle) + "(" + cdoConfiguration.getServerDescription() + ")";
        }
        ChartWithAxes chart = ChartWithAxesImpl.create();
        chart.setDimension(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL);
        chart.getPlot().setBackground((Fill)ColorDefinitionImpl.WHITE());
        chart.getPlot().getClientArea().setBackground((Fill)ColorDefinitionImpl.WHITE());
        chart.getLegend().setItemType(LegendItemType.SERIES_LITERAL);
        chart.getLegend().setVisible(true);
        chart.getTitle().getLabel().getCaption().setValue(diagramTitle);
        Axis xAxis = chart.getPrimaryBaseAxes()[0];
        xAxis.getTitle().setCaption(TextImpl.create((String)Messages.Report_0));
        xAxis.getTitle().setVisible(true);
        NumberDataSet categoryValues = NumberDataSetImpl.create(this.map.get(-1));
        Series xAxisSerie = SeriesImpl.create();
        xAxisSerie.setDataSet((DataSet)categoryValues);
        SeriesDefinition xSeriesDefinition = SeriesDefinitionImpl.create();
        xSeriesDefinition.getSeriesPalette().shift(1);
        xAxis.getSeriesDefinitions().add((Object)xSeriesDefinition);
        xSeriesDefinition.getSeries().add((Object)xAxisSerie);
        Axis yAxis = chart.getPrimaryOrthogonalAxis(xAxis);
        yAxis.getTitle().setVisible(true);
        yAxis.getTitle().getCaption().setValue("MB");
        this.createYAxis(yAxis, "USED_MEMORY", ColorDefinitionImpl.BLACK());
        this.createYAxis(yAxis, "DEBUG_CODE", ColorDefinitionImpl.BLUE());
        Scale scale = ComponentFactory.eINSTANCE.createScale();
        NumberDataElement dataElement = DataFactory.eINSTANCE.createNumberDataElement();
        dataElement.setValue((double)benchmark.getXmx());
        scale.setMax((DataElement)dataElement);
        NumberDataElement dataElement2 = DataFactory.eINSTANCE.createNumberDataElement();
        dataElement2.setValue(0.0);
        scale.setMin((DataElement)dataElement2);
        yAxis.setScale(scale);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createFileURI((String)file.getLocation().toString().replaceAll("(.*)tsv", "$1xmi")));
        resource.getContents().add((Object)chart);
        try {
            resource.save(Collections.EMPTY_MAP);
            PluginSettings ps = PluginSettings.instance();
            IDeviceRenderer render = ps.getDevice("dv.PNG");
            render.setProperty("device.file.identifier", (Object)file.getLocation().toString().replaceAll("(.*)tsv", "$1png"));
            Point size = new Point(1000, 1000);
            Bounds bounds = BoundsImpl.create((double)0.0, (double)0.0, (double)size.x, (double)size.y);
            int resolution = render.getDisplayServer().getDpiResolution();
            bounds.scale(72.0 / (double)resolution);
            Generator generator = Generator.instance();
            GeneratedChartState state = generator.build(render.getDisplayServer(), (Chart)chart, bounds, null, null, null);
            generator.render(render, state);
        }
        catch (Exception ex) {
            Status status = new Status(4, "org.eclipse.gmt.modisco.java.discoverer.benchmark", ex.getMessage(), (Throwable)ex);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    private void generateHTML(Benchmark benchmark, File targetDirectory) throws IOException {
        new HtmlReport(benchmark, targetDirectory, new ArrayList()).doGenerate(null);
    }

    private void createYAxis(Axis yAxis, String columnName, ColorDefinition colorDefinition) {
        LineSeries serie = (LineSeries)LineSeriesImpl.create();
        serie.setSeriesIdentifier((Object)columnName);
        Integer indexx = this.titleMap.get(columnName);
        ArrayList<Float> values = this.map.get(indexx);
        NumberDataSet dataSet = NumberDataSetImpl.create(values);
        serie.setDataSet((DataSet)dataSet);
        serie.getMarkers().clear();
        LineAttributes lineAttr = LineAttributesImpl.create((ColorDefinition)colorDefinition, (LineStyle)LineStyle.SOLID_LITERAL, (int)1);
        serie.setLineAttributes(lineAttr);
        Label label = LabelImpl.create();
        label.setCaption(TextImpl.create((String)columnName));
        label.setVisible(false);
        serie.setLabel(label);
        SeriesDefinition seriesDefinition = SeriesDefinitionImpl.create();
        seriesDefinition.getSeries().add((Object)serie);
        yAxis.getSeriesDefinitions().add((Object)seriesDefinition);
    }

    private void rescaleDebugCode(int maxMemory) {
        float coef = new Float(maxMemory).floatValue() / 10.0f;
        ArrayList<Float> l = this.map.get(this.titleMap.get("DEBUG_CODE"));
        ArrayList<Float> l2 = new ArrayList<Float>();
        for (Float f : l) {
            l2.add(Float.valueOf(f.floatValue() * coef));
        }
        this.map.put(this.titleMap.get("DEBUG_CODE"), l2);
    }

    private void addToSeries(String line) {
        ++this.index;
        this.map.get(-1).add(new Float(this.index));
        String[] splits = line.split("\t");
        int i = 0;
        while (i < splits.length) {
            Float f;
            try {
                f = new Float(splits[i]);
            }
            catch (Exception exception) {
                f = new Float(0.0f);
            }
            List serie = this.map.get(i);
            serie.add(f);
            ++i;
        }
    }

    private String getValue(String line, String columnName) {
        try {
            String[] splits = line.split("\t");
            return splits[this.titleMap.get(columnName)];
        }
        catch (Exception exception) {
            return "";
        }
    }

    private void titleLine(String line) {
        String[] titles = line.split("\t");
        this.titleMap.put("index", -1);
        this.map.put(-1, new ArrayList());
        int i = 0;
        while (i < titles.length) {
            this.titleMap.put(titles[i], i);
            this.map.put(i, new ArrayList());
            ++i;
        }
    }
}

