/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nicolas Guyomar (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.java.queries.text;

import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.java.ParameterValueList;
import org.eclipse.gmt.modisco.java.AbstractMethodDeclaration;
import org.eclipse.gmt.modisco.java.SingleVariableDeclaration;

public class GetAbstractMethodDeclarationText implements
		IJavaModelQuery<AbstractMethodDeclaration, String> {

	public String evaluate(final AbstractMethodDeclaration context,
			final ParameterValueList parameterValues)
			throws ModelQueryExecutionException {
		String abstractMethodDeclarationText = ""; //$NON-NLS-1$
		if (context != null) {
			if (context.getName() != null) {
				if (context.getName().length() > 0) {
					abstractMethodDeclarationText += context.getName();
					if (context.getParameters() != null) {
						abstractMethodDeclarationText += "("; //$NON-NLS-1$
						for (SingleVariableDeclaration test : context
								.getParameters()) {
							abstractMethodDeclarationText += test.getType()
									.getType().getName()
									+ " " + test.getName() + ", "; //$NON-NLS-1$ //$NON-NLS-2$
						}
						if (context.getParameters().size() > 0) {
							abstractMethodDeclarationText = abstractMethodDeclarationText
									.substring(0, abstractMethodDeclarationText
											.length() - 2);
						}
						abstractMethodDeclarationText += ")"; //$NON-NLS-1$
					}
				}
			}
		}
		return abstractMethodDeclarationText;
	}
}
