/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.kdm.browser.extension.structure;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.browser.uicore.extensions.naming.AbstractNameProvider;
import org.eclipse.gmt.modisco.omg.kdm.structure.AbstractStructureElement;
import org.eclipse.gmt.modisco.omg.kdm.structure.AbstractStructureRelationship;
import org.eclipse.gmt.modisco.omg.kdm.structure.ArchitectureView;
import org.eclipse.gmt.modisco.omg.kdm.structure.Component;
import org.eclipse.gmt.modisco.omg.kdm.structure.Layer;
import org.eclipse.gmt.modisco.omg.kdm.structure.SoftwareSystem;
import org.eclipse.gmt.modisco.omg.kdm.structure.StructureElement;
import org.eclipse.gmt.modisco.omg.kdm.structure.StructureModel;
import org.eclipse.gmt.modisco.omg.kdm.structure.StructureRelationship;
import org.eclipse.gmt.modisco.omg.kdm.structure.Subsystem;

/**
 * @generated
 */
public class NameProvider extends AbstractNameProvider {
// Start of user code for additional methods and attributes
 	
// End of user code

//	Start of user code name attribute for Subsystem		
	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getSubsystemName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}
//	End of user code
//	Start of user code name attribute for Layer		
	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getLayerName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}
//	End of user code
//	Start of user code name attribute for StructureModel		
	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getStructureModelName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}
//	End of user code
//	Start of user code name attribute for Component		
	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getComponentName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}
//	End of user code
//	Start of user code name attribute for SoftwareSystem		
	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getSoftwareSystemName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}
//	End of user code
//	Start of user code name attribute for StructureRelationship		
	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getStructureRelationshipName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}
//	End of user code
//	Start of user code name attribute for ArchitectureView		
	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getArchitectureViewName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}
//	End of user code
//	Start of user code name attribute for StructureElement		
	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getStructureElementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}
//	End of user code
//	Start of user code name attribute for AbstractStructureElement		
	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getAbstractStructureElementName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}
//	End of user code
//	Start of user code name attribute for AbstractStructureRelationship		
	/**
	 * remove this annotation to indicate that code has been changed manually.
	 * @generated
	 */
	private final String getAbstractStructureRelationshipName(EObject eObject) {
		String name = this.getDefaultName(eObject);
		return name;
	}
//	End of user code

	/**
	 * @generated
	 */
	public NameProvider() {
	}

	/**
	 * @return the name that must be displayed for the given {@link EObject}, or <code>null</code>
	 *         to keep the default name (or let another {@link NameProvider} provide the name)
	 * 
	 * @generated
	 */
	public String getName(EObject eObject) {
		String result = this.getDefaultName(eObject);
    	if (eObject instanceof Subsystem) {
      		result = this.getSubsystemName(eObject);
    	} else
    	if (eObject instanceof Layer) {
      		result = this.getLayerName(eObject);
    	} else
    	if (eObject instanceof StructureModel) {
      		result = this.getStructureModelName(eObject);
    	} else
    	if (eObject instanceof Component) {
      		result = this.getComponentName(eObject);
    	} else
    	if (eObject instanceof SoftwareSystem) {
      		result = this.getSoftwareSystemName(eObject);
    	} else
    	if (eObject instanceof StructureRelationship) {
      		result = this.getStructureRelationshipName(eObject);
    	} else
    	if (eObject instanceof ArchitectureView) {
      		result = this.getArchitectureViewName(eObject);
    	} else
    	if (eObject instanceof StructureElement) {
      		result = this.getStructureElementName(eObject);
    	} else
    	if (eObject instanceof AbstractStructureElement) {
      		result = this.getAbstractStructureElementName(eObject);
    	} else
    	if (eObject instanceof AbstractStructureRelationship) {
      		result = this.getAbstractStructureRelationshipName(eObject);
    	} 
		return result;
	}

}

