/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.kdm.source.discoverer.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.AtlLogHandler;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.Tools;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterDirectionKind;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterImpl;
import org.eclipse.gmt.modisco.kdm.source.discoverer.KDMSourceDiscoverer;
import org.eclipse.gmt.modisco.kdm.source.discoverer.actions.Messages;
import org.eclipse.gmt.modisco.kdm.source.discoverer.plugin.Activator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverSourceModelFromJavaProject
implements Discoverer {
    private final String targetExtension = "kdm";
    private final DiscoveryParameterImpl targetModel;
    private final DiscoveryParameterImpl targetUri;
    private final List<DiscoveryParameter> discovererParameters = new ArrayList<DiscoveryParameter>();

    public boolean isApplicableTo(Object source) {
        boolean result = false;
        if (source instanceof IJavaProject) {
            result = true;
        } else if (source instanceof IProject) {
            IProject project = (IProject)source;
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    result = true;
                }
            }
            catch (CoreException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return result;
    }

    @Deprecated
    public Resource discoverElement(Object source, URI target) {
        IPath path;
        Resource resource;
        block20: {
            IJavaProject project;
            resource = null;
            Logger logger = Logger.getLogger(this.getClass().getName());
            IJavaProject tempProject = null;
            if (source instanceof IJavaProject) {
                tempProject = (IJavaProject)source;
            } else if (source instanceof IProject) {
                project = (IProject)source;
                try {
                    if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                        tempProject = JavaCore.create((IProject)project);
                    }
                }
                catch (CoreException e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                }
            }
            project = tempProject;
            Object tempPath = project.getProject().getLocation().addTrailingSeparator().append(String.valueOf(project.getElementName()) + "_Source").addFileExtension("kdm");
            if (target != null) {
                tempPath = target.isRelative() ? ResourcesPlugin.getWorkspace().getRoot().getFullPath().append(target.path()) : new Path(target.toFileString());
            }
            path = tempPath;
            AtlLogHandler logHandler = new AtlLogHandler(String.valueOf(path.toString()) + ".log");
            logger.addHandler((Handler)logHandler);
            try {
                try {
                    KDMSourceDiscoverer disco = new KDMSourceDiscoverer();
                    resource = disco.getKDMModelFromJavaProject(project);
                    if (target != null) {
                        Tools.saveModel((Resource)resource, (URI)target);
                    } else {
                        Tools.saveModel((Resource)resource, (String)path.toString());
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Error in discovery of java project", e);
                    logger.removeHandler((Handler)logHandler);
                    logHandler.close();
                    try {
                        project.getCorrespondingResource().refreshLocal(1, null);
                    }
                    catch (Exception e1) {
                        MoDiscoLogger.logError((Throwable)e1, (Plugin)Activator.getDefault());
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                logger.removeHandler((Handler)logHandler);
                logHandler.close();
                try {
                    project.getCorrespondingResource().refreshLocal(1, null);
                }
                catch (Exception e1) {
                    MoDiscoLogger.logError((Throwable)e1, (Plugin)Activator.getDefault());
                }
                throw throwable;
            }
            logger.removeHandler((Handler)logHandler);
            logHandler.close();
            try {
                project.getCorrespondingResource().refreshLocal(1, null);
            }
            catch (Exception e1) {
                MoDiscoLogger.logError((Throwable)e1, (Plugin)Activator.getDefault());
            }
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IFile ifile = root.getFileForLocation(path);
                    if (ifile != null && ifile.exists()) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)ifile);
                    }
                }
                catch (PartInitException e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                }
            }
        });
        return resource;
    }

    public String toString() {
        return Messages.DiscoverSourceModelFromJavaProject_4;
    }

    public DiscoverSourceModelFromJavaProject() {
        this.targetModel = new DiscoveryParameterImpl("TargetModel", DiscoveryParameterDirectionKind.out, Resource.class, false);
        this.discovererParameters.add((DiscoveryParameter)this.targetModel);
        this.targetUri = new DiscoveryParameterImpl("TargetUri", DiscoveryParameterDirectionKind.in, URI.class, false);
        this.discovererParameters.add((DiscoveryParameter)this.targetUri);
    }

    public void discoverElement(Object source, Map<DiscoveryParameter, Object> parameters) {
        Object value;
        URI targetUri2 = null;
        if (parameters.containsKey(this.targetUri) && (value = parameters.get(this.targetUri)) instanceof URI) {
            targetUri2 = (URI)value;
        }
        Resource result = this.discoverElement(source, targetUri2);
        parameters.put((DiscoveryParameter)this.targetModel, result);
    }

    public List<DiscoveryParameter> getDiscovererParameters() {
        return Collections.unmodifiableList(this.discovererParameters);
    }
}

