/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.driver.java.ui;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.workflow.AbstractDriverCore;
import org.eclipse.gmt.modisco.workflow.driver.java.Activator;
import org.eclipse.gmt.modisco.workflow.driver.java.Constant;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Direction;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameter;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public class LaunchDriverJava extends AbstractDriverCore {

	@Override
	public String getTypeLaunchConfig() {
		return Constant.typeLaunchConfiguration;
	}

	@Override
	@SuppressWarnings("unchecked")
	public List<WorkParameter> getParameters(final ILaunchConfiguration configuration) {
		List<WorkParameter> parameters = new ArrayList<WorkParameter>();
		try {
			WorkParameter param = createOneWorkParameter(
					"org.eclipse.debug.core.MAPPED_RESOURCE_PATHS", Direction.IN, Messages.LaunchDriverJava_1, new Boolean(true), List.class); //$NON-NLS-1$
			param.setValue(createStringListValue(configuration
					.getAttribute(
							"org.eclipse.debug.core.MAPPED_RESOURCE_PATHS", (List<String>) null))); //$NON-NLS-1$
			parameters.add(param);
	
			WorkParameter param2 = createOneWorkParameter(
					"org.eclipse.debug.core.MAPPED_RESOURCE_TYPES", Direction.IN, Messages.LaunchDriverJava_4, new Boolean(true), List.class); //$NON-NLS-1$
			param2.setValue(createStringListValue(configuration
					.getAttribute(
							"org.eclipse.debug.core.MAPPED_RESOURCE_TYPES", (List<String>) null))); //$NON-NLS-1$
			parameters.add(param2);
			
			WorkParameter param3 = createOneWorkParameter(
					IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME,
					Direction.IN, Messages.LaunchDriverJava_6,
					new Boolean(true), String.class);
			param3.setValue(createStringValue(configuration.getAttribute(
					IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME,
					(String) null)));
			parameters.add(param3);
			
			WorkParameter param4 = createOneWorkParameter(
					IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME,
					Direction.IN, Messages.LaunchDriverJava_7,
					new Boolean(true), List.class);
			param4.setValue(createStringValue(configuration.getAttribute(
					IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME,
					(String) null)));
			parameters.add(param4);
			
		} catch (CoreException e) {
			MoDiscoLogger.logError(e, Activator.getDefault());
		}

		return parameters;
	}
}
