/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.driver.modiscoworkflow.ui;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.workflow.AbstractDriverCore;
import org.eclipse.gmt.modisco.workflow.MoDiscoWorkflowLaunchConstants;
import org.eclipse.gmt.modisco.workflow.driver.modiscoworkflow.Activator;
import org.eclipse.gmt.modisco.workflow.driver.modiscoworkflow.Constant;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Direction;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameter;

public class LaunchDriverMoDiscoWorkflow extends AbstractDriverCore {

	@Override
	public String getTypeLaunchConfig() {
		return Constant.typeLaunchConfiguration;
	}

	@Override
	@SuppressWarnings("unchecked")
	public List<WorkParameter> getParameters(final ILaunchConfiguration configuration) {
		List<WorkParameter> parameters = new ArrayList<WorkParameter>();
		try {
			String id = configuration.getAttribute(
					MoDiscoWorkflowLaunchConstants.idWorkflow, (String) null);
			WorkParameter param = createOneWorkParameter(
					MoDiscoWorkflowLaunchConstants.idWorkflow, Direction.IN,
					Messages.LaunchDriverMoDiscoWorkflow_0, new Boolean(true),
					String.class);
			param.setValue(createStringValue(configuration.getAttribute(
					MoDiscoWorkflowLaunchConstants.idWorkflow, (String) null)));
			parameters.add(param);
			if (id.equals(MoDiscoWorkflowLaunchConstants.idMinimaliste)) {
				WorkParameter param2 = createOneWorkParameter(
						MoDiscoWorkflowLaunchConstants.moDiscoListMinimalist,
						Direction.IN, Messages.LaunchDriverMoDiscoWorkflow_1,
						new Boolean(true), List.class);
				param2.setValue(createValueStringList(configuration
						.getAttribute(
								MoDiscoWorkflowLaunchConstants.moDiscoListMinimalist,
								(List<String>) null)));
				parameters.add(param2);
			} else {
				WorkParameter param2 = createOneWorkParameter(
						MoDiscoWorkflowLaunchConstants.moDiscoListSerialize,
						Direction.IN, Messages.LaunchDriverMoDiscoWorkflow_2,
						new Boolean(true), List.class);
				param2.setValue(createValueStringList(configuration
						.getAttribute(
								MoDiscoWorkflowLaunchConstants.moDiscoListSerialize,
								(List<String>) null)));
				parameters.add(param2);
				WorkParameter param3 = createOneWorkParameter(
						MoDiscoWorkflowLaunchConstants.moDiscoWorkNumber,
						Direction.IN, Messages.LaunchDriverMoDiscoWorkflow_3,
						new Boolean(true), Integer.class);
				param3.setValue(createIntegerValue(configuration.getAttribute(
						MoDiscoWorkflowLaunchConstants.moDiscoWorkNumber, 0)));
				parameters.add(param3);
				WorkParameter param4 = createOneWorkParameter(
						MoDiscoWorkflowLaunchConstants.resourcePath,
						Direction.IN, Messages.LaunchDriverMoDiscoWorkflow_4,
						new Boolean(true), String.class);
				param4.setValue(createStringValue(configuration.getAttribute(
						MoDiscoWorkflowLaunchConstants.resourcePath,
						(String) null)));
				parameters.add(param4);
			}

		} catch (CoreException e) {
			MoDiscoLogger.logWarning(e, Activator.getDefault());
		}
		return parameters;
	}
}
