/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.driver.modiscoworkflow.execution;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.workflow.MoDiscoWorkflowLaunchConstants;
import org.eclipse.gmt.modisco.workflow.driver.modiscoworkflow.Activator;

public class ParseLaunchConfigurationFile {
    private BufferedReader bufferFile;
    private String idWorkflow;
    private List<String> listMinimalist;
    private List<String> listSerialize;
    private int modiscoWorkNumber = 0;
    private String resourcePath;

    public ParseLaunchConfigurationFile(File file) {
        try {
            FileInputStream ips = new FileInputStream(file);
            InputStreamReader ipsr = new InputStreamReader(ips);
            this.bufferFile = new BufferedReader(ipsr);
        }
        catch (FileNotFoundException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        this.listMinimalist = new ArrayList<String>();
        this.listSerialize = new ArrayList<String>();
        this.parse();
    }

    private void parse() {
        try {
            String line = this.bufferFile.readLine();
            while (line != null) {
                this.keyOfLine(line);
                line = this.bufferFile.readLine();
            }
        }
        catch (FileNotFoundException e) {
            MoDiscoLogger.logWarning((Throwable)e, (Plugin)Activator.getDefault());
        }
        catch (IOException e) {
            MoDiscoLogger.logWarning((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    private void parseResourcePath(String line) {
        String[] stringArray = line.split("value=\"");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.indexOf("\"/>") != -1) {
                if (s.split("\"/>").length <= 0) break;
                this.resourcePath = s.split("\"/>")[0];
                break;
            }
            ++n2;
        }
    }

    private void parseMoDiscoWorkNumber(String line) {
        String[] stringArray = line.split("value=\"");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.indexOf("\"/>") != -1) {
                if (s.split("\"/>").length <= 0) break;
                this.modiscoWorkNumber = Integer.parseInt(s.split("\"/>")[0]);
                break;
            }
            ++n2;
        }
    }

    private void parseListSerialize(String line) {
        String[] stringArray = line.split("value=\"");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.indexOf("\"/>") != -1) {
                if (s.split("\"/>").length <= 0) break;
                this.listSerialize.add(s.split("\"/>")[0]);
                break;
            }
            ++n2;
        }
    }

    private void parseListMinimalist(String line) {
        String[] stringArray = line.split("value=\"");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.indexOf("\"/>") != -1) {
                if (s.split("\"/>").length <= 0) break;
                this.listMinimalist.add(s.split("\"/>")[0]);
                break;
            }
            ++n2;
        }
    }

    private void parseIdWorkflow(String line) {
        String[] stringArray = line.split("value=\"");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.indexOf("\"/>") != -1) {
                if (s.split("\"/>").length <= 0) break;
                this.idWorkflow = s.split("\"/>")[0];
                break;
            }
            ++n2;
        }
    }

    public void save(ILaunchConfigurationWorkingCopy copy) {
        copy.setAttribute(MoDiscoWorkflowLaunchConstants.idWorkflow, this.idWorkflow);
        if (this.idWorkflow.equals(MoDiscoWorkflowLaunchConstants.idMinimaliste)) {
            this.saveEngineMinimalist(copy);
        } else {
            this.saveEngineMWE(copy);
        }
    }

    private void saveEngineMWE(ILaunchConfigurationWorkingCopy copy) {
        copy.setAttribute(MoDiscoWorkflowLaunchConstants.moDiscoListSerialize, this.listSerialize);
        copy.setAttribute(MoDiscoWorkflowLaunchConstants.moDiscoWorkNumber, this.modiscoWorkNumber);
        copy.setAttribute(MoDiscoWorkflowLaunchConstants.resourcePath, this.resourcePath);
    }

    private void saveEngineMinimalist(ILaunchConfigurationWorkingCopy copy) {
        copy.setAttribute(MoDiscoWorkflowLaunchConstants.moDiscoListMinimalist, this.listMinimalist);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void keyOfLine(String line) {
        String key = null;
        String[] s = line.split("key=\"");
        if (s[0] == line) return;
        if (s.length <= 1) return;
        if (s[1].split("\"").length <= 0) return;
        key = s[1].split("\"")[0];
        if (key.equals(MoDiscoWorkflowLaunchConstants.idWorkflow)) {
            this.parseIdWorkflow(line);
            return;
        }
        if (key.equals(MoDiscoWorkflowLaunchConstants.moDiscoWorkNumber)) {
            this.parseMoDiscoWorkNumber(line);
            return;
        }
        if (key.equals(MoDiscoWorkflowLaunchConstants.resourcePath)) {
            this.parseResourcePath(line);
            return;
        }
        if (key.equals(MoDiscoWorkflowLaunchConstants.moDiscoListMinimalist)) {
            try {
                String lineList = this.bufferFile.readLine();
                while (lineList != null) {
                    if (lineList.equals("</listAttribute>")) {
                        return;
                    }
                    this.parseListMinimalist(lineList);
                    lineList = this.bufferFile.readLine();
                }
                return;
            }
            catch (IOException e) {
                MoDiscoLogger.logWarning((Throwable)e, (Plugin)Activator.getDefault());
                return;
            }
        }
        if (!key.equals(MoDiscoWorkflowLaunchConstants.moDiscoListSerialize)) return;
        try {
            String lineList = this.bufferFile.readLine();
            while (lineList != null) {
                if (lineList.equals("</listAttribute>")) {
                    return;
                }
                this.parseListSerialize(lineList);
                lineList = this.bufferFile.readLine();
            }
            return;
        }
        catch (IOException e) {
            MoDiscoLogger.logWarning((Throwable)e, (Plugin)Activator.getDefault());
        }
    }
}

