/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.mwe.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.workflow.MoDiscoWorkflowLaunchConstants;
import org.eclipse.gmt.modisco.workflow.WorkflowModelInterface;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Direction;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Element;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.ModiscoworkflowFactory;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Work;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameter;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameterValue;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Workflow;
import org.eclipse.gmt.modisco.workflow.mwe.Activator;
import org.eclipse.gmt.modisco.workflow.mwe.impl.Messages;
import org.eclipse.gmt.modisco.workflow.mwe.workflow.WorkflowComponent;
import org.eclipse.gmt.modisco.workflow.mwe.workflow.WorkflowComponentMinimalist;
import org.eclipse.gmt.modisco.workflow.mwe.workflow.WorkflowComponentProxy;
import org.eclipse.gmt.modisco.workflow.mwe.workflow.WorkflowCompositeComponent;
import org.eclipse.gmt.modisco.workflow.mwe.workflow.WorkflowFactory;
import org.eclipse.gmt.modisco.workflow.mwe.workflow.WorkflowPackage;
import org.eclipse.gmt.modisco.workflow.mwe.workflow.WorkflowParameter;
import org.eclipse.gmt.modisco.workflow.mwe.workflow.WorkflowUnitOfWork;
import org.eclipse.gmt.modisco.workflow.mwe.workflow.orchestration.OrchestrationFactory;
import org.eclipse.gmt.modisco.workflow.mwe.workflow.runtime.RuntimeFactory;
import org.eclipse.gmt.modisco.workflow.mwe.workflow.runtime.WorkflowContext;
import org.eclipse.gmt.modisco.workflow.mwe.workflow.runtime.WorkflowEngine;
import org.eclipse.gmt.modisco.workflow.mwe.workflow.runtime.WorkflowEngineProxy;
import org.eclipse.gmt.modisco.workflow.mwe.workflow.runtime.impl.RuntimeFactoryImpl;
import org.eclipse.gmt.modisco.workflow.mwe.workflow.runtime.impl.WorkflowParameterMapImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowModelImpl
implements WorkflowModelInterface {
    private org.eclipse.gmt.modisco.workflow.mwe.workflow.Workflow workflow;
    private ResourceSet resSet = new ResourceSetImpl();
    private Resource resource;
    private String currentPath;

    public void addComponentWorkflow(EObject element) {
        Element modiscoElement = (Element)element;
        WorkflowComponent component = null;
        WorkflowContext context = null;
        if (modiscoElement instanceof Workflow) {
            ILaunchConfiguration configurationComposite = this.getLaunchConfigurationFromName(modiscoElement.getName());
            try {
                String id = configurationComposite.getAttribute(MoDiscoWorkflowLaunchConstants.idWorkflow, null);
                if (id.equals(MoDiscoWorkflowLaunchConstants.idMinimaliste)) {
                    component = WorkflowFactory.eINSTANCE.createWorkflowComponentMinimalist();
                    component.setName(modiscoElement.getName());
                    component.setType(modiscoElement.getType());
                    WorkflowEngine engine = RuntimeFactory.eINSTANCE.createWorkflowEngine();
                    engine.setWorkflow(component);
                    engine.setContext(RuntimeFactory.eINSTANCE.createWorkflowContext());
                    ((WorkflowEngine)this.workflow.getEngines().get(0)).getEngines().add((Object)engine);
                } else {
                    org.eclipse.gmt.modisco.workflow.mwe.workflow.Workflow workflowLoaded = this.loadResource(configurationComposite);
                    component = WorkflowFactory.eINSTANCE.createWorkflowComponentProxy();
                    WorkflowComponent componentLoaded = (WorkflowComponent)workflowLoaded.getComponents().get(0);
                    component.setDescription(componentLoaded.getDescription());
                    component.setName(componentLoaded.getName());
                    component.setType(componentLoaded.getType());
                    ((WorkflowComponentProxy)component).setTargetComponent(componentLoaded);
                    WorkflowEngineProxy engineProxy = RuntimeFactory.eINSTANCE.createWorkflowEngineProxy();
                    engineProxy.setTargetEngine((WorkflowEngine)workflowLoaded.getEngines().get(0));
                    engineProxy.setWorkflow(component);
                    ((WorkflowEngine)this.workflow.getEngines().get(0)).getEngines().add((Object)engineProxy);
                }
                ((WorkflowCompositeComponent)this.workflow.getComponents().get(0)).getComponents().add((Object)component);
            }
            catch (CoreException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        } else {
            WorkflowEngine engine = RuntimeFactory.eINSTANCE.createWorkflowEngine();
            component = this.findElementInEngineList(modiscoElement, (List<WorkflowEngine>)this.workflow.getEngines());
            if (component == null) {
                ArrayList<WorkflowEngine> tmpEngineAdd = new ArrayList<WorkflowEngine>();
                component = this.createWorkflowComponentFromElement(modiscoElement, engine, tmpEngineAdd);
                ((WorkflowCompositeComponent)this.workflow.getComponents().get(0)).getComponents().add((Object)component);
                ((WorkflowCompositeComponent)this.workflow.getComponents().get(0)).getComponents().add((Object)component);
            } else {
                WorkflowContext contextFind = this.findContextInEngineList(component, (List<WorkflowEngine>)this.workflow.getEngines());
                EcoreUtil.Copier copier = new EcoreUtil.Copier();
                context = (WorkflowContext)copier.copy((EObject)contextFind);
                copier.copyReferences();
                engine.setContext(context);
                engine.setWorkflow(component);
            }
            ((WorkflowEngine)this.workflow.getEngines().get(0)).getEngines().add((Object)engine);
        }
        this.resource.getContents().add((Object)this.workflow);
    }

    public void save(ILaunchConfigurationWorkingCopy configuration, boolean onlyLaunch) {
        if (configuration != null) {
            List<EObject> listComponent;
            configuration.setAttribute(MoDiscoWorkflowLaunchConstants.resourcePath, this.currentPath);
            List<EObject> moDiscoList = listComponent = this.getAllComponents();
            configuration.setAttribute(MoDiscoWorkflowLaunchConstants.moDiscoWorkNumber, moDiscoList.size());
            configuration.setAttribute(MoDiscoWorkflowLaunchConstants.moDiscoListSerialize, this.listOrchestration(moDiscoList));
        }
        if (!onlyLaunch) {
            try {
                this.resource.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
    }

    private List<String> listOrchestration(List<Element> moDiscoWorkList) {
        ArrayList<String> tmpList = new ArrayList<String>();
        for (Element modisco : moDiscoWorkList) {
            tmpList.add(String.valueOf(modisco.getName()) + ";" + modisco.getIndex() + ";" + modisco.getType());
        }
        return tmpList;
    }

    public List<EObject> getAllComponents() {
        boolean engineDeleted = false;
        ArrayList<EObject> listComponent = new ArrayList<EObject>();
        int index = 0;
        for (WorkflowEngine engine : ((WorkflowEngine)this.workflow.getEngines().get(0)).getEngines()) {
            if (engine instanceof WorkflowEngineProxy) {
                WorkflowEngine targetEngine = ((WorkflowEngineProxy)engine).getTargetEngine();
                if (targetEngine.getWorkflow() == null) {
                    engineDeleted = true;
                } else {
                    engine = targetEngine;
                }
            }
            Element modisco = this.createElementFromComponent(engine, index, engineDeleted);
            listComponent.add((EObject)modisco);
            ++index;
        }
        return listComponent;
    }

    public void removeComponent(int index) {
        ArrayList<WorkflowEngine> engines = new ArrayList<WorkflowEngine>();
        WorkflowEngine engineRemoved = (WorkflowEngine)((WorkflowEngine)this.workflow.getEngines().get(0)).getEngines().get(index);
        WorkflowComponent component = null;
        component = engineRemoved instanceof WorkflowEngineProxy ? ((WorkflowEngineProxy)engineRemoved).getTargetEngine().getWorkflow() : engineRemoved.getWorkflow();
        for (WorkflowEngine engine : ((WorkflowEngine)this.workflow.getEngines().get(0)).getEngines()) {
            if (engine instanceof WorkflowEngineProxy) {
                engine = ((WorkflowEngineProxy)engine).getTargetEngine();
            }
            if (engine.getWorkflow() == null || !engine.getWorkflow().equals(component)) continue;
            engines.add(engine);
        }
        ((WorkflowEngine)this.workflow.getEngines().get(0)).getEngines().remove(index);
        if (engines.size() == 1) {
            if (engineRemoved instanceof WorkflowEngineProxy) {
                ((WorkflowCompositeComponent)this.workflow.getComponents().get(0)).getComponents().remove((Object)engineRemoved.getWorkflow());
            } else {
                ((WorkflowCompositeComponent)this.workflow.getComponents().get(0)).getComponents().remove((Object)component);
            }
        }
        this.resource.getContents().add((Object)this.workflow);
    }

    public EObject getComponent(int index) {
        boolean engineDeleted = false;
        WorkflowEngine engine = (WorkflowEngine)((WorkflowEngine)this.workflow.getEngines().get(0)).getEngines().get(index);
        if (engine instanceof WorkflowEngineProxy) {
            WorkflowEngine targetEngine = ((WorkflowEngineProxy)engine).getTargetEngine();
            if (targetEngine.getWorkflow() == null) {
                engineDeleted = true;
            } else {
                engine = targetEngine;
            }
        }
        Element modisco = this.createElementFromComponent(engine, index, engineDeleted);
        return modisco;
    }

    public void setComponent(int index, EObject modiscoElement) {
        Element modisco = (Element)modiscoElement;
        WorkflowComponent component = this.findElementInEngineList(modisco, (List<WorkflowEngine>)this.workflow.getEngines());
        component.setName(modisco.getName());
        component.setDescription("DESC_" + modisco.getName());
        component.setType(modisco.getType());
        if (component instanceof WorkflowUnitOfWork) {
            List<WorkflowEngine> engines = this.engineListContainingComponent(component, (List<WorkflowEngine>)this.workflow.getEngines());
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            HashMap<String, WorkParameterValue> mapParamModisco = new HashMap<String, WorkParameterValue>();
            for (WorkParameter parameter : ((Work)modisco).getParameters()) {
                mapParamModisco.put(parameter.getName(), parameter.getValue());
            }
            for (WorkflowEngine engine : engines) {
                for (Map.Entry entry : engine.getContext().getParameters().entrySet()) {
                    entry.setValue(copier.copy((EObject)mapParamModisco.get(((WorkflowParameter)entry.getKey()).getName())));
                    copier.copyReferences();
                }
            }
        }
        this.resource.getContents().add((Object)this.workflow);
    }

    private List<WorkflowEngine> engineListContainingComponent(WorkflowComponent component, List<WorkflowEngine> engines) {
        ArrayList<WorkflowEngine> enginesFind = new ArrayList<WorkflowEngine>();
        for (WorkflowEngine engine : engines) {
            List<WorkflowEngine> enginesFind2;
            if (engine instanceof WorkflowEngineProxy) continue;
            if (engine.getWorkflow().equals(component)) {
                enginesFind.add(engine);
            }
            if ((enginesFind2 = this.engineListContainingComponent(component, (List<WorkflowEngine>)engine.getEngines())).size() <= 0) continue;
            enginesFind.addAll(enginesFind2);
        }
        return enginesFind;
    }

    public void initialization(ILaunchConfiguration configuration, String path) {
        this.caseOfDuplication(configuration, path);
        WorkflowPackage.eINSTANCE.eClass();
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("workflow", new XMIResourceFactoryImpl());
        URI uri = URI.createFileURI((String)path);
        File f = new File(path);
        if (f.exists()) {
            this.resource = this.resSet.getResource(uri, true);
            this.workflow = (org.eclipse.gmt.modisco.workflow.mwe.workflow.Workflow)this.resource.getContents().get(0);
        } else {
            this.workflow = WorkflowFactory.eINSTANCE.createWorkflow();
            this.resource = this.resSet.createResource(uri);
            this.resource.getContents().add((Object)this.workflow);
            WorkflowCompositeComponent componentRoot = WorkflowFactory.eINSTANCE.createWorkflowCompositeComponent();
            componentRoot.setName(configuration.getName());
            componentRoot.setDescription(Messages.WorkflowModelImpl_4);
            try {
                componentRoot.setType(configuration.getType().getIdentifier());
            }
            catch (CoreException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
            componentRoot.setStateResolutionStrategy(RuntimeFactory.eINSTANCE.createWorkflowStateResolutionStrategy());
            componentRoot.setCompositeOrchestrationStrategy(OrchestrationFactory.eINSTANCE.createWorkflowSerialOrchestrationStrategy());
            this.workflow.getComponents().add((Object)componentRoot);
            WorkflowEngine engineRoot = RuntimeFactory.eINSTANCE.createWorkflowEngine();
            engineRoot.setWorkflow(componentRoot);
            engineRoot.setContext(RuntimeFactory.eINSTANCE.createWorkflowContext());
            this.workflow.getEngines().add((Object)engineRoot);
        }
        this.currentPath = path;
        this.save(null, false);
    }

    public void moveResource(String path) {
        if (!path.equals(this.currentPath)) {
            String newName = new File(path).getName();
            this.renameWorkflow(newName.substring(0, newName.lastIndexOf(".")));
            URI uri = URI.createFileURI((String)path);
            this.resource.setURI(uri);
            this.save(null, false);
            File f = new File(this.currentPath);
            if (f.exists()) {
                f.delete();
            }
            this.currentPath = path;
        }
    }

    public void removeResource(String resourcePath) {
        if (resourcePath.equals(this.currentPath)) {
            try {
                this.resource.delete(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
    }

    public void exportWorkflow(ILaunchConfiguration configuration, String outputPath) {
        Path pathOut = new Path(outputPath);
        Path currentPath2 = new Path(this.currentPath);
        String nameFile = currentPath2.lastSegment();
        pathOut = pathOut.append(nameFile);
        this.copyFile(this.currentPath, pathOut.makeAbsolute().toString());
    }

    public void downMoDiscoWork(int indexSelected) {
        ((WorkflowEngine)this.workflow.getEngines().get(0)).getEngines().move(indexSelected + 1, indexSelected);
    }

    public void upMoDisoWork(int indexSelected) {
        ((WorkflowEngine)this.workflow.getEngines().get(0)).getEngines().move(indexSelected - 1, indexSelected);
    }

    private WorkflowParameter createWorkflowParameter(String name, Direction direction, String type, boolean required, String description) {
        WorkflowParameter param = WorkflowFactory.eINSTANCE.createWorkflowParameter();
        param.setName(name);
        switch (direction.getValue()) {
            case 0: {
                param.setDirection(org.eclipse.gmt.modisco.workflow.mwe.workflow.Direction.IN);
                break;
            }
            case 1: {
                param.setDirection(org.eclipse.gmt.modisco.workflow.mwe.workflow.Direction.OUT);
                break;
            }
            case 2: {
                param.setDirection(org.eclipse.gmt.modisco.workflow.mwe.workflow.Direction.INOUT);
                break;
            }
        }
        param.setType(type);
        param.setRequired(required);
        param.setDescription(description);
        param.setValueStrategy(WorkflowFactory.eINSTANCE.createWorkflowParameterValueStrategy());
        return param;
    }

    private WorkflowContext findContextInEngineList(WorkflowComponent component, List<WorkflowEngine> engines) {
        WorkflowContext context = null;
        for (WorkflowEngine engine : engines) {
            if (engine instanceof WorkflowEngineProxy) {
                engine = ((WorkflowEngineProxy)engine).getTargetEngine();
            }
            if (engine.getWorkflow().equals(component)) {
                context = engine.getContext();
                break;
            }
            if (engine.getEngines() != null && (context = this.findContextInEngineList(component, (List<WorkflowEngine>)engine.getEngines())) != null) break;
        }
        return context;
    }

    private void copyFile(String pathFile1, String pathFile2) {
        block20: {
            FileChannel in = null;
            AbstractInterruptibleChannel out = null;
            try {
                try {
                    in = new FileInputStream(pathFile1).getChannel();
                    out = new FileOutputStream(pathFile2).getChannel();
                    in.transferTo(0L, in.size(), (WritableByteChannel)((Object)out));
                }
                catch (Exception e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            MoDiscoLogger.logError((Throwable)e2, (Plugin)Activator.getDefault());
                        }
                    }
                    if (out == null) break block20;
                    try {
                        out.close();
                    }
                    catch (IOException e3) {
                        MoDiscoLogger.logError((Throwable)e3, (Plugin)Activator.getDefault());
                    }
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    }
                }
            }
        }
    }

    private void caseOfDuplication(ILaunchConfiguration configuration, String path) {
        try {
            String configurationResourcePath = configuration.getAttribute(MoDiscoWorkflowLaunchConstants.resourcePath, null);
            if (configurationResourcePath != null && !configurationResourcePath.equals(path)) {
                File f1 = new File(configurationResourcePath);
                File f2 = new File(path);
                if (f1.exists() && !f2.exists()) {
                    this.copyFile(configurationResourcePath, path);
                }
            }
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Element createElementFromComponent(WorkflowEngine engine, int index, boolean engineDeletedParameter) {
        boolean engineDeleted = engineDeletedParameter;
        Work modisco = null;
        WorkflowComponent component = engine.getWorkflow();
        if (!engineDeleted) {
            if (component instanceof WorkflowComponentProxy) {
                component = ((WorkflowComponentProxy)component).getTargetComponent();
            }
            if (component instanceof WorkflowCompositeComponent) {
                modisco = ModiscoworkflowFactory.eINSTANCE.createWorkflow();
                int ind = 0;
                for (WorkflowEngine eng : engine.getEngines()) {
                    boolean engineDel = false;
                    if (eng instanceof WorkflowEngineProxy) {
                        WorkflowEngine targetEngine = ((WorkflowEngineProxy)eng).getTargetEngine();
                        if (targetEngine.getWorkflow() == null) {
                            engineDeleted = true;
                        } else {
                            eng = targetEngine;
                        }
                    }
                    ((Workflow)modisco).getElements().add((Object)this.createElementFromComponent(eng, ind, engineDel));
                    ++ind;
                }
            } else if (component instanceof WorkflowUnitOfWork) {
                modisco = ModiscoworkflowFactory.eINSTANCE.createWork();
                modisco.getParameters().addAll(this.createWorkParametersFromComponent(engine));
            } else {
                if (!(component instanceof WorkflowComponentMinimalist)) throw new RuntimeException("Unepected compoent type");
                modisco = ModiscoworkflowFactory.eINSTANCE.createWorkflow();
            }
        } else {
            modisco = ModiscoworkflowFactory.eINSTANCE.createWork();
        }
        modisco.setIndex(index);
        modisco.setName(component.getName());
        modisco.setType(component.getType());
        return modisco;
    }

    private Collection<? extends WorkParameter> createWorkParametersFromComponent(WorkflowEngine engine) {
        ArrayList<WorkParameter> modiscoWorkParameterList = new ArrayList<WorkParameter>();
        ArrayList parameters = new ArrayList();
        WorkflowComponent component = engine.getWorkflow();
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        if (component instanceof WorkflowCompositeComponent) {
            parameters = ((WorkflowCompositeComponent)component).getParameters();
        } else if (component instanceof WorkflowUnitOfWork) {
            parameters = ((WorkflowUnitOfWork)component).getParameters();
        }
        for (WorkflowParameter parameter : parameters) {
            WorkParameter modiscoWorkParameter = ModiscoworkflowFactory.eINSTANCE.createWorkParameter();
            modiscoWorkParameter.setDescription(parameter.getDescription());
            switch (parameter.getDirection().getValue()) {
                case 0: {
                    modiscoWorkParameter.setDirection(Direction.IN);
                    break;
                }
                case 1: {
                    modiscoWorkParameter.setDirection(Direction.OUT);
                    break;
                }
                case 2: {
                    modiscoWorkParameter.setDirection(Direction.INOUT);
                    break;
                }
            }
            modiscoWorkParameter.setName(parameter.getName());
            modiscoWorkParameter.setRequired(parameter.isRequired());
            modiscoWorkParameter.setType(parameter.getType());
            modiscoWorkParameter.setValue((WorkParameterValue)copier.copy((EObject)engine.getContext().getParameters().get((Object)parameter)));
            modiscoWorkParameterList.add(modiscoWorkParameter);
        }
        return modiscoWorkParameterList;
    }

    private WorkflowComponent findElementInEngineList(Element elmt, List<WorkflowEngine> engines) {
        WorkflowComponent componentFind = null;
        for (WorkflowEngine engine : engines) {
            if (engine instanceof WorkflowEngineProxy) {
                engine = ((WorkflowEngineProxy)engine).getTargetEngine();
            }
            if (engine.getWorkflow().getName().equals(elmt.getName())) {
                componentFind = engine.getWorkflow();
                break;
            }
            componentFind = this.findElementInEngineList(elmt, (List<WorkflowEngine>)engine.getEngines());
            if (componentFind != null) break;
        }
        return componentFind;
    }

    private WorkflowComponent createWorkflowComponentFromElement(Element modiscoElement, WorkflowEngine engineParent, List<WorkflowEngine> tmpEngineAdd) {
        WorkflowUnitOfWork component = null;
        WorkflowContext context = RuntimeFactory.eINSTANCE.createWorkflowContext();
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        component = WorkflowFactory.eINSTANCE.createWorkflowUnitOfWork();
        EList paramList = ((Work)modiscoElement).getParameters();
        if (paramList != null) {
            for (WorkParameter parameter : paramList) {
                WorkflowParameter param = this.createWorkflowParameter(parameter.getName(), parameter.getDirection(), parameter.getType(), parameter.isRequired(), "DESC_" + parameter.getDescription());
                if (component instanceof WorkflowCompositeComponent) {
                    ((WorkflowCompositeComponent)((Object)component)).getParameters().add((Object)param);
                } else {
                    component.getParameters().add((Object)param);
                }
                WorkflowParameterMapImpl entry = (WorkflowParameterMapImpl)((Object)((RuntimeFactoryImpl)RuntimeFactory.eINSTANCE).createWorkflowParameterMap());
                entry.setKey(param);
                EObject copy = copier.copy((EObject)parameter.getValue());
                copier.copyReferences();
                entry.setValue(copy);
                context.getParameters().add((Object)entry);
            }
        }
        component.setName(modiscoElement.getName());
        component.setDescription("DESC_" + modiscoElement.getName());
        component.setType(modiscoElement.getType());
        component.setComponentOrchestrationStrategy(OrchestrationFactory.eINSTANCE.createWorkflowComponentOrchestrationStrategy());
        engineParent.setContext(context);
        engineParent.setWorkflow(component);
        return component;
    }

    private ILaunchConfiguration getLaunchConfigurationFromName(String name) {
        ILaunchConfiguration configurationFind = null;
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (config.getName().equals(name)) {
                    configurationFind = config;
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return configurationFind;
    }

    private org.eclipse.gmt.modisco.workflow.mwe.workflow.Workflow loadResource(ILaunchConfiguration configuration) {
        String resourcePath = null;
        try {
            resourcePath = configuration.getAttribute(MoDiscoWorkflowLaunchConstants.resourcePath, null);
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("workflow", new XMIResourceFactoryImpl());
        URI uri = URI.createFileURI((String)resourcePath);
        Resource res = this.resSet.getResource(uri, true);
        org.eclipse.gmt.modisco.workflow.mwe.workflow.Workflow workflowLoad = (org.eclipse.gmt.modisco.workflow.mwe.workflow.Workflow)res.getContents().get(0);
        return workflowLoad;
    }

    public void synchronization(List<Element> elements) {
        this.synchronizationAllComponents(elements, (List<WorkflowEngine>)((WorkflowEngine)this.workflow.getEngines().get(0)).getEngines());
    }

    private void synchronizationAllComponents(List<Element> elements, List<WorkflowEngine> engines) {
        for (Element elmt : elements) {
            if (elmt instanceof Work) {
                WorkflowEngine engine = engines.get(elmt.getIndex());
                HashMap<String, WorkParameterValue> parameterMap = new HashMap<String, WorkParameterValue>();
                for (WorkParameter parameter : ((Work)elmt).getParameters()) {
                    parameterMap.put(parameter.getName(), parameter.getValue());
                }
                EMap<WorkflowParameter, EObject> mapParameterValue = engine.getContext().getParameters();
                if (mapParameterValue == null) continue;
                for (Map.Entry entry : mapParameterValue.entrySet()) {
                    WorkParameterValue newValue = (WorkParameterValue)parameterMap.get(((WorkflowParameter)entry.getKey()).getName());
                    entry.setValue(newValue);
                }
                continue;
            }
            if (engines.get(elmt.getIndex()) instanceof WorkflowEngineProxy) {
                WorkflowEngineProxy engineProxy = (WorkflowEngineProxy)engines.get(elmt.getIndex());
                this.synchronizationAllComponents((List<Element>)((Workflow)elmt).getElements(), (List<WorkflowEngine>)engineProxy.getTargetEngine().getEngines());
                continue;
            }
            if (engines.get(elmt.getIndex()).getEngines().size() <= 0) continue;
            this.synchronizationAllComponents((List<Element>)((Workflow)elmt).getElements(), (List<WorkflowEngine>)engines.get(elmt.getIndex()).getEngines());
        }
    }

    private void renameWorkflow(String newName) {
        ((WorkflowComponent)this.workflow.getComponents().get(0)).setName(newName);
    }
}

