/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.Constants;
import org.eclipse.gmt.modisco.workflow.controller.ControllerDriverPage;
import org.eclipse.gmt.modisco.workflow.controller.ControllerWorkflowTransformation;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.TableItem;

/**
 * This class defines a generic wizard. It contains different page according to
 * the mode in which it is called
 * 
 * @author Nicolas Payneau
 */
public class DriversWizard extends Wizard {

	private DriverPage driver;
	private LoadLauncherPage loadLauncher;
	private ControllerDriverPage controllerDriverpage;
	private ControllerWorkflowTransformation controllerWorkflow;
	private Constants mode;

	/**
	 * Class constructor
	 * 
	 * @param controllerWorkflow
	 *            The controller managing the workflow
	 * @param controllerDriverpage
	 *            The controller managing the display
	 * @param mode
	 *            Opening mode of wizard (add or edit or load)
	 */
	public DriversWizard(
			final ControllerWorkflowTransformation controllerWorkflow,
			final ControllerDriverPage controllerDriverpage,
			final Constants mode) {
		this.controllerWorkflow = controllerWorkflow;
		this.mode = mode;
		this.controllerDriverpage = controllerDriverpage;
		if (mode.equals(Constants.addMode)) {
			this.setWindowTitle(Messages.DriversWizard_0);
		} else if (mode.equals(Constants.editMode)) {
			this.setWindowTitle(Messages.DriversWizard_1);
		} else {
			this.setWindowTitle(Messages.DriversWizard_2);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.wizard.Wizard#addPages()
	 */
	@Override
	public final void addPages() {
		this.driver = new DriverPage(Messages.DriversWizard_3, this.mode,
				this.controllerWorkflow.getGroup());
		this.driver.setController(this.controllerDriverpage);
		if (this.mode.equals(Constants.addMode)) {
			this.addPage(new ListDriversPage(Messages.DriversWizard_4,
					this.controllerDriverpage));
		}
		if (this.mode.equals(Constants.loadMode)) {
			this.loadLauncher = new LoadLauncherPage(Messages.DriversWizard_5,
					this.controllerDriverpage);
			this.addPage(this.loadLauncher);
		}
		if (!this.mode.equals(Constants.loadMode)) {
			this.addPage(this.driver);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.wizard.Wizard#performFinish()
	 */
	@Override
	public boolean performFinish() {
		if (this.mode.equals(Constants.addMode)) {
			this.controllerDriverpage.launchPerformFinish();
			this.controllerWorkflow.addElement(this.controllerDriverpage
					.getCurrentDriver().getTypeLaunchConfig(), -1, this.driver
					.getTransformationName(), true);
		} else if (this.mode.equals(Constants.editMode)) {
			this.controllerDriverpage.launchPerformFinish();
			this.controllerWorkflow.performFinishEditTransformation(this.driver
					.getTransformationName());
		} else if (this.mode.equals(Constants.loadMode)) {
			try {
				for (TableItem item : this.loadLauncher.getItemsSelected()) {
					ILaunchConfiguration launchConfiguration = this.loadLauncher
					.getLaunchConfigurationMap().get(item);
					
					this.controllerWorkflow.addElement(launchConfiguration.getType()
							.getIdentifier(), -1, item.getText(), true);
				}
			} catch (CoreException e) {
				MoDiscoLogger.logError(e, Activator.getDefault());
			}
		}
		return true;
	}
}
