/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.util;

import java.io.IOException;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.osgi.service.prefs.BackingStoreException;

public class PluginPreferenceStore
implements IPersistentPreferenceStore {
    private String ownerPlugingId;
    private IEclipsePreferences instancePreferences;
    private IEclipsePreferences defaultPreferences;
    private ListenerList listeners = new ListenerList();
    private boolean silentRunning = false;

    public PluginPreferenceStore(String string) {
        this.ownerPlugingId = string;
        this.instancePreferences = new InstanceScope().getNode(this.ownerPlugingId);
        this.defaultPreferences = new DefaultScope().getNode(this.ownerPlugingId);
        this.instancePreferences.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent preferenceChangeEvent) {
                if (!PluginPreferenceStore.this.silentRunning) {
                    PluginPreferenceStore.this.firePropertyChangeEvent(preferenceChangeEvent.getKey(), preferenceChangeEvent.getOldValue(), preferenceChangeEvent.getNewValue());
                }
            }
        });
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.add((Object)iPropertyChangeListener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.remove((Object)iPropertyChangeListener);
    }

    public void firePropertyChangeEvent(String string, Object object, Object object2) {
        if (this.listeners.isEmpty()) {
            return;
        }
        Object[] objectArray = this.listeners.getListeners();
        final PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, string, object, object2);
        int n = 0;
        while (n < objectArray.length) {
            final IPropertyChangeListener iPropertyChangeListener = (IPropertyChangeListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new SafeRunnable("Preference Change Error"){

                public void run() {
                    iPropertyChangeListener.propertyChange(propertyChangeEvent);
                }
            });
            ++n;
        }
    }

    public boolean contains(String string) {
        return this.containsKey(this.instancePreferences, string);
    }

    private boolean containsKey(IEclipsePreferences iEclipsePreferences, String string) {
        String[] stringArray;
        if (string == null) {
            return false;
        }
        try {
            stringArray = iEclipsePreferences.keys();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
            return false;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string.equals(string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean getBoolean(String string) {
        if (this.containsKey(this.instancePreferences, string)) {
            return this.instancePreferences.getBoolean(string, false);
        }
        return this.getDefaultBoolean(string);
    }

    public boolean getDefaultBoolean(String string) {
        return this.defaultPreferences.getBoolean(string, false);
    }

    public double getDefaultDouble(String string) {
        return this.defaultPreferences.getDouble(string, 0.0);
    }

    public float getDefaultFloat(String string) {
        return this.defaultPreferences.getFloat(string, 0.0f);
    }

    public int getDefaultInt(String string) {
        return this.defaultPreferences.getInt(string, 0);
    }

    public long getDefaultLong(String string) {
        return this.defaultPreferences.getLong(string, 0L);
    }

    public String getDefaultString(String string) {
        return this.defaultPreferences.get(string, "");
    }

    public double getDouble(String string) {
        if (this.containsKey(this.instancePreferences, string)) {
            return this.instancePreferences.getDouble(string, 0.0);
        }
        return this.getDefaultDouble(string);
    }

    public float getFloat(String string) {
        if (this.containsKey(this.instancePreferences, string)) {
            return this.instancePreferences.getFloat(string, 0.0f);
        }
        return this.getDefaultFloat(string);
    }

    public int getInt(String string) {
        if (this.containsKey(this.instancePreferences, string)) {
            return this.instancePreferences.getInt(string, 0);
        }
        return this.getDefaultInt(string);
    }

    public long getLong(String string) {
        if (this.containsKey(this.instancePreferences, string)) {
            return this.instancePreferences.getLong(string, 0L);
        }
        return this.getDefaultLong(string);
    }

    public String getString(String string) {
        if (this.containsKey(this.instancePreferences, string)) {
            return this.instancePreferences.get(string, "");
        }
        return this.getDefaultString(string);
    }

    public boolean isDefault(String string) {
        return !this.containsKey(this.instancePreferences, string);
    }

    public boolean needsSaving() {
        if (this.instancePreferences instanceof EclipsePreferences) {
            return ((EclipsePreferences)this.instancePreferences).isDirty();
        }
        return false;
    }

    public void putValue(String string, String string2) {
        try {
            this.silentRunning = true;
            this.instancePreferences.put(string, string2);
        }
        finally {
            this.silentRunning = false;
        }
    }

    public void setDefault(String string, double d) {
        this.defaultPreferences.putDouble(string, d);
    }

    public void setDefault(String string, float f) {
        this.defaultPreferences.putFloat(string, f);
    }

    public void setDefault(String string, int n) {
        this.defaultPreferences.putInt(string, n);
    }

    public void setDefault(String string, long l) {
        this.defaultPreferences.putLong(string, l);
    }

    public void setDefault(String string, String string2) {
        this.defaultPreferences.put(string, string2);
    }

    public void setDefault(String string, boolean bl) {
        this.defaultPreferences.putBoolean(string, bl);
    }

    public void setToDefault(String string) {
        this.instancePreferences.remove(string);
    }

    public void setValue(String string, double d) {
        this.instancePreferences.putDouble(string, d);
    }

    public void setValue(String string, float f) {
        this.instancePreferences.putFloat(string, f);
    }

    public void setValue(String string, int n) {
        this.instancePreferences.putInt(string, n);
    }

    public void setValue(String string, long l) {
        this.instancePreferences.putLong(string, l);
    }

    public void setValue(String string, String string2) {
        this.instancePreferences.put(string, string2);
    }

    public void setValue(String string, boolean bl) {
        this.instancePreferences.putBoolean(string, bl);
    }

    public void save() throws IOException {
        try {
            this.instancePreferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            IOException iOException = new IOException(backingStoreException.getMessage());
            iOException.setStackTrace(backingStoreException.getStackTrace());
            iOException.initCause(backingStoreException.getCause());
            throw iOException;
        }
    }
}

