/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.internal.JavaMEClasspathContainer;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.device.DeviceRegistry;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.persistence.PersistenceException;

public class JavaMEClasspathContainerInitializer
extends ClasspathContainerInitializer {
    private static Map<IDevice, JavaMEClasspathContainer> containers = new HashMap<IDevice, JavaMEClasspathContainer>();

    public void initialize(IPath iPath, IJavaProject iJavaProject) throws CoreException {
        String string = iPath.segment(1);
        String string2 = iPath.segment(2);
        try {
            IDevice iDevice = DeviceRegistry.singleton.getDevice(string, string2);
            JavaMEClasspathContainer javaMEClasspathContainer = containers.get(iDevice);
            if (javaMEClasspathContainer == null) {
                javaMEClasspathContainer = new JavaMEClasspathContainer(iPath, iDevice);
                containers.put(iDevice, javaMEClasspathContainer);
            }
            JavaCore.setClasspathContainer((IPath)iPath, (IJavaProject[])new IJavaProject[]{iJavaProject}, (IClasspathContainer[])new IClasspathContainer[]{javaMEClasspathContainer}, null);
        }
        catch (PersistenceException persistenceException) {
            MTJCorePlugin.log(4, "Could not load JavaMEClasspath, device " + string + "/" + string2 + "not found.", persistenceException);
        }
    }
}

