/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.persistence;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.utils.XMLUtils;
import org.eclipse.mtj.core.model.Version;
import org.eclipse.mtj.core.persistence.IBundleReferencePersistable;
import org.eclipse.mtj.core.persistence.IPersistable;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPersistenceProvider
implements IPersistenceProvider {
    private int identifier;
    private Element element;
    private Stack<Bundle> bundleStack;
    private Map<Object, Object> referenceMap;
    private Map<String, String> bundleMappings;

    public XMLPersistenceProvider(String string) throws PersistenceException {
        this(XMLPersistenceProvider.createRootElement(string));
    }

    public XMLPersistenceProvider(Document document) {
        this(document.getDocumentElement());
    }

    public XMLPersistenceProvider(Element element) {
        this.element = element;
        this.bundleStack = new Stack();
        this.referenceMap = new HashMap<Object, Object>();
        this.bundleMappings = new HashMap<String, String>();
        this.bundleMappings.put("org.eclipse.mtj.toolkit.nokia", "org.eclipse.mtj.toolkit.uei");
        this.bundleMappings.put("org.eclipse.mtj.toolkit.sonyericsson", "org.eclipse.mtj.toolkit.uei");
        this.bundleMappings.put("org.eclipse.mtj.toolkit.sprint", "org.eclipse.mtj.toolkit.uei");
        this.bundleMappings.put("org.eclipse.mtj.toolkit.sun", "org.eclipse.mtj.toolkit.uei");
    }

    public Document getDocument() {
        return this.element.getOwnerDocument();
    }

    @Override
    public boolean loadBoolean(String string) throws PersistenceException {
        String string2 = this.loadString(string);
        return string2 == null ? false : "true".equalsIgnoreCase(string2);
    }

    @Override
    public int loadInteger(String string) throws PersistenceException {
        String string2 = this.loadString(string);
        return string2 == null ? 0 : Integer.parseInt(string2);
    }

    @Override
    public IPersistable loadPersistable(String string) throws PersistenceException {
        IPersistable iPersistable = null;
        Element element = this.getNamedElement(string);
        if (element != null) {
            boolean bl = this.pushNewBundle(element);
            iPersistable = this.createPersistableInstance(element);
            if (iPersistable != null) {
                Object object;
                Object object2;
                this.element = element;
                if (iPersistable instanceof IBundleReferencePersistable && (object2 = this.getCurrentBundle()) != null) {
                    object = (IBundleReferencePersistable)iPersistable;
                    object.setBundle(object2.getSymbolicName());
                }
                iPersistable.loadUsing(this);
                object2 = element.getAttribute("id");
                object = Integer.valueOf((String)object2);
                this.referenceMap.put(object, iPersistable);
                this.element = (Element)this.element.getParentNode();
            }
            if (bl) {
                this.bundleStack.pop();
            }
        }
        return iPersistable;
    }

    @Override
    public Properties loadProperties(String string) throws PersistenceException {
        Properties properties = null;
        Element element = this.getNamedElement(string);
        if (element != null) {
            properties = new Properties();
            NodeList nodeList = element.getElementsByTagName("property");
            int n = 0;
            while (n < nodeList.getLength()) {
                Element element2 = (Element)nodeList.item(n);
                String string2 = element2.getAttribute("key");
                String string3 = element2.getAttribute("value");
                properties.setProperty(string2, string3);
                ++n;
            }
        }
        return properties;
    }

    @Override
    public Object loadReference(String string) throws PersistenceException {
        Object object = null;
        Element element = this.getNamedElement(string);
        if (element != null) {
            try {
                String string2 = element.getAttribute("refid");
                Integer n = Integer.valueOf(string2);
                object = this.referenceMap.get(n);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return object;
    }

    @Override
    public String loadString(String string) throws PersistenceException {
        Element element = this.getNamedElement(string);
        return element == null ? null : element.getAttribute("value");
    }

    @Override
    public void storeBoolean(String string, boolean bl) throws PersistenceException {
        this.storeString(string, Boolean.toString(bl));
    }

    @Override
    public void storeInteger(String string, int n) throws PersistenceException {
        this.storeString(string, Integer.toString(n));
    }

    @Override
    public void storePersistable(String string, IPersistable iPersistable) throws PersistenceException {
        if (iPersistable != null) {
            Object object;
            this.element = XMLUtils.createChild(this.element, string);
            if (iPersistable instanceof IBundleReferencePersistable && (object = ((IBundleReferencePersistable)iPersistable).getBundle()) != null) {
                this.element.setAttribute("bundle", (String)object);
            }
            this.element.setAttribute("class", iPersistable.getClass().getName());
            object = this.identifier++;
            this.element.setAttribute("id", ((Integer)object).toString());
            this.referenceMap.put(iPersistable, object);
            iPersistable.storeUsing(this);
            this.element = (Element)this.element.getParentNode();
        }
    }

    @Override
    public void storeProperties(String string, Properties properties) throws PersistenceException {
        if (properties != null) {
            Element element = XMLUtils.createChild(this.element, string);
            Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Element element2 = XMLUtils.createChild(element, "property");
                Map.Entry<Object, Object> entry = iterator.next();
                element2.setAttribute("key", entry.getKey().toString());
                element2.setAttribute("value", entry.getValue().toString());
            }
        }
    }

    @Override
    public void storeReference(String string, Object object) throws PersistenceException {
        Integer n = (Integer)this.referenceMap.get(object);
        if (n != null) {
            Element element = XMLUtils.createChild(this.element, string);
            element.setAttribute("refid", n.toString());
        }
    }

    @Override
    public void storeString(String string, String string2) throws PersistenceException {
        if (string2 != null) {
            Element element = XMLUtils.createChild(this.element, string);
            element.setAttribute("value", string2);
        }
    }

    private static Element createRootElement(String string) throws PersistenceException {
        String string2 = MTJCorePlugin.getPluginVersion();
        Version version = new Version(string2);
        Element element = null;
        try {
            element = XMLUtils.createRootElement(string, version);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new PersistenceException(parserConfigurationException.getMessage(), parserConfigurationException);
        }
        return element;
    }

    private IPersistable createPersistableInstance(Element element) throws PersistenceException {
        IPersistable iPersistable = null;
        String string = element.getAttribute("class");
        try {
            Class<?> clazz = this.loadClass(string);
            if (clazz != null) {
                iPersistable = (IPersistable)clazz.newInstance();
            }
        }
        catch (InstantiationException instantiationException) {
            throw new PersistenceException("InstantiationException: " + instantiationException.getMessage(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PersistenceException("IllegalAccessException: " + illegalAccessException.getMessage(), illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PersistenceException("ClassNotFoundException: " + classNotFoundException.getMessage(), classNotFoundException);
        }
        return iPersistable;
    }

    private Bundle getCurrentBundle() {
        Bundle bundle = null;
        if (!this.bundleStack.isEmpty()) {
            bundle = this.bundleStack.peek();
        }
        return bundle;
    }

    private Element getNamedElement(String string) {
        Element element = null;
        NodeList nodeList = this.element.getElementsByTagName(string);
        int n = 0;
        while (element == null && n < nodeList.getLength()) {
            Element element2 = (Element)nodeList.item(n);
            if (element2.getParentNode().equals(this.element)) {
                element = element2;
            }
            ++n;
        }
        return element;
    }

    private Class<?> loadClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        Bundle bundle = this.getCurrentBundle();
        clazz = bundle != null ? bundle.loadClass(string) : this.getClass().getClassLoader().loadClass(string);
        return clazz;
    }

    private boolean pushNewBundle(Element element) {
        boolean bl = false;
        String string = element.getAttribute("bundle");
        if (string != null && string.length() > 0) {
            Bundle bundle;
            String string2 = this.bundleMappings.get(string);
            if (string2 != null) {
                string = string2;
            }
            if ((bundle = Platform.getBundle((String)string)) != null) {
                this.bundleStack.push(bundle);
                bl = true;
            }
        }
        return bl;
    }
}

