/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.utils;

import java.io.File;
import java.io.IOException;
import org.eclipse.mtj.core.internal.utils.Utils;

public class TemporaryFileManager {
    public static final TemporaryFileManager instance = new TemporaryFileManager();
    private File mtjTempFolder;

    private TemporaryFileManager() {
    }

    public File createTempDirectory(String string, String string2) throws IOException {
        return this.createTempDirectory(string, string2, this.getMTJTempFolder());
    }

    public synchronized File createTempDirectory(String string, String string2, File file) throws IOException {
        File file2 = File.createTempFile(string, string2, file);
        file2.delete();
        file2.mkdir();
        return file2;
    }

    public File createTempFile(String string, String string2) throws IOException {
        return this.createTempFile(string, string2, this.getMTJTempFolder());
    }

    public synchronized File createTempFile(String string, String string2, File file) throws IOException {
        File file2 = File.createTempFile(string, string2, file);
        file2.deleteOnExit();
        return file2;
    }

    private File getMTJTempFolder() {
        if (this.mtjTempFolder == null) {
            String string = System.getProperty("user.name", "").replace(' ', '_');
            this.mtjTempFolder = new File(this.getSystemTempFolder(), "_mtj.tmp" + string);
            if (this.mtjTempFolder.exists()) {
                if (this.shouldClearTempFolderOnStartup()) {
                    Utils.delete(this.mtjTempFolder);
                    this.mtjTempFolder.mkdirs();
                }
            } else {
                this.mtjTempFolder.mkdirs();
            }
        }
        return this.mtjTempFolder;
    }

    private File getSystemTempFolder() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    private boolean shouldClearTempFolderOnStartup() {
        return System.getProperty("mtj.cleartemp", "true").equalsIgnoreCase("true");
    }
}

