/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.device.editor;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.internal.device.editor.AbstractDeviceEditorPage;
import org.eclipse.mtj.ui.viewers.TableColumnInfo;
import org.eclipse.mtj.ui.viewers.TableViewerConfiguration;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class DevicePropertiesEditorPage
extends AbstractDeviceEditorPage {
    private static final Object[] NO_ELEMENTS = new Object[0];
    private static final int DEFAULT_TABLE_WIDTH = 650;
    private static final TableColumnInfo[] COLUMN_INFO = new TableColumnInfo[]{new TableColumnInfo("Property", 40.0f, null), new TableColumnInfo("Value", 60.0f, null)};
    private TableViewer viewer;

    public DevicePropertiesEditorPage(Composite composite, int n) {
        super(composite, n);
    }

    public void commitDeviceChanges() {
    }

    public String getDescription() {
        return "View the properties defined for the device";
    }

    public String getTitle() {
        return "Properties";
    }

    public void setDevice(IDevice iDevice) {
        super.setDevice(iDevice);
        this.viewer.setInput((Object)iDevice);
    }

    protected void addPageControls(Composite composite) {
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        gridData.minimumWidth = 650;
        gridData.heightHint = 400;
        this.viewer = this.createTableViewer(composite);
        this.viewer.getTable().setLayoutData((Object)gridData);
    }

    private TableViewer createTableViewer(Composite composite) {
        int n = 68100;
        Table table = new Table(composite, n);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setContentProvider((IContentProvider)new DevicePropertiesContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new PropertyLabelProvider());
        IDialogSettings iDialogSettings = MTJUIPlugin.getDialogSettings("devicePropertiesViewerSettings");
        TableViewerConfiguration tableViewerConfiguration = new TableViewerConfiguration(iDialogSettings, 650, COLUMN_INFO, 0);
        tableViewerConfiguration.configure(tableViewer);
        return tableViewer;
    }

    private static class DevicePropertiesContentProvider
    implements IStructuredContentProvider {
        private DevicePropertiesContentProvider() {
        }

        public Object[] getElements(Object object) {
            IDevice iDevice;
            Properties properties;
            Object[] objectArray = NO_ELEMENTS;
            if (object instanceof IDevice && (properties = (iDevice = (IDevice)object).getDeviceProperties()) != null) {
                Set<Map.Entry<Object, Object>> set = properties.entrySet();
                objectArray = set.toArray(new Map.Entry[set.size()]);
            }
            return objectArray;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private static class PropertyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private PropertyLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            Map.Entry entry = (Map.Entry)object;
            String string = "";
            switch (n) {
                case 0: {
                    string = entry.getKey().toString();
                    break;
                }
                case 1: {
                    string = entry.getValue().toString();
                }
            }
            return string;
        }
    }
}

