/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.editor.jad.form;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.internal.editor.jad.form.JADEditorPageConfigElement;
import org.eclipse.mtj.ui.internal.editor.jad.form.JADSourceEditorPage;
import org.eclipse.mtj.ui.internal.utils.ManifestPreferenceStore;
import org.eclipse.mtj.ui.jadEditor.AbstractJADEditorPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class JADFormEditor
extends FormEditor {
    private static JADEditorPageConfigElement[] jadEditorPageConfigElements;
    private ManifestPreferenceStore preferenceStore;
    private IFile jadFile;
    private long modificationStamp;
    private boolean cleanRequired;
    private List<AbstractJADEditorPage> configPages = new ArrayList<AbstractJADEditorPage>();
    private JADSourceEditorPage editor;

    protected void addPages() {
        super.setPartName(this.jadFile.getProject().getName());
        JADEditorPageConfigElement[] jADEditorPageConfigElementArray = this.getAllEditorPageConfigElements();
        Arrays.sort(jADEditorPageConfigElementArray, new Comparator<JADEditorPageConfigElement>(){

            @Override
            public int compare(JADEditorPageConfigElement jADEditorPageConfigElement, JADEditorPageConfigElement jADEditorPageConfigElement2) {
                return jADEditorPageConfigElement.getPriority() - jADEditorPageConfigElement2.getPriority();
            }
        });
        int n = 0;
        while (n < jADEditorPageConfigElementArray.length) {
            try {
                JADEditorPageConfigElement jADEditorPageConfigElement = jADEditorPageConfigElementArray[n];
                AbstractJADEditorPage abstractJADEditorPage = jADEditorPageConfigElement.getJADEditorPage();
                abstractJADEditorPage.setEditor(this);
                this.addPage((IFormPage)abstractJADEditorPage);
                this.configPages.add(abstractJADEditorPage);
            }
            catch (Exception exception) {
                MTJCorePlugin.log((int)4, (Throwable)exception);
            }
            ++n;
        }
        this.editor = new JADSourceEditorPage(this);
        try {
            this.addPage((IEditorPart)this.editor, super.getEditorInput());
        }
        catch (PartInitException partInitException) {
            MTJCorePlugin.log((int)4, (Throwable)partInitException);
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask("", this.getPageCount() + 1);
        int n = 0;
        for (Object object : this.pages) {
            IFormPage iFormPage;
            if (object instanceof IFormPage && (iFormPage = (IFormPage)object) != null && iFormPage.getPartControl() != null && iFormPage.isDirty()) {
                iFormPage.doSave(iProgressMonitor);
            }
            iProgressMonitor.worked(n + 1);
        }
        try {
            if (this.jadFile.exists() && this.jadFile.isReadOnly()) {
                Object object;
                object = this.jadFile.getResourceAttributes();
                object.setReadOnly(false);
                this.jadFile.setResourceAttributes(object);
            }
            this.preferenceStore.save();
            if (this.jadFile != null && this.jadFile.exists()) {
                this.jadFile.refreshLocal(0, iProgressMonitor);
            }
            if (this.jadFile != null && this.cleanRequired) {
                this.jadFile.getProject().build(15, iProgressMonitor);
            }
        }
        catch (IOException iOException) {
            MTJCorePlugin.log((int)4, (Throwable)iOException);
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)4, (Throwable)coreException);
        }
        iProgressMonitor.done();
        this.editorDirtyStateChanged();
    }

    public void doSaveAs() {
    }

    private JADEditorPageConfigElement[] getAllEditorPageConfigElements() {
        if (jadEditorPageConfigElements == null) {
            jadEditorPageConfigElements = this.readAllVendorSpecJADAttributes();
        }
        return jadEditorPageConfigElements;
    }

    IFile getJadFile() {
        return this.jadFile;
    }

    private File getLocalFile() {
        return this.jadFile.getLocation().toFile();
    }

    public ManifestPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public void gotoMarker(IMarker iMarker) {
    }

    public boolean isDirty() {
        boolean bl = false;
        for (Object e : this.pages) {
            IFormPage iFormPage;
            if (!(e instanceof IFormPage) || (iFormPage = (IFormPage)e) == null || iFormPage.getPartControl() == null || !iFormPage.isDirty()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    boolean isUserDefinedPropertyKey(String string) {
        for (AbstractJADEditorPage abstractJADEditorPage : this.configPages) {
            if (abstractJADEditorPage == null || !abstractJADEditorPage.isManagingProperty(string)) continue;
            return false;
        }
        return true;
    }

    private JADEditorPageConfigElement[] readAllVendorSpecJADAttributes() {
        String string = MTJUIPlugin.getDefault().getBundle().getSymbolicName();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(string, "jadEditorPages");
        JADEditorPageConfigElement[] jADEditorPageConfigElementArray = new JADEditorPageConfigElement[iConfigurationElementArray.length];
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            jADEditorPageConfigElementArray[n] = new JADEditorPageConfigElement(iConfigurationElementArray[n]);
            ++n;
        }
        return jADEditorPageConfigElementArray;
    }

    void setCleanRequired(boolean bl) {
        this.cleanRequired = bl;
    }

    public void setFocus() {
        File file = this.getLocalFile();
        if (file != null && file.lastModified() > this.modificationStamp && this.shouldReloadFile()) {
            this.updateEditorInput();
            for (AbstractJADEditorPage abstractJADEditorPage : this.configPages) {
                if (abstractJADEditorPage == null) continue;
                abstractJADEditorPage.editorInputChanged();
            }
        }
        super.setFocus();
    }

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        if (iEditorInput instanceof IStorageEditorInput) {
            IStorageEditorInput iStorageEditorInput = (IStorageEditorInput)iEditorInput;
            try {
                IPath iPath = iStorageEditorInput.getStorage().getFullPath();
                if (iPath != null) {
                    IWorkspaceRoot iWorkspaceRoot = MTJCorePlugin.getWorkspace().getRoot();
                    this.jadFile = iWorkspaceRoot.getFile(iPath.makeAbsolute());
                    if (this.jadFile != null && this.jadFile.exists()) {
                        this.updateEditorInput();
                    }
                }
            }
            catch (Exception exception) {
                MTJCorePlugin.log((int)2, (Throwable)exception);
            }
        }
    }

    private boolean shouldReloadFile() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"File Updated", (String)"The file has been updated.  Would you like to reload?");
    }

    private void updateEditorInput() {
        File file = this.getLocalFile();
        this.modificationStamp = file.lastModified();
        String string = file.toString();
        this.preferenceStore = new ManifestPreferenceStore(string);
        try {
            this.preferenceStore.load();
        }
        catch (IOException iOException) {
            MTJCorePlugin.log((int)2, (Throwable)iOException);
        }
    }
}

