/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.editor.jad.source.contentassist;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class JADAttributeCompletionProposal
implements ICompletionProposal {
    protected String replacementString;
    protected Image image;
    protected String displayString;
    protected int startOffset;
    protected int length;

    public JADAttributeCompletionProposal(String string, Image image, String string2) {
        this(string, image, string2, 0, 0);
    }

    public JADAttributeCompletionProposal(String string, Image image, String string2, int n, int n2) {
        Assert.isNotNull((Object)string);
        this.replacementString = string;
        this.image = image;
        this.displayString = string2;
        this.startOffset = n;
        this.length = n2;
    }

    public void apply(IDocument iDocument) {
        if (this.length == -1) {
            String string = iDocument.get();
            this.length = string.length();
        }
        try {
            iDocument.replace(this.startOffset, this.length, this.replacementString);
        }
        catch (BadLocationException badLocationException) {}
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public Image getImage() {
        return this.image;
    }

    public Point getSelection(IDocument iDocument) {
        if (this.replacementString.equals("\"\"")) {
            return new Point(this.startOffset + 1, 0);
        }
        return new Point(this.startOffset + this.replacementString.length(), 0);
    }
}

