/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.wizards.project.page;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.device.DeviceRegistry;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.project.impl.MidletSuiteProject;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.ui.MTJUIStrings;
import org.eclipse.mtj.ui.devices.DeviceSelector;
import org.eclipse.mtj.ui.internal.wizards.project.NewMIDLetProjectWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewMidletProjectPropertiesPage
extends WizardPage {
    public static final String PAGE_NAME = "NewMidletProjectProperties";
    private DeviceSelector deviceSelector;
    private Text jadFileNameText;
    private boolean jadNameInitialized;
    private int deviceCount = 0;

    public NewMidletProjectPropertiesPage() {
        super(PAGE_NAME);
        this.setTitle(MTJUIStrings.getString("wiz.newproj.properties.title"));
        this.setDescription(MTJUIStrings.getString("wiz.newproj.properties.description"));
        this.deviceCount = this.getDeviceCount();
    }

    public void createControl(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(font);
        this.setControl((Control)composite2);
        this.initializeDialogUnits((Control)composite);
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite2.setLayoutData((Object)new GridData(1808));
        this.deviceSelector = new DeviceSelector();
        this.deviceSelector.createContents(composite2, true);
        this.deviceSelector.setSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                NewMidletProjectPropertiesPage.this.updateStatus();
            }
        });
        new Label(composite2, 0).setText("Application Descriptor:");
        this.jadFileNameText = new Text(composite2, 2048);
        this.jadFileNameText.setLayoutData((Object)new GridData(768));
        this.jadFileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewMidletProjectPropertiesPage.this.updateStatus();
            }
        });
        this.updateStatus();
    }

    public void dispose() {
        this.deviceSelector.dispose();
        super.dispose();
    }

    public IDevice getSelectedDevice() {
        return this.deviceSelector.getSelectedDevice();
    }

    public String getJadFileName() {
        return this.jadFileNameText.getText();
    }

    public void setVisible(boolean bl) {
        if (bl && !this.jadNameInitialized) {
            this.jadFileNameText.setText(this.getDefaultJadName());
            this.jadNameInitialized = true;
        }
        super.setVisible(bl);
    }

    public boolean isPageComplete() {
        return this.isValidDeviceCount() && this.isValidDeviceSelection() && this.isValidJadName();
    }

    private String getDefaultJadName() {
        IProject iProject = ((NewMIDLetProjectWizard)this.getWizard()).getCreatedProjectHandle();
        return MidletSuiteProject.getDefaultJadFileName((IProject)iProject);
    }

    private void updateStatus() {
        String string = null;
        this.deviceCount = this.getDeviceCount();
        if (!this.isValidDeviceCount()) {
            string = "There are no devices defined.\n Please use device management to create some devices.\n";
        } else if (!this.isValidDeviceSelection()) {
            string = "No Device Selected\n";
        } else if (!this.isValidJadName()) {
            string = "Invalid JAD name.";
        }
        this.setErrorMessage(string);
        if (string == null) {
            this.setPageComplete(true);
            ((NewMIDLetProjectWizard)this.getWizard()).setProjectDevice(this.getSelectedDevice());
        } else {
            this.setPageComplete(false);
        }
    }

    private int getDeviceCount() {
        int n = 0;
        DeviceRegistry deviceRegistry = DeviceRegistry.singleton;
        try {
            n = deviceRegistry.getDeviceCount();
        }
        catch (PersistenceException persistenceException) {
            MTJCorePlugin.log((int)2, (String)"Error retrieving device count", (Throwable)persistenceException);
        }
        return n;
    }

    private boolean isValidJadName() {
        String string = this.getJadFileName();
        boolean bl = false;
        if (string != null && string.length() > 0 && string.charAt(0) != '/' && string.charAt(0) != '\\' && string.endsWith(".jad")) {
            bl = true;
        }
        return bl;
    }

    private boolean isValidDeviceCount() {
        return this.deviceCount > 0;
    }

    private boolean isValidDeviceSelection() {
        return this.getSelectedDevice() != null;
    }
}

