/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.toolkit.uei;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.mtj.core.model.LaunchEnvironment;
import org.eclipse.mtj.core.model.ReplaceableParametersProcessor;
import org.eclipse.mtj.core.model.device.IDevice2;
import org.eclipse.mtj.core.model.device.impl.AbstractDevice;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;

public class UEIDevice
extends AbstractDevice
implements IDevice2 {
    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof UEIDevice) {
            bl = this.equals((UEIDevice)((Object)object));
        }
        return bl;
    }

    public boolean equals(UEIDevice uEIDevice) {
        return super.equals((AbstractDevice)uEIDevice) && this.launchCommandTemplate.equals(uEIDevice.launchCommandTemplate);
    }

    public String getLaunchCommand(LaunchEnvironment launchEnvironment, IProgressMonitor iProgressMonitor) throws CoreException {
        Object object;
        String string;
        boolean bl = Platform.getOS().equals("win32");
        IMidletSuiteProject iMidletSuiteProject = launchEnvironment.getMidletSuite();
        ILaunchConfiguration iLaunchConfiguration = launchEnvironment.getLaunchConfiguration();
        boolean bl2 = this.shouldDirectLaunchJAD(iLaunchConfiguration);
        File file = this.copyForLaunch(iMidletSuiteProject, iProgressMonitor, bl2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("executable", bl ? this.executable.getName() : this.executable.getAbsolutePath());
        hashMap.put("device", this.getName());
        if (launchEnvironment.isDebugLaunch()) {
            hashMap.put("debugPort", new Integer(launchEnvironment.getDebugListenerPort()));
        }
        if (!bl2) {
            string = this.getProjectClasspathString(launchEnvironment.getMidletSuite(), file, iProgressMonitor);
            hashMap.put("classpath", string);
        }
        this.addLaunchConfigurationValue(hashMap, "verbose", iLaunchConfiguration, "mtj.verbosity_options");
        this.addLaunchConfigurationValue(hashMap, "heapsize", iLaunchConfiguration, "mtj.heap_size");
        string = iLaunchConfiguration.getAttribute("mtj.security_domain", "None");
        if (!string.equals("None")) {
            hashMap.put("securityDomain", string);
        }
        String string2 = iLaunchConfiguration.getAttribute("mtj.launch_params", "");
        hashMap.put("userSpecifiedArguments", string2);
        if (bl2) {
            hashMap.put("jadfile", this.getSpecifiedJadURL(iLaunchConfiguration));
        } else if (this.shouldDoOTA(iLaunchConfiguration)) {
            object = this.getOTAURL(iLaunchConfiguration, iMidletSuiteProject);
            hashMap.put("otaurl", object);
        } else {
            object = this.getJadForLaunch(iMidletSuiteProject, file, iProgressMonitor);
            if (((File)object).exists()) {
                hashMap.put("jadfile", ((File)object).toString());
            }
            this.addLaunchConfigurationValue(hashMap, "target", iLaunchConfiguration, "mtj.emulated_class");
        }
        object = ReplaceableParametersProcessor.processReplaceableValues((String)this.launchCommandTemplate, hashMap);
        return bl ? "cmd /c " + (String)object : object;
    }

    public File getWorkingDirectory() {
        return this.executable.getParentFile();
    }

    public int hashCode() {
        return this.classpath.hashCode() ^ this.executable.hashCode() ^ this.name.hashCode() ^ this.launchCommandTemplate.hashCode() ^ this.groupName.hashCode();
    }
}

