/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dm.model;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DeviceManagement;
import org.eclipse.mtj.api.extension.DevicePlatformProvider;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.toolkit.ToolkitSupport;
import org.eclipse.mtj.extension.dm.Messages;

public class MtjServiceHandler {
    private static final Logger log = Logger.getLogger(MtjServiceHandler.class.getName());

    public static DevicePlatform[] getDevicePlatforms() {
        try {
            DeviceManagement dm = (DeviceManagement)MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_MANAGEMENT_LITERAL, null, null, true)[0];
            return dm.getDevicePlatforms();
        }
        catch (Exception e) {
            log.log(Level.WARNING, Messages.MtjServiceHandler_CouldNotProvideDevicePlatforms, e);
            return new DevicePlatform[0];
        }
    }

    public static boolean setDevicePlatforms(DevicePlatform[] dps) {
        BasicEList l;
        BasicEMap dppMap = new BasicEMap();
        int i = 0;
        while (i < dps.length) {
            DevicePlatform dp = dps[i];
            DevicePlatformProvider dpp = (DevicePlatformProvider)dp.getDevicePlatformProvider();
            if (!dppMap.containsKey((Object)dpp)) {
                l = new BasicEList();
                l.add((Object)dp);
                dppMap.put((Object)dpp, (Object)l);
            } else {
                l = (EList)dppMap.get((Object)dpp);
                l.add((Object)dp);
            }
            ++i;
        }
        for (Object o : dppMap.keySet()) {
            if (!(o instanceof ToolkitSupport)) continue;
            ToolkitSupport tk = (ToolkitSupport)o;
            l = (EList)dppMap.get((Object)tk);
            DevicePlatform[] dpa = new DevicePlatform[l.size()];
            int i2 = 0;
            while (i2 < l.size()) {
                dpa[i2] = (DevicePlatform)l.get(i2);
                ++i2;
            }
            try {
                tk.setDevicePlatforms(dpa);
            }
            catch (Exception e) {
                log.log(Level.WARNING, Messages.MtjServiceHandler_CouldNotSaveDevicePlatforms, e);
                return false;
            }
        }
        return true;
    }
}

