/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.project.javame;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.enumerations.ProjectType;
import org.eclipse.mtj.api.extension.ProjectExtensionProvider;
import org.eclipse.mtj.api.model.CdcDeployment;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.model.preverifier.IPreverificationPolicy;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.core.project.javame.Messages;
import org.eclipse.mtj.core.ui.util.MidletSearchScope;
import org.eclipse.mtj.core.util.CoreUtil;
import org.eclipse.mtj.core.version.Version;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.MtjDevIdePlugin;
import org.eclipse.mtj.extension.devide.config.LibrarySpecification;

public class JavaMeProjectExtensionProvider
implements ProjectExtensionProvider {
    private static final String DEPLOYMENT_DIRECTORY = "deployed";
    private static final String LAUNCHABLE_CLASSES_FOLDER = "bin";
    private static final String LAUNCHABLE_LIBS_FOLDER = "lib";
    IMtjProject mtjProject = null;

    public ProjectType getProjectType() {
        return ProjectType.PROJECT_TYPE_PERSONAL_PROFILE_LITERAL;
    }

    public Deployment getDeployment(IMtjProject project, String launchableApplication) throws MtjException {
        this.mtjProject = project;
        File jar = this.findFile(project.getProject(), DEPLOYMENT_DIRECTORY, "jar");
        if (jar == null) {
            throw new MtjException(Messages.JavaMeProjectExtensionProvider_JarNotFound);
        }
        File[] files = new File[]{jar};
        CdcDeployment midletDeployment = (CdcDeployment)CoreUtil.createDeployment((File[])files, (DeploymentType)DeploymentType.DEPLOYMENT_TYPE_CDC_LITERAL);
        return midletDeployment;
    }

    public Deployment getDeployment(IMtjProject project) throws MtjException {
        return this.getDeployment(project, null);
    }

    private File findFile(IProject project, String folder2, String fileType) {
        String[] files;
        String folder = project.getLocation().toString();
        final String fType = fileType;
        File f = new File(String.valueOf(folder) + "/" + folder2);
        if (f.exists() && (files = f.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith("." + fType);
            }
        })) != null && files.length > 0) {
            String fol = String.valueOf(folder) + "/" + folder2 + "/" + files[0];
            return new File(fol);
        }
        return null;
    }

    public String getLaunchableClassesFolder(IProgressMonitor monitor) throws CoreException {
        if (this.mtjProject != null) {
            return this.mtjProject.getClassesOutputFolder(monitor).getName();
        }
        return LAUNCHABLE_CLASSES_FOLDER;
    }

    public String getDeploymentFolder(IProgressMonitor monitor) throws CoreException {
        return DEPLOYMENT_DIRECTORY;
    }

    public String getLaunchableLibsFolder(IProgressMonitor monitor) throws CoreException {
        return LAUNCHABLE_LIBS_FOLDER;
    }

    public DeploymentType getDeploymentType() throws MtjException {
        return DeploymentType.DEPLOYMENT_TYPE_CDC_LITERAL;
    }

    public IJavaSearchScope getJavaSearchScope(IJavaProject javaProject) throws MtjException {
        try {
            return new MidletSearchScope(javaProject);
        }
        catch (JavaModelException e) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)5003), (Throwable)e);
        }
    }

    public IPreverificationPolicy getPreverificationPolicy(RuntimePlatformDefinition targetPlatform) throws MtjException {
        return null;
    }

    public void initializeNewProject(IJavaProject javaProject, IProgressMonitor monitor) throws MtjException {
    }

    private String getJarFileName(IJavaProject javaProject) {
        return String.valueOf(this.getProjectNameWithoutSpaces(javaProject)) + ".jar";
    }

    private String getProjectNameWithoutSpaces(IJavaProject javaProject) {
        String projectName = javaProject.getProject().getName();
        return projectName;
    }

    private LibrarySpecification getCorrConfiguration(DeviceConfiguration dc) throws CoreException {
        LibrarySpecification[] lss = MtjDevIdePlugin.getConfigurationSpecifications();
        int i = 0;
        while (i < lss.length) {
            Version v = new Version(dc.getVersion());
            if (lss[i].getVersion().equals(v)) {
                return lss[i];
            }
            ++i;
        }
        return null;
    }

    private LibrarySpecification getCorrProfile(DeviceProfile dp) throws CoreException {
        LibrarySpecification[] lss = MtjDevIdePlugin.getProfileSpecifications();
        int i = 0;
        while (i < lss.length) {
            Version v = new Version(dp.getVersion());
            if (lss[i].getVersion().equals(v)) {
                return lss[i];
            }
            ++i;
        }
        return null;
    }

    public class MtjFile
    extends org.eclipse.core.internal.resources.File {
        public MtjFile(IPath path, Workspace container) {
            super(path, container);
        }

        public IPath getLocation() {
            return this.getLocalManager().locationFor((IResource)this);
        }
    }
}

