/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dplm.ui.dialog;

import java.io.File;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DeploymentProvider;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.model.MidletDeployment;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.mtj.extension.dplm.ui.DeploymentManagementUIMessages;
import org.eclipse.mtj.extension.dplm.ui.DeploymentManagementUIPlugin;
import org.eclipse.mtj.extension.dplm.ui.util.ProvidersContentProvider;
import org.eclipse.mtj.extension.dplm.ui.util.ProvidersLabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class DeploymentManagementDialog
extends TitleAreaDialog {
    private DeploymentManagementDialog dplmDialog = this;
    private String strSelResource = "";
    private Shell shell;
    private Button btnResourceBrowse;
    private Button btnRefresh;
    private Button btnDeploy;
    private Button btnSelectProject;
    private Button btnCancel;
    private Label lblResource;
    private Label lblDescription;
    private Text txtResourceFile;
    private Text txtSelectProject;
    protected Combo cboProtocol;
    private String[] resourceFilterExt = null;
    private CheckboxTreeViewer deviceViewer;
    private ProvidersContentProvider contentProvider = new ProvidersContentProvider();
    private ProvidersLabelProvider labelProvider;
    private Object selectedResource;
    private IJavaProject javaProject;
    private List<Device> selectedDevices = new Vector<Device>();
    private IProgressMonitor monitor = null;
    private MidletDeployment midlet = null;

    public DeploymentManagementDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.labelProvider = new ProvidersLabelProvider();
    }

    protected Control createDialogArea(Composite parent) {
        this.shell = this.getShell();
        Image image = DeploymentManagementUIPlugin.getImageDescriptor("icons/phone.gif").createImage();
        this.shell.setImage(image);
        Composite result = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(result, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setTitle(DeploymentManagementUIMessages.DeploymentManagementDialog_DialogTitle);
        this.setMessage(DeploymentManagementUIMessages.DeploymentManagementDialog_DialogDescription);
        this.setTitleImage(DeploymentManagementUIPlugin.getImageDescriptor("/icons/deploy.gif").createImage());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 12;
        gridLayout.marginWidth = 12;
        container.setLayout((Layout)gridLayout);
        Composite container2 = new Composite(container, 0);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        container2.setLayoutData((Object)gd);
        gridLayout = new GridLayout();
        container2.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 4;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        Label lblProject = new Label(container2, 0);
        lblProject.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Project);
        this.txtSelectProject = new Text(container2, 2048);
        gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 2;
        this.txtSelectProject.setLayoutData((Object)gd);
        this.txtSelectProject.setEditable(false);
        this.txtSelectProject.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        this.btnSelectProject = new Button(container2, 0);
        this.initializeDialogUnits((Control)this.btnSelectProject);
        this.setButtonLayoutData(this.btnSelectProject);
        this.btnSelectProject.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Browse);
        this.addBtnSelectProjectListeners(this.btnSelectProject);
        this.lblResource = new Label(container2, 0);
        this.lblResource.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Resource);
        this.txtResourceFile = new Text(container2, 2048);
        gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 2;
        this.txtResourceFile.setLayoutData((Object)gd);
        this.txtResourceFile.setEditable(false);
        this.txtResourceFile.setText("");
        this.txtResourceFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeploymentManagementDialog.this.strSelResource = DeploymentManagementDialog.this.txtResourceFile.getText();
            }
        });
        this.btnResourceBrowse = new Button(container2, 0);
        this.initializeDialogUnits((Control)this.btnResourceBrowse);
        this.setButtonLayoutData(this.btnResourceBrowse);
        this.btnResourceBrowse.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Browse);
        this.btnResourceBrowse.addSelectionListener((SelectionListener)new OpenResource());
        Group grpDevices = new Group(container, 0);
        grpDevices.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Devices);
        gd = new GridData(4, 4, true, true);
        grpDevices.setLayoutData((Object)gd);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        grpDevices.setLayout((Layout)gridLayout);
        Composite deviceTreeArea = new Composite((Composite)grpDevices, 0);
        FillLayout layout2 = new FillLayout();
        deviceTreeArea.setLayout((Layout)layout2);
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        gd.widthHint = 300;
        deviceTreeArea.setLayoutData((Object)gd);
        this.deviceViewer = new CheckboxTreeViewer(deviceTreeArea);
        this.addDeviceViewerListeners(this.deviceViewer);
        Label label = new Label((Composite)grpDevices, 0);
        gd = new GridData(4, 4, true, false);
        label.setLayoutData((Object)gd);
        this.btnRefresh = new Button((Composite)grpDevices, 0);
        this.initializeDialogUnits((Control)this.btnRefresh);
        this.setButtonLayoutData(this.btnRefresh);
        this.btnRefresh.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Refresh);
        this.addBtnRefreshListeners(this.btnRefresh);
        Group grpDescription = new Group(container, 0);
        grpDescription.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Description);
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 1;
        gd.heightHint = 200;
        grpDescription.setLayoutData((Object)gd);
        gridLayout = new GridLayout();
        grpDescription.setLayout((Layout)gridLayout);
        this.lblDescription = new Label((Composite)grpDescription, 64);
        gd = new GridData(4, 4, true, true);
        gd.widthHint = 200;
        this.lblDescription.setLayoutData((Object)gd);
        Label separator = new Label(result, 258);
        gd = new GridData(4, 1024, true, false);
        separator.setLayoutData((Object)gd);
        this.deviceViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.deviceViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        Vector<DeploymentProvider> providersList = new Vector<DeploymentProvider>();
        MtjExtension[] providers = MtjServices.getInstance().getImplementations(ExtensionType.DEPLOYMENT_PROVIDER_LITERAL, null, null, true);
        int i = 0;
        while (i < providers.length) {
            providersList.add((DeploymentProvider)providers[i]);
            ++i;
        }
        this.deviceViewer.setInput(providersList);
        return result;
    }

    private void addBtnSelectProjectListeners(Button btnSelectProject) {
        btnSelectProject.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentManagementDialog.this.javaProject = DeploymentManagementDialog.this.selectProject();
                if (DeploymentManagementDialog.this.javaProject != null) {
                    DeploymentManagementDialog.this.setResourceFields(DeploymentManagementDialog.this.javaProject);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private IJavaProject selectProject() {
        Object[] projects;
        try {
            projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            projects = new IJavaProject[]{};
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(DeploymentManagementUIMessages.DeploymentManagementDialog_ProjectSelection);
        dialog.setMessage(DeploymentManagementUIMessages.DeploymentManagementDialog_ChooseTheProject);
        dialog.setElements(projects);
        dialog.setInitialSelections(new Object[]{this.javaProject});
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    private void setResourceFields(Object selectedResource) {
        IMtjProject mtjProject = null;
        if (selectedResource instanceof IJavaProject) {
            try {
                this.javaProject = (IJavaProject)selectedResource;
                mtjProject = MtjProject.getMtjProject((IJavaProject)this.javaProject);
            }
            catch (MtjException e) {
                e.printStackTrace();
            }
            this.updatefields(mtjProject);
        } else if (selectedResource instanceof IResource) {
            IResource resource = (IResource)selectedResource;
            IProject container = resource.getProject();
            this.javaProject = JavaCore.create((IProject)container);
            if (this.javaProject != null) {
                try {
                    mtjProject = MtjProject.getMtjProject((IJavaProject)this.javaProject);
                }
                catch (MtjException e) {
                    e.printStackTrace();
                }
                this.updatefields(mtjProject);
            }
            this.txtSelectProject.setText(container.getFullPath().toString());
            this.txtResourceFile.setText(resource.getFullPath().toString());
        } else if (selectedResource instanceof IProject) {
            this.txtSelectProject.setText(((IProject)selectedResource).getFullPath().toString());
            this.updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectResourceToDeploy, true);
        } else {
            this.updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_NoProject, true);
        }
    }

    private void updatefields(IMtjProject mtjProject) {
        if (mtjProject != null) {
            this.midlet = null;
            this.updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_DeploysOnDevice, false);
            try {
                this.midlet = (MidletDeployment)mtjProject.getDeployment();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            this.txtSelectProject.setText(mtjProject.getProject().getName());
            if (this.midlet != null) {
                this.txtResourceFile.setText(this.midlet.getJad().getName());
                this.updateDeployButton();
            } else {
                this.txtResourceFile.setText("");
                this.updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectResourceToDeploy, true);
                this.updateDeployButton();
            }
        } else {
            this.updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectedProjectNotMTJ, true);
            this.txtSelectProject.setText(((IJavaProject)this.selectedResource).getPath().toString());
        }
        this.contentProvider.setJavaProject(this.javaProject);
    }

    private void addBtnDeployListeners(Button btnDeploy) {
        btnDeploy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IResource resource;
                if (DeploymentManagementDialog.this.selectedResource instanceof IJavaProject) {
                    if (DeploymentManagementDialog.this.selectedResource != null) {
                        IJavaProject javaProject = (IJavaProject)DeploymentManagementDialog.this.selectedResource;
                        try {
                            Deployment deployment = null;
                            IMtjProject mtjProject = MtjProject.getMtjProject((IJavaProject)javaProject);
                            if (mtjProject == null) {
                                DeploymentManagementDialog.this.dplmDialog.updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectedProjectNotMTJ, true);
                                return;
                            }
                            deployment = mtjProject.getDeployment();
                            MtjExtension[] list = MtjServices.getInstance().getImplementations(ExtensionType.DEPLOYMENT_PROVIDER_LITERAL, null, null, true);
                            DeploymentProvider dplp = (DeploymentProvider)list[0];
                            Object[] checkedElements = DeploymentManagementDialog.this.deviceViewer.getCheckedElements();
                            DeploymentManagementDialog.this.selectedDevices.clear();
                            int i = 0;
                            while (i < checkedElements.length) {
                                Object current = checkedElements[i];
                                if (current instanceof Device) {
                                    DeploymentManagementDialog.this.selectedDevices.add((Device)current);
                                }
                                ++i;
                            }
                            Device[] toDeploy = new Device[DeploymentManagementDialog.this.selectedDevices.size()];
                            Object[] objectDevices = DeploymentManagementDialog.this.selectedDevices.toArray();
                            int i2 = 0;
                            while (i2 < DeploymentManagementDialog.this.selectedDevices.size()) {
                                toDeploy[i2] = (Device)objectDevices[i2];
                                ++i2;
                            }
                            dplp.deploy(deployment, toDeploy, null, DeploymentManagementDialog.this.monitor);
                        }
                        catch (MtjException ex) {
                            ex.printStackTrace();
                        }
                        catch (CoreException cex) {
                            cex.printStackTrace();
                        }
                    } else {
                        DeploymentManagementDialog.this.dplmDialog.updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_NoResourceSelected, true);
                    }
                } else if (DeploymentManagementDialog.this.selectedResource instanceof IResource && !(resource = (IResource)DeploymentManagementDialog.this.selectedResource).getFileExtension().equalsIgnoreCase("jad")) {
                    DeploymentManagementDialog.this.updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_OnlyMidlets, true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addBtnRefreshListeners(Button btnRefresh) {
        btnRefresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentManagementDialog.this.deviceViewer.refresh();
                DeploymentManagementDialog.this.updateDeployButton();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addDeviceViewerListeners(final CheckboxTreeViewer deviceViewer) {
        deviceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    DeploymentManagementDialog.this.lblDescription.setText("");
                    return;
                }
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    StringBuffer toShow = new StringBuffer();
                    for (Object domain : selection) {
                        String value = DeploymentManagementDialog.this.labelProvider.getDescription(domain);
                        toShow.append(value);
                        toShow.append(", ");
                    }
                    if (toShow.length() > 0) {
                        toShow.setLength(toShow.length() - 2);
                    }
                    DeploymentManagementDialog.this.lblDescription.setText(toShow.toString());
                }
                DeploymentManagementDialog.this.updateDeployButton();
            }
        });
        deviceViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object selection = event.getElement();
                if (selection instanceof DeploymentProvider) {
                    if (event.getChecked()) {
                        deviceViewer.expandToLevel(1);
                        deviceViewer.setSubtreeChecked(selection, true);
                    } else {
                        deviceViewer.setSubtreeChecked(selection, false);
                    }
                } else if (selection instanceof Device) {
                    Device checkedDevice = (Device)selection;
                    if (event.getChecked()) {
                        deviceViewer.setChecked(selection, true);
                        DeploymentManagementDialog.this.selectedDevices.add(checkedDevice);
                    } else {
                        deviceViewer.setParentsGrayed(selection, false);
                        DeploymentManagementDialog.this.selectedDevices.remove(checkedDevice);
                    }
                }
                DeploymentManagementDialog.this.updateDeployButton();
            }
        });
        deviceViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        this.btnDeploy = new Button(parent, 0);
        this.initializeDialogUnits((Control)this.btnDeploy);
        this.setButtonLayoutData(this.btnDeploy);
        this.updateDeployButton();
        this.btnDeploy.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Deploy);
        this.addBtnDeployListeners(this.btnDeploy);
        this.btnCancel = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.btnCancel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentManagementDialog.this.dplmDialog.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public boolean close() {
        return super.close();
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    private void updateStatus(String message, boolean error) {
        if (error) {
            this.setErrorMessage(message);
        } else {
            this.setErrorMessage(null);
            this.setMessage(message);
        }
    }

    private void updateDeployButton() {
        this.btnDeploy.setEnabled(true);
        if (this.midlet == null) {
            this.btnDeploy.setEnabled(false);
        } else if (this.deviceViewer.getSelection().isEmpty()) {
            this.btnDeploy.setEnabled(false);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_DeployResource);
        newShell.setImage(DeploymentManagementUIPlugin.getImageDescriptor("/icons/deploy.gif").createImage());
    }

    protected Object getSelectedResource() {
        IStructuredSelection structuredSelection;
        Object res = null;
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        if (selection != null && selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection) != null) {
            res = structuredSelection.getFirstElement();
        }
        return res;
    }

    protected void cancelPressed() {
        this.close();
    }

    private class OpenResource
    implements SelectionListener {
        private OpenResource() {
        }

        public void widgetSelected(SelectionEvent event) {
            FileDialog fileDialog = new FileDialog(DeploymentManagementDialog.this.shell, 4096);
            fileDialog.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectResourceToBeDeployed);
            fileDialog.setFilterPath(String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString()) + File.separatorChar + DeploymentManagementDialog.this.txtSelectProject.getText());
            fileDialog.setFilterExtensions(DeploymentManagementDialog.this.resourceFilterExt);
            if (DeploymentManagementDialog.this.strSelResource != "") {
                fileDialog.setFileName(DeploymentManagementDialog.this.strSelResource);
            }
            if (fileDialog.open() != null) {
                String separator = "";
                int length = fileDialog.getFilterPath().trim().length();
                if (length > 0 && fileDialog.getFilterPath().charAt(length - 1) != File.separatorChar) {
                    separator = File.separator;
                }
                DeploymentManagementDialog.this.strSelResource = new Path(String.valueOf(fileDialog.getFilterPath()) + separator + fileDialog.getFileName()).toOSString();
                DeploymentManagementDialog.this.txtResourceFile.setText(DeploymentManagementDialog.this.strSelResource);
                DeploymentManagementDialog.this.txtSelectProject.setText("");
                DeploymentManagementDialog.this.updateDeployButton();
                DeploymentManagementDialog.this.updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_DeploysResourceOnDevice, false);
            }
            DeploymentManagementDialog.this.txtResourceFile.setFocus();
        }

        public void widgetDefaultSelected(SelectionEvent event) {
        }
    }
}

