/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dplm.ui.preferences;

import java.util.Vector;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DeploymentManagement;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.ui.util.GridUtil;
import org.eclipse.mtj.extension.dplm.ui.DeploymentManagementUIMessages;
import org.eclipse.mtj.extension.dplm.ui.properties.DeploymentPropertyPage;
import org.eclipse.mtj.extension.dplm.ui.test.TestUtils;
import org.eclipse.mtj.extension.dplm.ui.util.DevicesContentProvider;
import org.eclipse.mtj.extension.dplm.ui.util.DevicesLabelProvider;
import org.eclipse.mtj.extension.dplm.ui.util.ProvidersContentProvider;
import org.eclipse.mtj.extension.dplm.ui.util.ProvidersLabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DeploymentManagementPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer devicesViewer;
    private TableViewer providersViewer;
    private Button btnDeviceProperties;
    private Button btnRefreshList;
    private Button btnProviderProperties;
    private Label lblDescription;
    private ProvidersLabelProvider pLabelProvider = new ProvidersLabelProvider((DeploymentManagement)MtjServices.getInstance().getImplementations(ExtensionType.DEPLOYMENT_MANAGEMENT_LITERAL, null, null)[0]);
    private ProvidersContentProvider pContentProvider = new ProvidersContentProvider();
    private DevicesLabelProvider dLabelProvider = new DevicesLabelProvider();
    private DevicesContentProvider dContentProvider = new DevicesContentProvider();

    public DeploymentManagementPreferencePage() {
        this.setDescription(DeploymentManagementUIMessages.DeploymentManagementPreferencePage_DeploymentPreferencePageDescription);
    }

    protected Control createContents(Composite parent) {
        Composite result = new Composite(parent, 0);
        Link lnkProjectSettings = new Link(result, 0);
        GridData gd = new GridData(768);
        lnkProjectSettings.setLayoutData((Object)gd);
        lnkProjectSettings.setText(DeploymentManagementUIMessages.DeploymentManagementPreferencePage_ConfigureProjectSpecificSettings);
        lnkProjectSettings.setToolTipText(DeploymentManagementUIMessages.DeploymentManagementPreferencePage_ConfigureProjectSpecificSettingsToolTip);
        lnkProjectSettings.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                new DeploymentPropertyPage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group grpProviders = new Group(result, 0);
        grpProviders.setText(DeploymentManagementUIMessages.DeploymentManagementPreferencePage_Providers);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        data.heightHint = 130;
        data.widthHint = 400;
        grpProviders.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 15;
        grpProviders.setLayout((Layout)layout);
        Composite listGrp = new Composite((Composite)grpProviders, 0);
        FillLayout fillLayout = new FillLayout();
        listGrp.setLayout((Layout)fillLayout);
        gd = new GridData(1808);
        listGrp.setLayoutData((Object)gd);
        this.providersViewer = new TableViewer(listGrp, 2336);
        this.pContentProvider.setFilters(1, 3, 5);
        this.providersViewer.setContentProvider((IContentProvider)this.pContentProvider);
        this.providersViewer.setLabelProvider((IBaseLabelProvider)this.pLabelProvider);
        this.providersViewer.setInput(TestUtils.getDevices());
        this.providersViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    DeploymentManagementPreferencePage.this.lblDescription.setText("");
                    return;
                }
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    StringBuffer toShow = new StringBuffer();
                    Object domain2 = null;
                    for (Object domain2 : selection) {
                        String value = DeploymentManagementPreferencePage.this.pLabelProvider.getDescription(domain2);
                        toShow.append(value);
                        toShow.append(", ");
                    }
                    if (toShow.length() > 0) {
                        toShow.setLength(toShow.length() - 2);
                    }
                    DeploymentManagementPreferencePage.this.lblDescription.setText(toShow.toString());
                    Vector<Device> deviceList = new Vector<Device>();
                    Device[] deviceArray = (Device[])DeploymentManagementPreferencePage.this.pContentProvider.getChildren(domain2);
                    int n = 0;
                    int n2 = deviceArray.length;
                    while (n < n2) {
                        Device device = deviceArray[n];
                        deviceList.add(device);
                        ++n;
                    }
                    DeploymentManagementPreferencePage.this.devicesViewer.setInput(deviceList);
                }
            }
        });
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 15;
        result.setLayout((Layout)layout);
        data = GridUtil.createFill();
        result.setLayoutData((Object)data);
        Composite buttonWidget = new Composite((Composite)grpProviders, 0);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.horizontalIndent = 20;
        data.verticalAlignment = 1;
        buttonWidget.setLayoutData((Object)data);
        GridLayout blayout = new GridLayout();
        blayout.numColumns = 1;
        buttonWidget.setLayout((Layout)blayout);
        this.btnProviderProperties = new Button(buttonWidget, 0);
        this.initializeDialogUnits((Control)this.btnProviderProperties);
        this.setButtonLayoutData(this.btnProviderProperties);
        this.btnProviderProperties.setText(DeploymentManagementUIMessages.DeploymentManagementPreferencePage_Properties);
        Group grpDevices = new Group(result, 0);
        grpDevices.setText(DeploymentManagementUIMessages.DeploymentManagementPreferencePage_Devices);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        data.heightHint = 130;
        data.widthHint = 400;
        grpDevices.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 15;
        grpDevices.setLayout((Layout)layout);
        listGrp = new Composite((Composite)grpDevices, 0);
        fillLayout = new FillLayout();
        listGrp.setLayout((Layout)fillLayout);
        gd = new GridData(1808);
        listGrp.setLayoutData((Object)gd);
        this.devicesViewer = new TableViewer(listGrp, 2336);
        this.devicesViewer.setContentProvider((IContentProvider)this.dContentProvider);
        this.devicesViewer.setLabelProvider((IBaseLabelProvider)this.dLabelProvider);
        this.devicesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    DeploymentManagementPreferencePage.this.lblDescription.setText("");
                    return;
                }
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    StringBuffer toShow = new StringBuffer();
                    Object domain2 = null;
                    for (Object domain2 : selection) {
                        String value = DeploymentManagementPreferencePage.this.pLabelProvider.getDescription(domain2);
                        toShow.append(value);
                        toShow.append(", ");
                    }
                    if (toShow.length() > 0) {
                        toShow.setLength(toShow.length() - 2);
                    }
                    DeploymentManagementPreferencePage.this.lblDescription.setText(toShow.toString());
                }
            }
        });
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 15;
        result.setLayout((Layout)layout);
        data = GridUtil.createFill();
        result.setLayoutData((Object)data);
        buttonWidget = new Composite((Composite)grpDevices, 0);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.horizontalIndent = 20;
        data.verticalAlignment = 1;
        buttonWidget.setLayoutData((Object)data);
        blayout = new GridLayout();
        blayout.numColumns = 1;
        buttonWidget.setLayout((Layout)blayout);
        this.btnDeviceProperties = new Button(buttonWidget, 0);
        this.initializeDialogUnits((Control)this.btnDeviceProperties);
        this.setButtonLayoutData(this.btnDeviceProperties);
        this.btnDeviceProperties.setText(DeploymentManagementUIMessages.DeploymentManagementPreferencePage_Properties);
        this.btnRefreshList = new Button(buttonWidget, 0);
        this.initializeDialogUnits((Control)this.btnRefreshList);
        this.setButtonLayoutData(this.btnRefreshList);
        this.btnRefreshList.setText(DeploymentManagementUIMessages.DeploymentManagementPreferencePage_RefreshList);
        Group grpDescription = new Group(result, 0);
        grpDescription.setText(DeploymentManagementUIMessages.DeploymentManagementPreferencePage_Description);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        data.heightHint = 70;
        data.widthHint = 400;
        grpDescription.setLayoutData((Object)data);
        layout = new GridLayout();
        grpDescription.setLayout((Layout)layout);
        listGrp = new Composite((Composite)grpDescription, 0);
        listGrp.setLayoutData((Object)GridUtil.createFill());
        listGrp.setLayout((Layout)new GridLayout());
        this.lblDescription = new Label((Composite)grpDescription, 64);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        this.lblDescription.setLayoutData((Object)data);
        return result;
    }

    public void init(IWorkbench workbench) {
    }

    private Button createButton(Composite parent, String label) {
        Button btn = new Button(parent, 0);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        btn.setLayoutData((Object)data);
        btn.setText(label);
        return btn;
    }
}

